# Behandelt den Bearbeitungsmodus
#  elementare Unformungen und das Umschalten
# zu normal Edititieren

proc editmode_handler win {
    global ${win}_editmode
    set matrix [getmatrix $win]
    global $matrix
    if {[set ${matrix}(editmode)]==[set ${win}_editmode]} return
    set ${matrix}(editmode) [set ${win}_editmode]
    set ${matrix}(oneelemunf) 0
    if {[set ${matrix}(editmode)]=="edit"} {
	pack forget ${win}.elemunf
	pack ${win}.workarea -side top -fill x -after ${win}.toolbar
    } elseif {[set ${matrix}(editmode)]=="elemunf"} {
	if {![winfo exist ${win}.elemunf]} {
	    make_elemunfframe ${win}.elemunf $win
	    set ${matrix}(modi) 0
	}
	pack forget ${win}.workarea
	pack ${win}.elemunf -side top -fill x -after ${win}.toolbar
	matrixtcl $matrix deleteprot
	matrixtcl $matrix addprot editmatrix
	focus $win.elemunf.e0
    }
}
proc make_elemunfframe {win parent} {
    frame ${win} -relief raised -bd 2
    global ${parent}_rowcol ${parent}_modi lan
    tk_optionMenu ${win}.rowcol ${parent}_rowcol $lan(row) $lan(col)
    eval tk_optionMenu ${win}.modi ${parent}_modi $lan(edit_modis)
    label ${win}.l0
    label ${win}.l1
    label ${win}.l2
    entry ${win}.e0
    entry ${win}.e1
    entry ${win}.e2
    change_modi ${win} 0
    button  ${win}.do -text $lan(do_step) -command "unformungen_handler $parent"
#    button  ${win}.undo -text $lan(undo) -command "undo_handler $parent"
    grid ${win}.modi -row 0 -column 0
    grid ${win}.rowcol -row 0 -column 1
    grid ${win}.l0 -row 1 -column 0 -sticky e
    grid ${win}.e0 -row 1 -column 1 -sticky w
    grid ${win}.l1 -row 2 -column 0 -sticky e
    grid ${win}.e1 -row 2 -column 1 -sticky w
    grid ${win}.l2 -row 3 -column 0 -sticky e
    grid ${win}.e2 -row 3 -column 1 -sticky w
    grid ${win}.do -row 4 -column 0
#    grid ${win}.undo -row 4 -column 1
    grid columnconfigure  ${win} 0 -weight 25
    grid columnconfigure  ${win} 1 -weight 75
    if {[trace vinfo ${parent}_modi]==""} {
	trace variable ${parent}_modi w newmodi_handler
    }
}
proc change_modi {win pos} {
    global lan
    set labels [lindex $lan(modis_label) $pos]
    for {set x 0} {$x<3} {incr x} {
	${win}.l$x configure -text [lindex $labels $x]
	if {[lindex $labels $x]=="-"} {
	    ${win}.e$x configure -state disabled
	} else {
	    ${win}.e$x configure -state normal
	}
    }
}
proc newmodi_handler {name1 name2 op} {
    global lan $name1
    regexp {(.*)_modi} $name1 - win
    set matrix [getmatrix $win]
    global $matrix
    set index [lsearch $lan(edit_modis) [set $name1]]
    if {[set ${matrix}(modi)]==$index} return
    # puts "newmodi $name1"
    if {$index>=0} {
	change_modi ${win}.elemunf $index
	set ${matrix}(modi) $index
    }
}
# Liste mit spezifikationnen von Argumnettypen bei einzelnen modis
set modi_types {{index index -} {index factor -} {index factor index} {indexy indexx -} {indexy indexx - -}}
set modi_funktions {swap factormul factoradd pivot changestep}
proc unformungen_handler win {
    set matrix [getmatrix $win]
    global $matrix modi_types modi_funktions lan ${win}_rowcol
    set findex [set ${matrix}(modi)]
    set maxcol [matrixtcl $matrix info size]
    set maxrow [lindex $maxcol 0]
    set maxcol [lindex $maxcol 1]
    if {[set ${win}_rowcol]==$lan(row)} {
	set rowcol row
    } elseif {[set ${win}_rowcol]==$lan(col)} {
	set rowcol col
    } else {
	return 
    }
    for {set x 0} {$x<3} {incr x} {
	set arg$x [$win.elemunf.e$x get]
	set mtype [lindex [lindex $modi_types $findex] $x]
	if {$mtype!="-" && [set arg$x]==""} {
	    tk_messageBox -type ok -title $lan(errormsg) \
		-message $lan(no_arrgument) -icon error
	    return
	}
	if {$mtype=="index"} {
	    if {[set arg$x]<0 || [set arg$x]>=[set max${rowcol}]} {
		tk_messageBox -type ok -title $lan(errormsg) \
		    -message $lan(outof_range) -icon error
		return
	    }
	} elseif {$mtype=="indexy"} {
	    if {[set arg$x]<0 || [set arg$x]>=$maxrow} {
		tk_messageBox -type ok -title $lan(errormsg) \
		    -message $lan(outof_range) -icon error
		return
	    }
	} elseif {$mtype=="indexx"} {
	    if {[set arg$x]<0 || [set arg$x]>=$maxcol} {
		tk_messageBox -type ok -title $lan(errormsg) \
		    -message $lan(outof_range) -icon error
		return
	    }
	}
    }
    set funktion [lindex $modi_funktions $findex]
    switch $funktion {  
	swap {matrixtcl $matrix elemunf swap $rowcol $arg0 $arg1}
	factormul {
	    if {[matrixtcl $matrix info type] == "rational"} {
		regsub -all " " $arg1 "" arg1
		regsub -all "," $arg1 " " arg1
		regsub -all "/" $arg1 " " arg1
		if {[regexp {(^-?[0-9]+)( [0-9]+)*$} $arg1]==0} {
		    tk_messageBox -type ok -title $lan(errormsg) \
			-message $lan(errornofraction) -icon error
		    return
		}
	    } 
	    matrixtcl $matrix elemunf factormul $rowcol $arg0 $arg1
	}
	factoradd {
	    if {[matrixtcl $matrix info type] == "rational"} {
		regsub -all " " $arg2 "" arg2
		regsub -all "," $arg2 " " arg2
		regsub -all "/" $arg2 " " arg2
		if {[regexp {(^-?[0-9]+)( [0-9]+)*$} $arg2]==0} {
		    tk_messageBox -type ok -title $lan(errormsg) \
			-message $lan(errornofraction) -icon error
		    return
		}
	    } 
	    matrixtcl $matrix elemunf factoradd $rowcol $arg0 $arg2 $arg1
	}
	pivot {matrixtcl $matrix elemunf pivot $rowcol $arg0 $arg1}
	changestep {matrixtcl $matrix elemunf changestep $arg0 $arg1}
    }
    refresh_editmatrix $win
    if {[set ${matrix}(oneelemunf)]==0} {
	set ${matrix}(oneelemunf) 1
	activatemenus $win $matrix
    }
}
proc refresh_editmatrix win {
    set matrix [getmatrix $win]
    set name ${win}.can.matrix
    global option
    set size [matrixtcl ${matrix} info size]
    set typ  [matrixtcl ${matrix} info type]
    set lrows [lindex $size 0]
    set lcols [lindex $size 1]
#    puts "$lrows $lcols"
    for {set y 0} {$y<$lrows} {incr y} {
	for {set x 0} {$x<$lcols} {incr x} {
            if {$typ=="rational" && $option(editonlyfraction)==1} {
                set elem [matrixtcl ${matrix} getelem $y $x -onlyfraction]
            } else {
                set elem [matrixtcl ${matrix} getelem $y $x]
            }
	    set${typ}w "${name}.num${y}_${x}" $elem
	}    
    }
    
}
# proc undo_handler win {
#     set matrix [getmatrix $win]
#     global $matrix
#     if {[set ${matrix}(oneelemunf)]==0 || [matrixtcl configure -noprot]==0} {
# 	 return
#     }
#     matrixtcl $matrix undo
#     refresh_editmatrix $win
# }

# Diese Prozedur abgerufen von handlebuttondown whrend elemunf Modus
# Probiert die Mausklick in die Editierfelder zu bertragen
proc buttondown_elemunf {win matrix lrow lcol} {
    global $matrix modi_types
    set modi [set ${matrix}(modi)]
    set focus [focus -lastfor $win]
    if {[regexp {^.*\.elemunf.e([0-9])$} $focus - index]} {
	if {[lindex [lindex $modi_types $modi] $index]=="index"} {
	    global lan ${win}_rowcol
	    if {[set ${win}_rowcol]==$lan(row)} {
		set rowcol row
	    } else {
		set rowcol col
	    }
	    ${win}.elemunf.e${index} delete 0 end
	    ${win}.elemunf.e${index} insert 0 [set l$rowcol]
	}
    }
    if {[lindex [lindex $modi_types $modi] 0]=="indexy"} {
	    ${win}.elemunf.e0 delete 0 end
	    ${win}.elemunf.e0 insert 0 $lrow
	    ${win}.elemunf.e1 delete 0 end
	    ${win}.elemunf.e1 insert 0 $lcol
    }
}
