proc new_dialog type {
    global mywait lan numbertype
    set w .newdialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(newdialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text $lan(newdialogmes)
    frame $w.bot
    frame $w.top -relief raised -bd 1

    label $w.height -text $lan(height)
    entry $w.eheight -width 5
    if {$type!="einheitsmatrix"} {
	entry $w.ewidth -width 5
    }
    if {$type=="randommatrix"} {
	label $w.maxnum -text $lan(maxnum)
	entry $w.emaxnum -width 5
	$w.emaxnum insert 0 100
	label $w.maxden -text $lan(maxden)
	entry $w.emaxden -width 5
	$w.emaxden insert 0 100
    }
    label $w.width -text $lan(width)
    set numbertype -rational
    radiobutton $w.rrational -text $lan(rationaltype) -variable numbertype \
	-value "-rational"	
    radiobutton $w.rfloat -text $lan(floattype) -variable numbertype \
	-value "-float"	
    radiobutton $w.rwidefloat -text $lan(widefloattype) -variable numbertype \
	-value "-widefloat"
    button $w.ok -text $lan(dialogok) -command "set mywait ok"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    


    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10  
    
    grid $w.height -in $w.top -column 0 -row 0 -sticky e
    grid $w.eheight -in $w.top -column 1 -row 0

    if {$type!="einheitsmatrix"} {
	grid $w.width -in $w.top -column 0 -row 1 -sticky e
	grid $w.ewidth -in $w.top -column 1 -row 1
    }
    if {$type=="randommatrix"} {
	grid $w.maxnum -in $w.top -column 0 -row 5 -sticky e
	grid $w.emaxnum -in $w.top -column 1 -row 5
	grid $w.maxden -in $w.top -column 0 -row 6 -sticky e
	grid $w.emaxden -in $w.top -column 1 -row 6
    }
    grid $w.rrational -in $w.top -column 0 -row 2 -columnspan 2  -sticky w
    grid $w.rfloat -in $w.top -column 0 -row 3 -columnspan 2  -sticky w
    grid $w.rwidefloat -in $w.top -column 0 -row 4 -columnspan 2  -sticky w

    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    switch $type {
	nullmatrix {
	    set ret [list [$w.eheight get] [$w.ewidth get] $numbertype]
	}
	einheitsmatrix {
	    set ret [list [$w.eheight get] [$w.eheight get] $numbertype]
	}
	randommatrix {
	    set ret [list [$w.eheight get] [$w.ewidth get] $numbertype \
			 [$w.emaxnum get] [$w.emaxden get]]
	}
    }
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}
# Bei breite -1 wird es nicht bercksichtigt
# wichtig fr multiplikation
proc op_dialog {type hoehe breite} {
    global whandle matrixlist
    set mlist {}
    foreach matrix $matrixlist {
	set matrix [lindex $matrix 0]
	# puts "matrix is $matrix"
	global $matrix
	if {[string compare $type [matrixtcl $matrix info type]]==0} {
	    set size [matrixtcl $matrix info size]
	    if {[lindex $size 0]==$hoehe && ([lindex $size 1]==$breite || $breite==-1)} {
		if {[info exists ${matrix}(filename)]} {
		    global $matrix
		    lappend mlist [list $matrix [file tail [set ${matrix}(filename)]]]
		} else {
		    lappend mlist [list $matrix $matrix]
		}
	    }
	}
    }
    global lan
    if {[llength $mlist]==0} {
	tk_messageBox -type ok -title $lan(errormsg) \
	    -message $lan(operror) -icon error
	return
    }
    global mywait
    set w .opdialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(opdialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text $lan(opdialogmes)
    frame $w.bot
    frame $w.top -relief raised -bd 1

    listbox $w.matrix -relief raised -borderwidth 2 \
	-yscrollcommand "$w.scroll set"
    scrollbar $w.scroll -command "$w.matrix yview"
    foreach a $mlist {
	# puts "a ist $a"
	$w.matrix insert end [lindex $a 1]
    }
    $w.matrix selection set 0
    
    button $w.ok -text $lan(dialogok) -command "set mywait ok"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    


    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10  

    pack $w.matrix -in $w.top -side left -expand yes -fill both
    pack $w.scroll -in $w.top -side right -fill y

    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    set ret [$w.matrix curselection]
    set ret [lindex [lindex $mlist $ret] 0]
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}

proc resize_dialog matrix {
    global mywait lan resizetop resizeleft
    set w .resizedialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(resizedialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text $lan(resizedialogmes)
    frame $w.bot
    frame $w.top -relief raised -bd 1

    label $w.height -text $lan(height)
    label $w.width -text $lan(width)
#    label $w.maxheight -text [lindex [matrixtcl $matrix info size] 0]
#    label $w.maxwidth -text [lindex [matrixtcl $matrix info size] 1]
    entry $w.eheight -width 5
    $w.eheight insert 0 [lindex [matrixtcl $matrix info size] 0]
    entry $w.ewidth -width 5
    $w.ewidth insert 0 [lindex [matrixtcl $matrix info size] 1]
    checkbutton $w.resizetop -text $lan(resizetop) -variable resizetop
    checkbutton $w.resizeleft -text $lan(resizeleft) -variable resizeleft
    button $w.ok -text $lan(dialogok) -command "set mywait ok"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    


    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10  
    
    grid $w.height -in $w.top -column 0 -row 0 -sticky e
 #   grid $w.maxheight -in $w.top -column 2 -row 0 -sticky w
    grid $w.width -in $w.top -column 0 -row 1 -sticky e
 #   grid $w.maxwidth -in $w.top -column 2 -row 1 -sticky w
    grid $w.eheight -in $w.top -column 1 -row 0
    grid $w.ewidth -in $w.top -column 1 -row 1
    grid $w.resizetop -in $w.top -column 0 -row 2 -columnspan 2
    grid $w.resizeleft -in $w.top -column 0 -row 3 -columnspan 2

    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    set ret [list [$w.eheight get] [$w.ewidth get] $resizetop $resizeleft]
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}
proc paste_dialog {} {
    global mywait lan corner
    set w .pastedialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(pastedialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text $lan(pastedialogmes)
    frame $w.bot
    frame $w.top -relief raised -bd 1

    if {![info exist corner]} {
	set corner TopLeft
    }
    radiobutton $w.topleft -text $lan(topleft) -variable corner \
	-value TopLeft
    radiobutton $w.topright -text $lan(topright) -variable corner \
	-value TopRight
    radiobutton $w.bottomleft -text $lan(bottomleft) -variable corner \
	-value BottomLeft
    radiobutton $w.bottomright -text $lan(bottomright) -variable corner \
	-value BottomRight
    button $w.ok -text $lan(dialogok) -command "set mywait ok"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    


    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10  
    
    grid $w.topleft -in $w.top -column 0 -row 0
    grid $w.topright -in $w.top -column 1 -row 0
    grid $w.bottomleft -in $w.top -column 0 -row 1
    grid $w.bottomright -in $w.top -column 1 -row 1

    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    set ret [list $corner]
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}
proc pivot_dialog {{ycord ""} {xcord ""}} {
    global mywait lan
    set w .pivotdialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(pivotdialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text $lan(pivotdialogmes)
    frame $w.bot
    frame $w.top -relief raised -bd 1

    label $w.height -text $lan(pheight)
    label $w.width -text $lan(pwidth)
    entry $w.eheight -width 5
    entry $w.ewidth -width 5
    $w.eheight insert 0 $ycord
    $w.ewidth insert 0 $xcord
    button $w.ok -text $lan(dialogok) -command "set mywait ok"
    button $w.cancel  -text $lan(dialogcancel) -command "set mywait cancel"
    


    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10  
    
    grid $w.height -in $w.top -column 0 -row 0 -sticky e
    grid $w.width -in $w.top -column 0 -row 1 -sticky e
    grid $w.eheight -in $w.top -column 1 -row 0
    grid $w.ewidth -in $w.top -column 1 -row 1

    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    set ret [list [$w.eheight get] [$w.ewidth get]]
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}

proc language_dialog {} {
    global mywait progdir rb_language
    set w .landialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w "choose language"
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    message $w.msg -relief raised -bd 1 -text "choose language" -width 4c
    frame $w.bot
    frame $w.top -relief raised -bd 1
    button $w.ok -text ok -command "set mywait ok"
    button $w.ok2 -text {use also for next sesion} -command "set mywait ok2"
    
    foreach lan [glob [file join $progdir *.lan]] {
	set lname [file tail [file rootname $lan]]
	radiobutton $w.rb$lname -text $lname -variable rb_language -value $lname
	pack $w.rb$lname -side top -in $w.top
    }
    # preselected language is german
    set rb_language german

    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    grid  $w.ok2 -in $w.bot -column 1 -row 0 -sticky ew -padx 10  
    pack $w.msg -side top -fill both
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> { set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    set ret [list $rb_language $mywait]
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    
    if {$mywait == "cancel"} { 
	return 
    } else {
	return $ret
    }
}

