# Benutzt von About Dialog Handlers um mehr Infos anzuzeigen
proc myinfo mes {
    global lan
    set infovar info$mes
    set w .aboutdialog
    pack forget $w.msg
    if {[winfo exists $w.imsg]!=1} {
	frame $w.imsg
	scrollbar $w.imsg.scroll -orient vertical -command "$w.imsg.infotext yview" 
	text $w.imsg.infotext -yscrollcommand "$w.imsg.scroll set" -width 30 -height 12 -wrap word
	pack $w.imsg -side right -in $w.top -expand yes -fill x
	pack $w.imsg.infotext -side left -expand yes -fill both
	pack $w.imsg.scroll -side left -fill y
	$w.imsg.infotext insert 1.0 $lan($infovar)
    } else {
	$w.imsg.infotext delete 1.0 end
	$w.imsg.infotext insert 1.0 $lan($infovar)
    }
}
# About Dialog
proc about {} {
    global lan progdir
    set w .aboutdialog
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $lan(aboutdialogtitle)
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    catch {focus $oldFocus}    
    image create photo image2a

    image2a configure -file [file join $progdir images artur.gif]

    frame $w.bot
    frame $w.buttons -relief raised -bd 1
    frame $w.top -relief raised -bd 1

    message $w.msg -text "program: tkmatrix\nVersion 0.6.2 Date 03.2000\nAuthor: Artur Trzewik\nall rights reserved\nemail: sw0562@uni-essen.de\nhomepage: http://swt.wi-inf.uni-essen.de/~atrzewik\n\nIf you enjoy it send me a post card\nfrom your hometown\n    Artur Trzewik\n    Andreas-Hoferstr 4\n    42275 Wuppertal\n    GERMANY" -width 1000
    label $w.image -image image2a
    button $w.ok -text $lan(dialogok) -command "set mywait ok"

    button $w.whatitis -text $lan(whatitis) -command "myinfo whatitis"
    button $w.development -text $lan(development) -command "myinfo development"
    button $w.licence -text $lan(licence) -command "myinfo licence"
    button $w.aboutautor -text $lan(aboutautor) -command "myinfo aboutautor"
    button $w.important -text $lan(important) -command "myinfo important"
    button $w.version -text $lan(version) -command "myinfo version"
    

    grid $w.whatitis $w.development  $w.version -in $w.buttons -sticky ew
    grid $w.licence $w.aboutautor $w.important -row 1 -in $w.buttons -sticky ew
    
    grid  $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10  
    
    pack $w.image -side left -padx .5c -pady .5c -in $w.top 
    pack $w.msg -side left -in $w.top
    pack $w.top -side top -fill both -expand 1
    pack $w.buttons
    pack $w.bot -side bottom -fill both

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> {set mywait cancel}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w
    

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable mywait
    catch {image delete image2a}
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
}
#
# This code was taken and modified form specTcl Program
#
proc matrixhelp {} {
    global tcl_platform progdir
    if {$tcl_platform(platform)=="windows"} {
	winhelp [file join $progdir tkmatrix.hlp]
    } else {
	global helpdir lan option errorInfo
	if {$option(netscape_remote)} {
	    set ret [catch {exec netscape -remote "openFile ([file join $helpdir $lan(helpfile)])"}]
	    if {$ret!=0} {
		if {"no"==[tk_messageBox -title $lan(errormsg) -message $lan(lunch_browser) -icon question -type yesno]} {
		    return
		}
	    } else {
		return
	    }
	}
	set command [format $option(htmlhelpviewer) [file join $helpdir $lan(helpfile)]]
	#   puts "com $command helpdir $helpdir"
	set ret [catch { eval exec $command & }]
	if {$ret != 0} {
	    tk_messageBox -title $lan(errormsg) -message "$lan(nohelpviewer) Command:\"$command\" Error:\"$errorInfo\"" -icon error -type ok
	    return
	}
    }
}
# 
# XRemote Netscape um homepage des Autors zu Laden
#
proc wwwlink_autor {} {
    set homepage http://swt.wi-inf.uni-essen.de/~atrzewik
    global tcl_platform progdir
    if {$tcl_platform(platform)=="windows"} {
	tk_messageBox -title $lan(errormsg) -message "$lan(nowww_winsupport) \n$homepage" -icon error -type ok
	return
    } else {
	global helpdir lan option errorInfo
	if {$option(netscape_remote)} {
	    set ret [catch {exec netscape -remote "openURL ($homepage)"}]
	    if {$ret!=0} {
		if {"no"==[tk_messageBox -title $lan(errormsg) -message $lan(lunch_browser) -icon question -type yesno]} {
		    return
		}
	    } else {
		return
	    }
	}
	set command [format $option(htmlhelpviewer) $homepage]
	#   puts "com $command helpdir $helpdir"
	set ret [catch { eval exec $command & }]
	if {$ret != 0} {
	    tk_messageBox -title $lan(errormsg) -message "$lan(nohelpviewer) Command:\"$command\" Error:\"$errorInfo\"" -icon error -type ok
	    return
	}
    }
}










