/*regres version 0.2 
(c) 2001 Paul Boekholt (p.boekholt@hetnet.nl)
copyright under the GNU GPL*/
#include <stdio.h>
#include <stdlib.h>

#define MAXLINELENGTH 100

void read_input(void);
void compute(void);
double x_sum, y_sum, xx_sum, xy_sum;
int n; /* number of cases */

main(int argc, char *argv[])
{
	if (argc != 1)
		printf("This is regres 0.2 by Paul Boekholt (p.boekholt@hetnet.nl)\n\n\
Usage: %s < INPUT\n where INPUT looks like something like this:\n\
	x(1) y(1) y(2) ... y(n) \n\
	x(2) y(n+1) y(n+2) ...\n\
	etc,\n\
where x is the independent and y is the dependent variable.\n\
Don't use 0-9 - + . E or e as field separators\n\
Maximum input line length =  %d characters\n\
if that's not enough, recompile\n\
\n", argv[0], MAXLINELENGTH);
	else {
		read_input();
		compute();
	}
}

void read_input(void)
{	
	double x, y;
	char s[MAXLINELENGTH];
	char *h, *t; /*head, tail*/
	while (fgets(s, MAXLINELENGTH, stdin)) {
		h = s;    /*read in the independent variable*/ 
		x = strtod (h, &t);
		while (h == t && *h != '\n' && *h != EOF && *h) {
			h++; /*skip rubbish*/
			x = strtod (h, &t);
		}
		while (*h != '\n' && *h != EOF && *h) { /*read in the dependent variables */
			h = t;
			y = strtod (h, &t);
			while (h == t && *h != '\n' && *h != EOF && *h) {
				h++;  /*skip rubbish*/
				y = strtod (h, &t);
			}
			if (!*h) {  /*end of string*/
				printf("line was too long!");
				exit (EXIT_FAILURE);
			}
			if (h != t) {
				x_sum += x;
				xx_sum += x*x;
				y_sum += y;
				xy_sum += x*y;
				n++;
			}
		}
	}
}

void compute(void)
{
	double b1, b0;
	double x_avg, y_avg;
	x_avg = x_sum / n;
	y_avg = y_sum / n;
	b1 = (xy_sum - x_sum * y_avg) / (xx_sum - x_sum * x_avg);
	b0 = y_avg - b1 * x_avg;
	printf ("No. of cases: %d\nAverage of x: %g\nAverage of y: %g\n" ,n, x_avg, y_avg);
	printf("intercept = %g\nslope = %g\n", b0, b1);
}

