/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

//Main routine for mtk

#include <qapp.h>
#include <qfont.h>
#include <stdio.h>
#include <qtstream.h>
#include "mainwin.h"

int main(int argc, char *argv[])
{
  QApplication app(argc, argv);
  QTextStream cout( stdout, IO_WriteOnly );
  QTextStream cerr( stderr, IO_WriteOnly );

  int i = 1, configpos = 0, filepos = 0;
  char *config;
  char *file;
  
  while (i<app.argc()) {
    if ((app.argv()[i][0] != '-') || ( strlen(app.argv()[i]) > 2 )) {
      cerr << "Unknown option " << app.argv()[i] << '\n';
      return -1;
    }
    switch (app.argv()[i][1]) {
    case 'c' :
      i++;
      configpos = i;
      break;
    case 'f' :
      i++;
      filepos = i;
      break;
    case 'h' :
      cout << "Usage: mtk [OPTION] \n\n";
      cout << "  -c FILE      use configuration file FILE\n";
      cout << "  -f FILE      load file FILE\n";
      cout << "  -h           display this help and exit\n"; 
      cout << "  -v           display version and exit\n\n"; 
      return 0;
    case 'v' :
      cout << "mtk version 1.3.0\n";
      return 0;
    default :
      cerr << "Unknown option " << app.argv()[i] << '\n';
      return -1;
    } 
    i++;
  }
  
  if (configpos != 0) {
    config = app.argv()[configpos];
  }
  else {
    config = NULL;
  }

  if (filepos != 0) {
    file = app.argv()[filepos];
  }
  else {
    file = NULL;
  }

  app.setFont( QFont( "default", 12, QFont::Bold, FALSE ) );
  Math_Main main_win(0,config,file,"Maths Toolkit");
  app.setMainWidget(&main_win);
  main_win.show();
  return app.exec();
}


