/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for PowerVar dialog class

#include "powervar.h"
#include <qpushbt.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qregexp.h>

PowerVar::PowerVar(Equation *eqn, int *v, uint *t, Parser *p, const char *name) : EqnDialog(p,0,name,TRUE)
{
  QString text;
  equation = eqn;
  varnum = v;
  terms = t;
  *v = 1;
  *terms = 5;

  resize( 350 , 230 );

  QLabel *label = new QLabel( "Power Series", this );
  label->setGeometry(30,10,290,15);
  label->setAlignment( AlignCenter );

  listbox = new QListBox(this);   // Set up listbox of variables
  var = equation->Variables.first();
  while ( var ) {
    listbox->insertItem(var->Name);
    var = equation->Variables.next();
  }
  var = equation->Variables.first();
  listbox->setGeometry( 30, 50, 100, 110 );
  listbox->setCurrentItem( 0 );
  connect( listbox, SIGNAL(selected(int)), SLOT(listbox_selected(int)) );
  connect( listbox, SIGNAL(highlighted(int)), SLOT(listbox_selected(int)) );
  label = new QLabel( "Variable", this );
  label->setGeometry(30,30,100,15);
  label->setAlignment( AlignCenter );

  value_edit = new QLineEdit(this);   // Set up line edit for value
  value_edit->setGeometry( 180, 50, 150, 30 );
  text.setNum( var->Value , 'G' );
  value_edit->setText( text );
  connect( value_edit, SIGNAL(returnPressed()), SLOT(button_ok()) );
  label = new QLabel( "Value", this );
  label->setGeometry(180,30,100,20);
  label->setAlignment( AlignCenter );

  terms_edit = new QLineEdit(this);   // Set up line edit for number of terms
  terms_edit->setGeometry( 180, 110, 150, 30 );
  text.setNum(*terms);
  terms_edit->setText( text );
  connect( terms_edit, SIGNAL(returnPressed()), SLOT(button_ok()) );
  label = new QLabel( "Number of terms", this );
  label->setGeometry(180,90,100,20);
  label->setAlignment( AlignCenter );

  QPushButton *button = new QPushButton("OK",this); // Set up Change button
  button->setGeometry( 50, 180, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Done button
  button->setGeometry( 230, 180, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  listbox->setFocus();

}

PowerVar::~PowerVar()
{
  delete listbox;
  delete value_edit;
}

// Get value from line edit and change value of variable 
void PowerVar::button_ok()
{
  bool error_check;
  double value;
  QString terms_text( terms_edit->text() );
  
  value = EvalText( value_edit->text() );
  if ( !Error ) {
    var->Value = value;
  }
  else {
    QMessageBox::message("Error!","Not a valid value");
    return;
  };

  *terms = terms_text.toUInt(&error_check);
  if (!error_check) {
    QMessageBox::message("Error!","Must specify a positive number of terms");
    return;
  };

  accept();
}

// Change current variable when listbox selected and update value to edit
void PowerVar::listbox_selected(int selection)    
{
  QString text;

  var = equation->Variables.at(selection);
  if (var) {
    text.setNum( var->Value , 'G' );
    value_edit->setText( text );
    value_edit->update();
  };
  *varnum = selection+1;
}

#include "powervar.moc"
