/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for NumODE dialog class

#include "numode.h"
#include "setvar.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qregexp.h>

NumODE::NumODE( int *vx, int *vy, range *range, Equation *equation, Parser *p, char *name ) : EqnDialog( p, 0, name, TRUE )
{
  variable *var;
  QString text;

  var_num_x = vx;
  var_num_y = vy;
  equ = equation;
  Range = range;

  resize( 490 , 320 );

  QLabel *label = new QLabel( "Solve ODE", this );
  label->setGeometry(50,10,390,15);
  label->setAlignment( AlignCenter );

  label = new QLabel( "x variable", this );   // Text above x listbox
  label->setGeometry(30,40,100,15);
  label->setAlignment( AlignCenter );

  listbox_x = new QListBox(this);   // Set up listbox of x variables
  listbox_x->insertItem("NONE");
  var = equation->Variables.first();
  while ( var ) {
    listbox_x->insertItem(var->Name);
    var = equation->Variables.next();
  }
  listbox_x->setGeometry( 30, 70, 100, 110 );
  listbox_x->setCurrentItem( 0 );
  connect( listbox_x, SIGNAL(selected(int)), SLOT(button_ok()) );

  label = new QLabel( "y variable", this );   // Text above y listbox
  label->setGeometry(160,40,100,15);
  label->setAlignment( AlignCenter );

  listbox_y = new QListBox(this);   // Set up listbox of y variables
  listbox_y->insertItem("NONE");
  var = equation->Variables.first();
  while ( var ) {
    listbox_y->insertItem(var->Name);
    var = equation->Variables.next();
  }
  var = equation->Variables.first();
  listbox_y->setGeometry( 160, 70, 100, 110 );
  listbox_y->setCurrentItem( 0 );
  connect( listbox_y, SIGNAL(selected(int)), SLOT(button_ok()) );

  label = new QLabel("Range",this);    // Set up labels
  label->setGeometry( 310, 30, 150, 15 );

  edit_from = new QLineEdit(this);   // Set up line edit for from
  edit_from->setGeometry( 310, 70, 150, 30 );
  text.setNum( Range->From , 'G' );
  edit_from->setText( text );
  label = new QLabel("From",this);
  label->setGeometry( 310, 50, 150, 15 );
  connect(edit_from, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_to = new QLineEdit(this);   // Set up line edit for to
  edit_to->setGeometry( 310, 130, 150, 30 );
  text.setNum( Range->To , 'G' );
  edit_to->setText( text );
  label = new QLabel("To",this);
  label->setGeometry( 310, 110, 150, 15 );
  connect(edit_to, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_step = new QLineEdit(this);   // Set up line edit for step size
  edit_step->setGeometry( 310, 190, 150, 30 );
  text.setNum( Range->Step , 'G' );
  edit_step->setText( text );
  label = new QLabel("Step size",this);
  label->setGeometry( 310, 170, 150, 15 );
  connect(edit_step, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_start_val = new QLineEdit(this);   // Set up line edit for initial value
  edit_start_val->setGeometry( 310, 250, 150, 30 );
  edit_start_val->setText( "0" );
  label = new QLabel("Initial y value",this);
  label->setGeometry( 310, 230, 150, 15 );
  connect(edit_start_val, SIGNAL(returnPressed()), SLOT(button_ok()) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button
  button->setGeometry( 40, 260, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->setGeometry( 170, 260, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  button = new QPushButton("Set\nVariables",this);  // Set up Set Variables button
  button->setGeometry( 40, 205, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(set_var()) );


  listbox_x->setFocus();  
}

NumODE::~NumODE()
{
  delete listbox_x;
  delete listbox_y;
  delete edit_from;
  delete edit_to;
  delete edit_step;
  delete edit_start_val;
}

// Set Variables button pressed
void 
NumODE::set_var()
{
  SetVar SetVarVal( equ, NULL, parser );
  SetVarVal.exec();
}


// Change variable when OK pressed and return
void NumODE::button_ok()
{
  range r;

  r.From = EvalText( edit_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };

  r.To = EvalText( edit_to->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

  r.Step = EvalText( edit_step->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid step size");
    return;
  };

  r.Accuracy = EvalText( edit_start_val->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid initial value");
    return;
  };

  if ( r.From >= r.To ) {
    QMessageBox::message("Error!","from value must be less than to value");
    return;
  };

  if ( r.Step <= 0 ) {
    QMessageBox::message("Error!","step size must be positive");
    return;
  };

  *var_num_x = listbox_x->currentItem();
  *var_num_y = listbox_y->currentItem();
  Range->From = r.From;
  Range->To = r.To;
  Range->Step = r.Step;
  Range->Accuracy = r.Accuracy;

  accept();
}

#include "numode.moc"







