/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef GRAPHPREF_H_
#define GRAPHPREF_H_
/* Header file for GraphPref dialog class */

#include "eqndialog.h"
#include <qradiobt.h>
#include <qlined.h>
#include "graph.h"

class GraphPref : public EqnDialog
{
  Q_OBJECT
 public:
  GraphPref( graphsize *, bool *, Parser *, char * =0 );
  ~GraphPref();

 public slots:
  void button_ok();
  void autopressed(int);

 protected:
  void grey();
  void ungrey();

 protected:
  QRadioButton *autobutton;
  QLineEdit *edit_xmin;
  QLineEdit *edit_xmax;
  QLineEdit *edit_ymin;
  QLineEdit *edit_ymax;
  graphsize *graphrange;
  bool *autoset;

};

#endif /* GRAPHPREF_H_ */
