/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for GraphPref dialog class

#include "grpref.h"
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qlabel.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qregexp.h>

GraphPref::GraphPref( graphsize *size, bool *a, Parser *p, char *name ) : EqnDialog( p, 0, name, TRUE )
{
  QString text;

  graphrange = size;
  autoset = a;

  resize( 370 , 300 );

  QLabel *label = new QLabel( "Graph Preferences", this);
  label->setGeometry(30,10,310,15);
  label->setAlignment( AlignCenter );

  label = new QLabel( "x variable", this );   // Text above x listbox
  label->setGeometry(30,50,100,15);
  label->setAlignment( AlignCenter );

  QButtonGroup *bg = new QButtonGroup(this);   // Set up radio buttons
  bg->setTitle("Set range");
  autobutton = new QRadioButton("Manual",bg);
  autobutton->setGeometry(10,45,120,25);
  if (!*autoset) autobutton->setChecked(TRUE);
  autobutton = new QRadioButton("Auto",bg);
  autobutton->setGeometry(10,15,120,25);
  if (*autoset) autobutton->setChecked(TRUE);
  bg->setGeometry(20,50,140,80);
  connect(bg, SIGNAL(pressed(int)), SLOT(autopressed(int)) );

  label = new QLabel("Range",this);    // Set up labels
  label->setGeometry( 190, 30, 150, 20 );

  edit_xmin = new QLineEdit(this);   // Set up line edit for xmin
  edit_xmin->setGeometry( 190, 70, 150, 30 );
  text.setNum( graphrange->xmin , 'G' );
  edit_xmin->setText( text );
  label = new QLabel("x min",this);
  label->setGeometry( 190, 50, 150, 20 );
  connect(edit_xmin, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_xmax = new QLineEdit(this);   // Set up line edit for x max
  edit_xmax->setGeometry( 190, 130, 150, 30 );
  text.setNum( graphrange->xmax , 'G' );
  edit_xmax->setText( text );
  label = new QLabel("x max",this);
  label->setGeometry( 190, 110, 150, 20 );
  connect(edit_xmax, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_ymin = new QLineEdit(this);   // Set up line edit for y min
  edit_ymin->setGeometry( 190, 190, 150, 30 );
  text.setNum( graphrange->ymin , 'G' );
  edit_ymin->setText( text );
  label = new QLabel("y min",this);
  label->setGeometry( 190, 170, 150, 20 );
  connect(edit_ymin, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_ymax = new QLineEdit(this);   // Set up line edit for y max
  edit_ymax->setGeometry( 190, 250, 150, 30 );
  text.setNum( graphrange->ymax , 'G' );
  edit_ymax->setText( text );
  label = new QLabel("y max",this);
  label->setGeometry( 190, 230, 150, 20 );
  connect(edit_ymax, SIGNAL(returnPressed()), SLOT(button_ok()) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button
  button->setGeometry( 40, 190, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->setGeometry( 40, 240, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  if ( *autoset ) grey();

  bg->setFocus();
}

GraphPref::~GraphPref()
{
  delete edit_xmin;
  delete edit_xmax;
  delete edit_ymin;
  delete edit_ymax;
}

// Grey edit boxes
void GraphPref::grey()
{
  edit_xmin->setEnabled(FALSE);
  edit_xmax->setEnabled(FALSE);
  edit_ymin->setEnabled(FALSE);
  edit_ymax->setEnabled(FALSE);

  edit_xmin->repaint();
  edit_xmax->repaint();
  edit_ymin->repaint();
  edit_ymax->repaint();
}

// Ungrey edit boxes
void GraphPref::ungrey()
{
  edit_xmin->setEnabled(TRUE);
  edit_xmax->setEnabled(TRUE);
  edit_ymin->setEnabled(TRUE);
  edit_ymax->setEnabled(TRUE);

  edit_xmin->repaint();
  edit_xmax->repaint();
  edit_ymin->repaint();
  edit_ymax->repaint();
}

// Grey/ungrey dialogs when auto selected
void GraphPref::autopressed( int id )
{
  if ( id == 0 ) {
    ungrey();
  }
  else {
    grey();
  };
}

// Change graph values when OK pressed and return
void GraphPref::button_ok()
{
  graphsize r;
  bool isset;

  isset=autobutton->isOn();
  if ( !isset ) {
  
    r.xmin = EvalText( edit_xmin->text() );
    if ( Error ) {
      QMessageBox::message("Error!","Not a valid x min value");
      return;
    };
    
    r.xmax = EvalText( edit_xmax->text() );
    if ( Error ) {
      QMessageBox::message("Error!","Not a valid x max value");
      return;
    };

    r.ymin = EvalText( edit_ymin->text() );
    if ( Error ) {
      QMessageBox::message("Error!","Not a valid y min value");
      return;
    };

    r.ymax = EvalText( edit_ymax->text() );
    if ( Error ) {
      QMessageBox::message("Error!","Not a valid y max value");
      return;
    };
    
    if ( r.xmin >= r.xmax ) {
      QMessageBox::message("Error!","x max value must be greater than x min value");
      return;
    };
    
    if ( r.ymin >= r.ymax ) {
      QMessageBox::message("Error!","y max value must be greater than y min value");
      return;
    };

    graphrange->xmin = r.xmin;
    graphrange->xmax = r.xmax;
    graphrange->ymin = r.ymin;
    graphrange->ymax = r.ymax;
  };
  *autoset = isset;

  accept();
}

#include "grpref.moc"
