/*	$Id: misc.c,v 1.3 1997/05/01 17:34:50 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <assert.h>
#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "matrici.h"
#include "umatrix.h"

double leggi_double(char *fmt, ...)
{
	char buf[128];
	va_list ap;

	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	printf(": ");
	fflush(stdout);
	fgets(buf, 128, stdin);
	return strtod(buf, NULL);
}

long leggi_long(char *fmt, ...)
{
	char buf[128];
	va_list ap;

	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	printf(": ");
	fflush(stdout);
	fgets(buf, 128, stdin);
	return strtol(buf, NULL, 0);
}

static void leggi_righe_colonne(int *r, int *c)
{
	do *r = leggi_long(getstr("Numero righe")); while (*r <= 0);
	do *c = leggi_long(getstr("Numero colonne")); while (*c <= 0);
}

Matrice matr_leggi(char *nome)
{
	int r, c;
	Matrice m;

	printf(getstr("Creazione matrice `%s'\n"), nome);
	leggi_righe_colonne(&r, &c);

	m = matr_crea(nome, r, c);

	for (r = 1; r <= m->righe; r++)
	for (c = 1; c <= m->colonne; c++)
		valore(m, r, c) = leggi_double("%s[%d,%d]", nome, r, c);

	return m;
}

Matrice matr_leggi_casuale(char *nome)
{
	int r, c, min, max;
	Matrice m;

	printf(getstr("Creazione matrice casuale `%s'\n"), nome);
	leggi_righe_colonne(&r, &c);

	min = leggi_long(getstr("Elemento minimo"));
	do max = leggi_long(getstr("Elemento massimo")); while (max < min);
	m = matr_crea_valori_casuali(nome, r, c, min, max);

	return m;
}

Matrice matr_leggi_unita(char *nome)
{
	int ordine;
	Matrice m;

	printf(getstr("Creazione matrice unita` `%s'\n"), nome);
	do ordine = leggi_long(getstr("Ordine")); while (ordine <= 1);
	m = matr_crea_matrice_unita(nome, ordine);

	return m;
}
