/*	$Id: matrici.h,v 1.2 1997/04/30 15:39:28 sandro Exp $	*/

#ifndef _MATRICI_H
#define _MATRICI_H

typedef struct matrice {
	char *nome;
	int righe, colonne;
	double *valori;
} *Matrice;

/* Funzioni. */
double valore(Matrice m, int riga, int colonna);
Matrice matr_crea(char *nome, int righe, int colonne);
void matr_elimina(Matrice m);
void matr_stampa(Matrice m);
Matrice matr_somma(char *nome, Matrice m1, Matrice m2);
Matrice matr_prodotto_per_numero(char *nome, Matrice m, double n);
Matrice matr_prodotto(char *nome, Matrice m1, Matrice m2);
Matrice matr_trasposta(char *nome, Matrice m);
void matr_assegna_valori_casuali(Matrice m, int min, int max);
Matrice matr_crea_valori_casuali(char *nome, int righe, int colonne, int min, int max);
Matrice matr_crea_matrice_unita(char *nome, int ordine);
double matr_determinante(Matrice m);

/* Predicati. */
int matr_quadrata_p(Matrice m);
int matr_rettangolare_p(Matrice m);
int matr_unita_p(Matrice m);
int matr_simmetrica_p(Matrice m);
int matr_stesso_tipo_p(Matrice m1, Matrice m2);
int matr_eguali_p(Matrice m1, Matrice m2);

/*
 * Versione macro delle funzioni precedenti.
 */

#define valore(m, riga, colonna) \
	m->valori[(riga-1) * m->colonne + (colonna-1)]

#define matr_quadrata_p(m) \
	(m->righe == m->colonne)

#define matr_rettangolare_p(m) \
	(m->righe != m->colonne)

#define matr_stesso_tipo_p(m1, m2) \
	(m1->righe == m2->righe && m1->colonne == m2->colonne)

#endif /* !_MATRICI_H */
