/*	$Id: lingua.c,v 1.2 1997/05/01 18:15:13 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdlib.h>

#include "matrici.h"
#include "umatrix.h"

int lingua = LINGUA_INGLESE;

char *aiuto_tbl[] = {
/* Italiano */ "\
Comandi disponibili:\n\
	crea			Crea una matrice\n\
	creacasuale		Crea una matrice con valori casuali\n\
	creaunita`		Crea una matrice unita`\n\
	determinante		Calcola il determinante della matrice\n\
	elimina			Elimina la matrice dallo stack\n\
	prodotto		Calcola il prodotto matriciale\n\
	prodottopernumero	Calcola il prodotto per un numero\n\
	somma			Somma due matrici\n\
	trasposta		Produce la trasposta della matrice\n\
\n\
	aiuto			Visualizza questa pagina di aiuto\n\
	parametri		Modifica i parametri del programma\n\
	esci			Esci dal programma\n\
\n\
Predicati disponibili:\n\
	?quadrata, ?rettangolare, ?unita`, ?simmetrica, ?stessotipo,\n\
	?eguali\n\
\n",
/* Inglese */ "\
Available commands:\n\
	create			Create a matrix\n\
	createrandom		Create a matrix with random values\n\
	createunit		Create a unit matrix\n\
	determinant		Compute the determinant of the matrix\n\
	delete			Delete the matrix from the stack\n\
	product			Compute the matrices product\n\
	productfornumber	Compute the product for a number\n\
	sum			Sum the two matrices\n\
	transpose		Compute the transposition of the matrix\n\
\n\
	help			Show this page of help\n\
	parameters		Modify the program parameters\n\
	quit			Quit the program\n\
\n\
Available predicates:\n\
	?square, ?rectangular, ?unit, ?symmetrical, ?sametype,\n\
	?equal\n\
\n",
};

static struct trad_s { char *it; char *en; } trad_tbl[] = {
"\t1 - Cambia lingua\n",
"\t1 - Toggle language\n",

"\t2 - Cambia stile\n",
"\t2 - Toggle style\n",

"\t3 - Torna al menu precedente\n",
"\t3 - Return to previous menu\n",

"\nStack delle matrici:\n",
"\nMatrices stack:\n",

"%s e %s sono dello stesso tipo: %s.\n",
"%s and %s have the same type: %s.\n",

"%s e %s sono eguali: %s.\n",
"%s and %s are equal: %s.\n",

"%s e` una matrice quadrata: %s.\n",
"%s is a square matrix: %s.\n",

"%s e` una matrice rettangolare: %s.\n",
"%s is a rectangular matrix: %s.\n",

"%s e` una matrice simmetrica: %s.\n",
"%s is a symmetrical matrix: %s.\n",

"%s e` una matrice unita`: %s.\n",
"%s is a unit matrix: %s.\n",

"%s: numero elementi presenti sullo stack insufficiente (%d/%d).\n",
"%s: not enough stack elements available (%d/%d).\n",

"?eguali",
"?equal",

"?quadrata",
"?square",

"?rettangolare",
"?rectangular",

"?simmetrica",
"?symmetrical",

"?stessotipo",
"?sametype",

"?unita`",
"?unit",

"Comando errato (`aiuto' per maggiori informazioni)\n",
"Wrong command (`help' for help)\n",

"Creazione matrice `%s'\n",
"Creating matrix `%s'\n",

"Creazione matrice casuale `%s'\n",
"Creating random matrix `%s'\n",

"Creazione matrice unita` `%s'\n",
"Creating unit matrix `%s'\n",

"Determinante di %s(%d ordine) = %f\n",
"Determinant of %s(%d order) = %f\n",

"Digitare `aiuto' per maggiori informazioni\n\n",
"Enter `help' for help\n\n",

"Elemento massimo",
"Maximum element",

"Elemento minimo",
"Minimum element",

"Errore: calcolo determinante di matrice non quadrata\n",
"Error: determinant calculus of a non-square matrix\n",

"Errore: prodotto di matrici di dimensioni errate\n",
"Error: product of matrices with wrong dimensions\n",

"Errore: somma di matrici di dimensioni differenti\n",
"Error: sum of matrices with different dimensions\n",

"Numero",
"Number",

"Numero colonne",
"Columns number",

"Numero righe",
"Rows number",

"Ordine",
"Order",

"Parametri correnti: lingua <%s>, stile <%s>\n",
"Current parameters: language <%s>, style <%s>\n",

"Predicato errato.\n",
"Wrong predicate.\n",

"Premere invio per continuare\n",
"Please press return to continue\n",

"Scelta",
"Choice",

"aiuto",
"help",

"alternativo",
"alternative",

"classico",
"classic",

"crea",
"create",

"creacasuale",
"createrandom",

"creaunita`",
"createunit",

"determinante",
"determinant",

"elimina",
"delete",

"esci",
"quit",

"falso",
"false",

"inglese",
"english",

"italiano",
"italian",

"lingua",
"language",

"parametri",
"parameters",

"prodotto",
"product",

"prodottopernumero",
"productfornumber",

"somma",
"sum",

"trasposta",
"transpose",

"vero",
"true",
};

int confronta(const void *p1, const void *p2)
{
	return strcmp(((struct trad_s *)p1)->it, ((struct trad_s *)p2)->it);
}

char *trova_lingua_inglese(char *s)
{
	struct trad_s *tradp, key;
	key.it = s;

	if ((tradp = bsearch(&key, trad_tbl,
			     sizeof trad_tbl / sizeof trad_tbl[0],
			     sizeof trad_tbl[0], confronta)) == NULL)
		return s;
	else
		return tradp->en;
}

char *_getstr(char *s)
{
	if (lingua == LINGUA_INGLESE)
		return trova_lingua_inglese(s);
	else
		return s;
}
