############################################
# TKSCILAB Gui Interface facility for Scilab
# Bertrand Guiheneuf - 1998 
############################################
#
# -->   figure.tcl
# 	$Id: figure.tcl,v 1.5 1998/02/24 21:41:06 guiheneu Exp guiheneu $	


# define the correspondance between the scilab 'figure'
# object and the tk 'toplevel' object
set StyTrad(toplevel)       figure;



proc GetFreeFigHandle { handle } {
    # look in the free handles list if there is one
    # and create one if there is none

    global FreeFigHandle  FigList;
    if { $handle ==0 } {
	# generate a handle automaticaly

	# is there any free handle in the list ?
	if { [llength $FreeFigHandle] > 0 } {
	    # YES : let's take it
	    # sort the list of free handle
	    set FreeFigHandle [lsort -integer $FreeFigHandle];
	    
	    # get the first one
	    set h [lindex $FreeFigHandle 0];
	    # and remove it from the list
	    set FreeFigHandle [lreplace $FreeFigHandle 0 0];
	} else {
	    # NO thus let's create one
	    set h [expr 1 + [llength $FigList]];
	}
    } else {
	# the handle is specified 
	set h $handle;

	set hmax [expr 1 + [llength $FigList] + [llength $FreeFigHandle] ];
	# first free figure handle
	
	if { $hmax > $handle } {
	    # The handle is in the free handle list
	    set Idx [lsearch -exact $FreeFigHandle $handle];
	    # remove it
	    set FreeFigHandle [lreplace $FreeFigHandle $Idx $Idx];
	} else {
	    for { set Idx $hmax } { $Idx < $handle } { incr Idx } {
		
		set FreeFigHandle [linsert $FreeFigHandle 0 $Idx];
	    }
	}
    }
    return $h;
}



######################################################################################
proc CreateFigure { handle } {
    # Create a figure. Its parent is the root window.
    # there is two way to create a figure wether to 
    # give it a handle ( "handle" != 0 )
    # wether to give it a default handle ("handle" == 0)

    global FigList Win StyTrad gcf tk_version;
    
        
    
    # get the figure handle
    set CurrentFigHandle [GetFreeFigHandle $handle];
    
    # Insert the new figure handle  at the 
    # beginning of the figure list 
    set FigList [linsert $FigList 0 $CurrentFigHandle];

    
    # Compute the instance figure name
    set name "figure$CurrentFigHandle" ;
    
    
    # Update windows list
    set Win($CurrentFigHandle) "$name" ;
    
    # Store the figure handle in its info structure 
    global  "$name";  
    set "$name\(handle)" $CurrentFigHandle;
    
    set "$name\(name)" $name;
    set "$name\(style)" $StyTrad(toplevel);
    set "$name\(control)" "toplevel";
    set "$name\(units)" "pixels";
    set "$name\(fontunits)" "pixels";

    # create the control   
    SetField  $CurrentFigHandle parent 0;

    # the path was created by the setParent proc
    # get it:
    set path [set  "$name\(path)"];
    
    
    # if possible, create figure menu name
    # be careful, the menu does not really exist for the moment !!!
    if { $tk_version >= 8.0 } { 
	$path configure -menu $path.menu;
	set "$name\(childrenmenu)" {};
    }
    
    set gcf  $CurrentFigHandle;
    return  [set "$name\(handle)" ];
    
    
}

  



proc CloseFigure { FigPath } {
    # answer to a close event generated by a figure

    global Win  FreeFigHandle  FigList gcf;

    # find the handle of the closed figure
    set h [FindFig "path" $FigPath];
    set name $Win($h);
    global "$name"; 
    # the following cannot work for the moment because
    # the window has been destroyed so it doesnt have any child.
    # I will haev to manae the chil list by myself later.
###
    # set ch [winfo children $FigPath];
    # for {set i 0} {$i<[llength $ch]} {incr i} {
	# DestroyUIControl [lindex $ch $i];
    # }
###
    # append it to the list of free figure handles
    set FreeFigHandle [linsert $FreeFigHandle 0 $h];
    
    # find the handle in the figure list
    set idx [lsearch -exact $FigList $h]
    # and remove the figure 
    set FigList [lreplace $FigList $idx $idx];
    
    if {[info exists "$name"]} { unset "$name";}
    global "$name\menu"; if {[info exists "$name\menu"]} { unset "$name\menu";}

    # now let's update the gcf (current figure)
    if { [llength $FigList] > 0} {
	set gcf [lindex $FigList 0];
    } else {
	set gcf 0;
    } 

}





proc FigureSelect { handle } {
    # select a figure named by its handle 
    # if it doen't exist, create it
    
    global FigList gcf;
    set handle [expr round($handle)];
    if { [lsearch -exact $FigList $handle] != -1 } {
	set gcf $handle;
	set h $handle;
    } else {
	set h [CreateFigure $handle];
    }
    
    return $h;
    
}



proc DestroyFigure { handle } {
    # destroy a figure 

    global gcf Win;
    set handle [expr round($handle)];
    if { $handle == 0 } {
	set handle $gcf;
    } 
    
    if { $handle != 0 } {
	set name "$Win($handle)";
	global "$name";
	
	set path [ set "$name\(path)"];
	
	destroy $path;
    }


}


proc GetGcf {} {
    # get the handle of the current figure
    # if there is no current figure (ie gcf==0),
    # a figure is created
    # input  : void
    # output : handle of the current figure

    global gcf;

    if {$gcf == 0} {
	set h [CreateFigure 0];
    } else {
	set h $gcf;
    }
    return $h;

}
