.TH scicosim  "Janvier 1997" "Scilab Group" "Scicos function"
.so ../sci.an
.SH NAME
scicosim - Scicos simulation function
.SH CALLING SEQUENCE
.nf
[state,t]=scicosim(state,0,tf,sim,'start' [,tol])
[state,t]=scicosim(state,tcur,tf,sim,'run' [,tol])
[state,t]=scicosim(state,tcur,tf,sim,'finish' [,tol])
.fi
.SH PARAMETERS
.TP 10
state
: Scilab \fVtlist\fR
contains scicosim  initial state. Usually generated by Scicos
\fVCompile\fR or \fVRun\fR menus (see scicos_cpr for more details).
.TP
tcur 
: initial simulation  time
.TP
tf
: final simulation time (Unused with options  \fV'start'\fR and  \fV'finish'\fR
.TP
sim
: Scilab \fVtlist\fR.  Usually generated by Scicos
\fVCompile\fR menu (see scicos_cpr  for more details). 
.TP
tol
: 4 vector \fV[atol,rtol,ttol,deltat]\fR where \fVatol\fR, \fVrtol\fR  are respectively the
absolute and relative tolerances for ode solver (see ode), \fVttol\fR
is the precision on event dates.  \fVdeltat\fR is maximum integration
interval for each call to ode solver.
.TP 
t
: final reached time
.SH DESCRIPTION
Simulator for Scicos compiled diagram. Usually \fVscicosim\fR is
called by \fVscicos\fR to perform simulation of a diagram. 

But \fVscicosim\fR may also be called outside Scicos. Typical usage in
such a case may be:
.TP
1
Use Scicos to define a block diagram, compile it.
.TP
2
Save the compiled diagram using \fVSave,SaveAs\fR Scicos menus . 
.TP
3
In Scilab, load saved file using \fVload\fR function. You get
variables \fVscicos_ver\fR, \fVscs_m\fR, \fVcpr\fR
.LP
\fVscs_m\fR is the diagram Scicos main data structure.
.LP
\fVcpr\fR is the data structure
\fVlist(state,sim,cor,corinv)\fR if the diagram had been compiled
before saved, else \fVcpr=list()\fR
.TP
4
Extract \fVstate\fR, \fVsim\fR out of \fVcpr\fR
.TP 
5
Execute \fV[state,t]=scicosim(state,0,tf,sim,'start' [,tolerances])\fR
for initialisation.
.TP 
6
Execute \fV[state,t]=scicosim(state,0,tf,sim,'run' [,tolerances])\fR
for simulation from \fV0\fR to \fVtf\fR. Many successives such calls may be
performed changing initial and final time.
.TP
7
Execute \fV[state,t]=scicosim(state,0,tf,sim,'finish' [,tolerances])\fR
at the very end of the simulation to close files,...

For advanced user it is possible to "manually" change some parameters
or state values

.SH SEE ALSO
scicos, scicos_cpr
      







