.TH ode_discrete G "February 1998" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
ode_discrete - ordinary differential equation solver, discrete time simulation
.SH CALLING SEQUENCE
.nf
y=ode("discrete",y0,k0,kvect,f)
.fi
.SH PARAMETERS
.TP 7
y0 
: real vector or matrix (initial conditions).
.TP
t0
: real scalar (initial time).
.TP
f
: external i.e. function or character string or list.
.TP
k0
: integer (initial time).
.TP
kvect
: integer vector.
.SH DESCRIPTION
With this syntax (first argument equal to \fV"discrete"\fR)
\fVode\fR computes recursively \fVy(k+1)=f(k,y(k))\fR
from an initial state
\fVy(k0)\fR and returns \fVy(k)\fR for \fVk\fR in \fVkvect\fR.
\fVkvect(1)\fR must be greater than or equal to \fVk0\fR.

Other arguments and other options are the same as for \fVode\fR, see the
ode help.
.SH EXAMPLE
.nf
y1=[1;2;3]; deff("yp=a_function(k,y)","yp=A*y+B*u(k)")
A=diag([0.2,0.5,0.9]); B=[1;1;1];u=1:10;n=5;
y=ode("discrete",y1,1,1:n,a_function);
y(:,2)-(A*y1+B*u(1))
// Now y evaluates  at [y3,y5,y7,y9]
y=ode("discrete",y1,1,3:2:9,a_function)
.fi
.SH SEE ALSO
ode
