.TH m_circle 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
m_circle - M-circle plot
.SH CALLING SEQUENCE
.nf
 m_circle()
 m_circle(gain)
.fi
.SH PARAMETERS
.TP
gain 
: vector of gains (in DB). The default value is 
.RS
.TP 
gain
=[-12 -8 -6 -5 -4 -3 -2 -1.4 -1 -.5 0.25 0.5 0.7 1 1.4 2 2.3 3 4 5 6 8 12]
.RE
.SH DESCRIPTION 
\fVm_circle\fR is used with \fVnyquist\fR.
.SH EXAMPLE 
.nf
//Example 1 :
  s=poly(0,'s')
  h=syslin('c',(s^2+2*0.9*10*s+100)/(s^2+2*0.3*10.1*s+102.01))
  nyquist(h,0.01,100,'(s^2+2*0.9*10*s+100)/(s^2+2*0.3*10.1*s+102.01)')
  m_circle();
//Example 2:
  xbasc();
  h1=h*syslin('c',(s^2+2*0.1*15.1*s+228.01)/(s^2+2*0.9*15*s+225))
  nyquist([h1;h],0.01,100,['h1';'h'])
  m_circle([-8 -6 -4]);
.fi
.SH SEE ALSO 
nyquist, chart, black
.SH AUTHOR
S.Steer.

