.TH colormap 2 "August 1996" "Scilab Group" "Scilab Function" 
.so ../sci.an
.SH NAME 
colormap - using colormaps
.SH DESCRIPTION
A colormap \fVcmap\fR is defined by a m x 3 matrix. m is the number of colors.
Color number i is given as a 3-uple \fVcmap(i,1)\fR, \fVcmap(i,2)\fR 
\fVcmap(i,3)\fR
corresponding respectively to red, green and blue intensity between
0 and 1.

At the beginning, 32 colors are defined in the colormap. You can
change the colormap by using \fVxset("colormap",cmap)\fR.

Each color in the colormap has an id you have to use to specify color
in most plot functions. To see the ids, use \fVxset()\fR or
\fVxgetcolor()\fR.

You can come back to default colormap with \fVxset("default")\fR.
.SH EXAMPLE
.nf
m=228;
n= fix(3/8*m);
r=[(1:n)'/n; ones(m-n,1)];
g=[zeros(n,1); (1:n)'/n; ones(m-2*n,1)];
b=[zeros(2*n,1); (1:m-2*n)'/(m-2*n)];
h=[r g b];
xset("colormap",h)
plot3d1()
xset("default")
.fi
.SH SEE ALSO
addcolor, getcolor, xset
