.TH g_margin 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
g_margin - gain margin
.SH CALLING SEQUENCE
.nf
[gm [,fr]]=g_margin(h) 
.fi
.SH PARAMETERS
.TP
h
: \fVsyslin\fR list representing a linear system in 
state-space or transfer form
.SH DESCRIPTION
returns \fVgm\fR, the gain margin in dB of \fVh\fR 
(SISO plant) and \fVfr\fR, the achieved corresponding frequency in hz.
The gain margin is values of the system gain at points where the
nyquist plot crosses the negative real axis.
.SH EXAMPLE
.nf
h=syslin('c',-1+%s,3+2*%s+%s^2)
[g,fr]=g_margin(h)
[g,fr]=g_margin(h-10)
nyquist(h-10)
.fi
.SH SEE ALSO
p_margin, black, chart, nyquist

