#include "gyapp.h"

extern struct GLOBAL global;

void combo_callback (GtkWidget * widget, gpointer data)
{
   struct OPTIONS * op = NULL;
   gchar * string;
   int type = 0;
   
   if (data != NULL)
     {
	op = (struct OPTIONS *)data;
	string = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(op->combo)->entry));
	type=*string-'1'; //The first character must be the option n$
     }
   else
       g_error(_("combo_callback: data is NULL!\n"));
   
   switch (type)
     {
     case PARAMETRIC_1D:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],FALSE);
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("Not need"));
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("y=y(t)"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'y' in function of 't'. A moving body will be drawn"), NULL);
	break;
     case PARAMETRIC_2D:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],TRUE);
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("x=x(t)"));
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("y=y(t)"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'x' in function of 't'. A moving body will be drawn "), NULL);
	gtk_tooltips_set_tip (op->tooltips, op->entry[1],
			      _("Type the 'y' in function of 't'"), NULL);
	break;
     case NORMAL:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],FALSE);
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("y=y(x,t)"));
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("Not need"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'x' in function of 'y' and 't'. A cruve will be drawn"), NULL);
	break;
     case PARAMETRIC_POLAR:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],TRUE);
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("rho=rho(t)"));
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("theta=theta(t)"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'rho' in function of 't'. A moving body will be drawn"), NULL);
	gtk_tooltips_set_tip (op->tooltips, op->entry[1],
			      _("Type the 'theta' in function of 't'. A moving body will be drawn"), NULL);
	break;
     case POLAR:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],FALSE);
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("rho=rho(theta,t)"));
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("Not need"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'rho' in function of 'theta' and 't'. A curve will be drawn"), NULL);
	break;
     case SURFACE:
	gtk_widget_set_sensitive(op->entry[0],TRUE);
	gtk_widget_set_sensitive(op->entry[1],FALSE);
	gtk_label_set_text(GTK_LABEL(op->label[0]),_("z=z(x,y,t)"));
	gtk_label_set_text(GTK_LABEL(op->label[1]),_("Not need"));
	gtk_tooltips_set_tip (op->tooltips, op->entry[0],
			      _("Type the 'z' in function of 'x' 'y' and 't'. A surface will be displayed."), NULL);
	break;
     }
}
	
GtkWidget * options_general(struct OPTIONS * options)
{
   GtkWidget *vbox, *hbox;
   GtkWidget *prision1, *prision2, *prision3;
   GtkWidget *vbox1, *vbox2;
   GtkWidget *label;
   GList * glist;
   GtkObject * adj;
   register int i;
   
   static char *combo_items[COMBO_ITEMS]=
     {
	N_("1. 1D Parametric"),
	N_("2. 2D Parametric"),
	N_("3. Standard"),
	N_("4. Polar Parametric"),
	N_("5. Polar Standard"),
	N_("6. 3D Surface")
     };
   
   static char *etiquetas[3][2]=
     {
	  {N_("Time between animations"), "ms"},
	  {N_("Body radius"),N_("pixels")},
	  {N_("Starting t value"),N_("units")}
     };
   static char *spin_tooltip[3] = 
     {
	N_("The time to be waited between drawings"),
	N_("The body will be drawn with this thickness"),
	N_("Value for the time parameter")
     };
   gfloat ajustes[3][5]=
     {
	  {global.miliseconds,1,60000,5,50},
	  {global.radius,1,25,1,5},
	  {global.t,1,INT_MAX,1,100}
     };
   
   
   /* Create the widgets for the first page */
   
   vbox = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vbox),5); //A border
   gtk_widget_show(vbox);
   
   //Dentro de l dos horizontales, uno para los frames y otro para los botones
   
   //hbox1 -> Dos frames prision1 y prision2
   hbox = gtk_hbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(hbox),5); //Pongo un borde
   gtk_container_add(GTK_CONTAINER(vbox),hbox); //Meto hbox en ventana ap.
   gtk_widget_show(hbox);
   
   // Creo los dos "frames", uno para el tipo de funcin y otro para otros parmetros.
   
   prision1 = gtk_frame_new(_("Function type and drawing options"));
   gtk_container_add(GTK_CONTAINER(hbox),prision1);
   gtk_container_border_width(GTK_CONTAINER(prision1), 5);
   gtk_frame_set_shadow_type(GTK_FRAME(prision1), GTK_SHADOW_OUT);
   gtk_widget_show(prision1);
   
   prision2 = gtk_frame_new(_("Other options"));
   gtk_container_add(GTK_CONTAINER(hbox),prision2);
   gtk_container_border_width(GTK_CONTAINER(prision2), 5);
   gtk_frame_set_shadow_type(GTK_FRAME(prision2), GTK_SHADOW_OUT);
   gtk_widget_show(prision2);
   
   //Creo un contenedor vertical para el primer frame.
   vbox1 = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vbox1),5); 
   gtk_container_add(GTK_CONTAINER(prision1),vbox1); 
   gtk_widget_show(vbox1);
   
   /* Add a tooltips */
   
   options->tooltips = gtk_tooltips_new ();
   
   //Aado tipos de funcin
   glist = NULL; //Para la lista de tipos de funcin.
   for (i=0;i<COMBO_ITEMS;i++)
       glist=g_list_append(glist,_(combo_items[i]));
   
   options->combo = gtk_combo_new();
   gtk_combo_set_popdown_strings( GTK_COMBO(options->combo), glist) ;
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(options->combo)->entry), 
		      _(combo_items[global.function_type]));
   gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(options->combo)->entry),FALSE);
   gtk_container_add(GTK_CONTAINER(vbox1),options->combo);
   gtk_tooltips_set_tip (options->tooltips, GTK_COMBO(options->combo)->entry,
			 _("Select how expresing the function"), NULL);
   
   gtk_signal_connect(GTK_OBJECT(GTK_COMBO(options->combo)->list), 
		      "selection_changed",
		      GTK_SIGNAL_FUNC (combo_callback), 
		      (gpointer *)options);    
   gtk_widget_show(options->combo);
   
   /* Aado botn de "rules" */
   
   options->check_rules= 
       gtk_check_button_new_with_label (_("Rules following body"));
   gtk_container_add(GTK_CONTAINER(vbox1),options->check_rules);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options->check_rules),
				global.draw_rules);
   gtk_tooltips_set_tip (options->tooltips,options->check_rules,
			 _("On if you want the rules follow the body movement"),
			 NULL);
   gtk_widget_show(options->check_rules);
   
   /* Aado botn de "trace" */
   
   options->check_trace=
       gtk_check_button_new_with_label (_("Trace body"));
   gtk_container_add(GTK_CONTAINER(vbox1),options->check_trace);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options->check_trace),
				global.draw_trace);
   gtk_tooltips_set_tip (options->tooltips,options->check_trace,
			 _("Off if you want to erase the draw before drawing other"), 
			 NULL); 
   gtk_widget_show(options->check_trace);
   
   /* vbox2 is for other options */
   
   vbox2 = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vbox2),5);
   gtk_container_add(GTK_CONTAINER(prision2),vbox2);
   gtk_widget_show(vbox2);
   
	     
   for(i=0;i<3;i++)
     {
	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(vbox2),hbox);
	gtk_widget_show(hbox);
	
	label=gtk_label_new(_(etiquetas[i][0]));
	gtk_container_add(GTK_CONTAINER(hbox),label);
	gtk_widget_show(label);
	
	adj = gtk_adjustment_new(ajustes[i][0], //gfloat value,
				 ajustes[i][1], //gfloat lower,
				 ajustes[i][2], //gfloat upper,
				 ajustes[i][3], //gfloat step_increment,
				 ajustes[i][4], //gfloat page_increment,
				 0);
	
	
	options->spin[i]=gtk_spin_button_new(GTK_ADJUSTMENT(adj),.5,0);
	gtk_container_add(GTK_CONTAINER(hbox),options->spin[i]);
	gtk_tooltips_set_tip (options->tooltips, options->spin[i],
			      _(spin_tooltip[i]), NULL);
	gtk_widget_show(options->spin[i]);
	
	label=gtk_label_new(_(etiquetas[i][1]));
	gtk_container_add(GTK_CONTAINER(hbox),label);
	gtk_widget_show(label);
     }
   
   
   prision3 = gtk_frame_new(_("Functions"));
   gtk_container_add(GTK_CONTAINER(vbox),prision3);
   gtk_container_border_width(GTK_CONTAINER(prision3), 5);
   gtk_frame_set_shadow_type(GTK_FRAME(prision3), GTK_SHADOW_OUT);
   gtk_widget_show(prision3);

   vbox2 = gtk_vbox_new(FALSE,5);
   gtk_container_add(GTK_CONTAINER(prision3),vbox2);
   gtk_container_border_width(GTK_CONTAINER(vbox2), 5);
   gtk_widget_show(vbox2);


   for (i=0;i<2;i++)
     {
	hbox = gtk_hbox_new(TRUE,5);
	gtk_container_add(GTK_CONTAINER(vbox2),hbox);
	gtk_widget_show(hbox);
	
	options->label[i]=gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(hbox),options->label[i]);
	gtk_widget_show(options->label[i]);
	
	options->entry[i]=gtk_entry_new_with_max_length(100);
	switch(i)
	  {
	  case 0:
	     gtk_entry_set_text( GTK_ENTRY(options->entry[0]),global.function1);
	     break;
	  case 1:
	     gtk_entry_set_text( GTK_ENTRY(options->entry[1]),global.function2);
	     break;
	  }
	gtk_container_add(GTK_CONTAINER(hbox),options->entry[i]);
	gtk_widget_show(options->entry[i]);
     }
   
   combo_callback(options->combo,options); /* Update the entries */
   
   return vbox;
}
