
#include "gyapp.h"

extern struct GLOBAL global;

GtkWidget * options3D(struct OPTIONS *op)
{
   GtkWidget * frame;
   GtkWidget * vbox, *vboxppal, *hbox;
   GtkTooltips * tooltips;
   int i;
   
   static char *etiquetas[5]=
     {
	N_("Minimun 'x'"),
	N_("Maximun 'x'"),
	N_("Minimun 'y'"),
	N_("Maximun 'y'"),
	N_("Grid")
     };
   
   static char *spin_tooltip[5] =
     {
	N_("The inferior extreme of 'x'"),
	N_("The superior extreme of 'x'"),
	N_("The inferior extreme of 'y'"),
	N_("The superior extreme of 'y'"),
	N_("How many 'x' to plot a point?")
     };
   
   gfloat ajustes[5][5]=
     {
	  {global.xmin,-10000,10000,1,100},
	  {global.xmax,-10000,10000,1,100},
	  {global.ymin,-10000,10000,1,100},
	  {global.ymax,-10000,10000,1,100},
	  {global.grid,1,1000,1,10}
     };
   
   vboxppal = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vboxppal),5); //A border
   gtk_widget_show(vboxppal);
   
   /* A frame and a horizontal box for the buttons */
   
   frame = gtk_frame_new(_("Grid and dimensions"));
   gtk_container_add(GTK_CONTAINER(vboxppal),frame);
   gtk_container_border_width(GTK_CONTAINER(frame), 5);
   gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
   gtk_widget_show(frame);
    
   /* A horizontal box for buttons */
   
   hbox = gtk_hbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(hbox),5); //A border
   gtk_container_add(GTK_CONTAINER(vboxppal),hbox);
   gtk_widget_show(hbox);
   
   /* A vertical box for the frame */
   vbox = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vbox),5);
   gtk_container_add(GTK_CONTAINER(frame),vbox);
   gtk_widget_show(vbox);
   
   /* tooltips */
   
   tooltips = gtk_tooltips_new();
   
   /* spins for the options */
   
   
   for(i=0;i<5;i++)
     {	
	GtkWidget * hbox, *label;
	GtkObject * adj;
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(vbox),hbox);
	gtk_widget_show(hbox);
	
	label=gtk_label_new(_(etiquetas[i]));
	gtk_container_add(GTK_CONTAINER(hbox),label);
	gtk_widget_show(label);
	
	adj = gtk_adjustment_new(ajustes[i][0], //gfloat value,
				 ajustes[i][1], //gfloat lower,
				 ajustes[i][2], //gfloat upper,
				 ajustes[i][3], //gfloat step_increment,
				 ajustes[i][4], //gfloat page_increment,
				 0);
	
	
	op->spin3D[i]=gtk_spin_button_new(GTK_ADJUSTMENT(adj),.5,0);
	gtk_container_add(GTK_CONTAINER(hbox),op->spin3D[i]);
	gtk_tooltips_set_tip (tooltips, op->spin3D[i],
			      _(spin_tooltip[i]), NULL);
	gtk_widget_show(op->spin3D[i]);
     }
   
   return vboxppal;
   
}
