#include "gyapp.h"

extern struct GLOBAL global;

void message_box(const gchar *label_text, const gchar *text)
{ 
   GtkWidget *window, *widget; /* Create a dialog */
   
   window = gtk_dialog_new ();
   gtk_window_set_title(GTK_WINDOW(window),label_text);
   
   gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG (window)->vbox),5);
   
   widget = gtk_label_new(text);
   gtk_label_set_justify(GTK_LABEL(widget),GTK_JUSTIFY_LEFT);
	   	
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
		       widget, TRUE, TRUE, 0);
   gtk_widget_show (widget);
   
   
   widget = gtk_button_new_with_label(_("Ok"));
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area),
		       widget, TRUE, TRUE, 0);
   gtk_signal_connect_object (GTK_OBJECT (widget),
			      "clicked",
			      GTK_SIGNAL_FUNC (gtk_widget_destroy),
			      GTK_OBJECT (window));
   gtk_widget_show (widget);
   gtk_widget_show(window);
   
}

void options_close_callback(GtkWidget * widget,gpointer data)
{
   
   GtkWidget * window;
   window = (GtkWidget *)data;
   /* Evaluating values */
   if (!( (global.xmax-global.xmin) <= global.grid ||
	 (global.ymax-global.ymin) <= global.grid ))
     {
	gtk_widget_set_sensitive(global.button_options,TRUE);
	gtk_widget_destroy(window);
     }
}

extern int _error_analizador;
gboolean print_error;

void ok_callback (GtkWidget * widget, gpointer data)
{
   struct OPTIONS * op = (struct OPTIONS *)data;
   gchar *string;
   gint xmax,xmin,ymax,ymin,grid;
   
   /* The sping buttons (3D) */
   xmin = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin3D[0]));
   xmax = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin3D[1]));
   ymin = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin3D[2]));
   ymax = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin3D[3]));
   grid = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin3D[4]));
   
   if ( (xmax-xmin) <= grid || (ymax-ymin) <= grid )
     {
	message_box(
		    _("Error"),
		    _("3D Surface parameters are not well defined.\nCheck it again.\nParameters not accepted."));
	return;
     }
   
   // The function type
   string = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(op->combo)->entry));
   global.function_type=*string-'1'; //The first character must be the option number
   
   //The spin buttons (general)
   
   global.miliseconds = 
       gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin[0]));
   global.radius = 
       gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin[1]));
   global.t = 
       gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(op->spin[2]));
   
   /* The sping buttons (3D) */
   global.xmin = xmin;
   global.xmax = xmax;
   global.ymin = ymin;
   global.ymax = ymax;
   global.grid = grid;

   //The functions.
   
   strcpy(global.function1,gtk_entry_get_text(GTK_ENTRY(op->entry[0])));
   strcpy(global.function2,gtk_entry_get_text(GTK_ENTRY(op->entry[1])));
 
   /* Checking errors in functions */
   print_error = TRUE;
   analiza3d(global.function1,0,0,1);
   analiza3d(global.function2,0,0,1);
   print_error = FALSE;
   
   /* The check buttons */
   global.draw_rules = GTK_TOGGLE_BUTTON(op->check_rules)->active;
   global.draw_trace = GTK_TOGGLE_BUTTON(op->check_trace)->active;
   
   start_stop_callback(NULL, NULL);
}

void options_callback(gpointer data,GtkWidget * widget)
{
   static struct OPTIONS options;
   GtkWidget *window, *vbox, *hbox;
   GtkWidget *button;
   GtkWidget *notebook, *label;
   GtkTooltips *tooltips;
   
   gtk_widget_set_sensitive(global.button_options,FALSE); //Oculto el botn
   
   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(window), _("Configuration") );
   gtk_signal_connect_object(GTK_OBJECT(window),
			     "destroy",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(window));
   
   vbox = gtk_vbox_new(FALSE,5);
   gtk_container_border_width(GTK_CONTAINER(vbox),5); //A border
   gtk_container_add(GTK_CONTAINER(window),vbox);
   gtk_widget_show(vbox);
   
   /* Notebook */
   
   notebook = gtk_notebook_new ();
   gtk_container_add(GTK_CONTAINER(vbox),notebook);
   gtk_widget_show(notebook);
   label = gtk_label_new (_("General options"));
   gtk_notebook_append_page (GTK_NOTEBOOK (notebook), 
			     options_general(&options),
			     label);
   gtk_widget_show(label);
   label = gtk_label_new (_("3D Surface options"));
   gtk_notebook_append_page (GTK_NOTEBOOK (notebook),
			     options3D(&options),
			     label);
   gtk_widget_show(label);
   gtk_widget_show(notebook);   
   /* Tooltips */
   
   tooltips= gtk_tooltips_new();
   
   /* The buttons */
   
   hbox = gtk_hbox_new(TRUE,5); //For the buttons
   gtk_container_add(GTK_CONTAINER(vbox),hbox);
   gtk_widget_show(hbox);
   
   button = gtk_button_new_with_label(_("Ok"));
   gtk_container_add(GTK_CONTAINER(hbox),button);
   gtk_signal_connect(GTK_OBJECT(button),
		      "clicked",
		      GTK_SIGNAL_FUNC(ok_callback),
		      (gpointer)&options);
   
   gtk_tooltips_set_tip (options.tooltips, button,
			 _("Press to accept this values"), NULL);
   gtk_widget_show(button);
   
   button = gtk_button_new_with_label(_("Ok & Close"));
   gtk_container_add(GTK_CONTAINER(hbox),button);
   gtk_signal_connect(GTK_OBJECT(button),
		      "clicked",
		      GTK_SIGNAL_FUNC(ok_callback),
		      (gpointer)&options);
   gtk_signal_connect(GTK_OBJECT (button),
		      "clicked",
		      GTK_SIGNAL_FUNC (options_close_callback),
		      (gpointer)window);
   gtk_tooltips_set_tip (options.tooltips, button,
			 _("Press to accept this values and close window"),
			 NULL);
   gtk_widget_show(button);
   
   button = gtk_button_new_with_label(_("Cancel"));
   gtk_container_add(GTK_CONTAINER(hbox),button);
   gtk_signal_connect(GTK_OBJECT (button),
		      "clicked",
		      GTK_SIGNAL_FUNC (options_close_callback),
		      (gpointer)window);
   gtk_tooltips_set_tip (options.tooltips, button,
			 _("Press to close window without accept modifications"),
			 NULL);
   gtk_widget_show(button);
   
   gtk_widget_show(window);
   
   combo_callback(options.combo,&options); /* Update the entries */
}

