
#include "gyapp.h"

struct GLOBAL global;

/* Create a new backing pixmap of the appropriate size */
static gint
    configure_event (GtkWidget *widget, GdkEventConfigure *event)
{
    if (global.pixmap)
        gdk_pixmap_unref(global.pixmap);

    global.pixmap = gdk_pixmap_new(widget->window,
                                   widget->allocation.width,
                                   widget->allocation.height,
                                   -1);
    gdk_draw_rectangle (global.pixmap,
                        widget->style->white_gc,
                        TRUE,
                        0, 0,
                        widget->allocation.width,
                        widget->allocation.height);

    /* I save the width and height values in the global struct. */
    global.width=widget->allocation.width;
    global.height=widget->allocation.height;

    gtk_ruler_set_range( GTK_RULER(global.hrule), -global.width/2, global.width/2, 0,global.width/2 );
    gtk_ruler_set_range( GTK_RULER(global.vrule), global.height/2, -global.height/2, 0, global.height/2 );

    return TRUE;
}

/* Redraw the screen from the backing pixmap */
static gint
expose_event (GtkWidget *widget, GdkEventExpose *event)
{
    gdk_draw_pixmap(widget->window,
                    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                    global.pixmap,
                    event->area.x, event->area.y,
                    event->area.x, event->area.y,
                    event->area.width, event->area.height);

    return FALSE;
}

void start_stop_callback(gpointer data,GtkWidget * widget)
{
   static gint state=FALSE;
   static guint tag;
   
   if (data == NULL) {	/* update timeout */
     if (state) {
	gtk_timeout_remove(tag);
	tag=gtk_timeout_add(global.miliseconds,
			    draw_function,
			    (gpointer)global.drawing_area);
     }
     return;
   }

   switch (state)
     {
     case FALSE:
	state=TRUE;
	tag=gtk_timeout_add(global.miliseconds,
			    draw_function,
			    (gpointer)global.drawing_area);
	gtk_label_set(GTK_LABEL((GtkWidget *)data),_("Stop"));
	break;
     case TRUE:
	state=FALSE;
	gtk_timeout_remove(tag);
	gtk_label_set(GTK_LABEL((GtkWidget *)data),_("Start"));
	break;
     }
}

void
quit ()
{   
   conffile(TRUE); /* Write the actual global options */
   gtk_exit (0);
}

int
main (int argc, char *argv[])
{
   GtkWidget *window;
   GtkWidget *vbox, *hbox;

   GtkWidget *button_quit;
   GtkWidget *button_start_stop;
   GtkWidget *button_ss_label;
   GtkWidget *button_about;
   GtkWidget *table;
   GtkTooltips *tooltips;
   /* i18n options */
   
   setlocale (LC_ALL, "");
   bindtextdomain (PACKAGE, LOCALEDIR);
   textdomain (PACKAGE);

   conffile(FALSE); /* Read the configuration */
   
   gtk_init (&argc, &argv);
   
   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW(window), _("gyapp: A Plotting Program"));
   
   vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_add (GTK_CONTAINER (window), vbox);
   gtk_widget_show (vbox);
   
   gtk_signal_connect (GTK_OBJECT (window), "destroy",
		       GTK_SIGNAL_FUNC (quit), NULL);

   /* Create a table for placing the ruler and the drawing area */
   table = gtk_table_new( 3, 2, FALSE );
   gtk_container_add( GTK_CONTAINER(vbox), table );
   
   /* Create the drawing area */
   
   global.drawing_area = gtk_drawing_area_new ();
   gtk_drawing_area_size (GTK_DRAWING_AREA (global.drawing_area), 200, 200);
   gtk_table_attach( GTK_TABLE(table), global.drawing_area, 1, 2, 1, 2,
		    GTK_EXPAND|GTK_FILL, GTK_FILL, 0, 0 );
   
   gtk_widget_show (global.drawing_area);
   
   /* Signals used to handle backing pixmap */
   
   gtk_signal_connect (GTK_OBJECT (global.drawing_area), "expose_event",
		       (GtkSignalFunc) expose_event, NULL);
   gtk_signal_connect (GTK_OBJECT(global.drawing_area),"configure_event",
		       (GtkSignalFunc) configure_event, NULL);
   
   /* Event signals */
   
   gtk_widget_set_events (global.drawing_area, 
			  GDK_EXPOSURE_MASK |
			  GDK_LEAVE_NOTIFY_MASK | 
			  GDK_POINTER_MOTION_MASK |
			  GDK_POINTER_MOTION_HINT_MASK);
   
   /* The horizontal ruler goes on top. As the mouse moves across the
    *     *      * drawing area, a motion_notify_event is passed to the
    *     *      * appropriate event handler for the ruler. */
   global.hrule = gtk_hruler_new();
   gtk_ruler_set_metric( GTK_RULER(global.hrule), GTK_PIXELS );
   gtk_ruler_set_range( GTK_RULER(global.hrule), -100, 100, 0, 100 );
   gtk_signal_connect_object( GTK_OBJECT(global.drawing_area), 
			     "motion_notify_event",
			     (GtkSignalFunc)EVENT_METHOD(global.hrule,
							 motion_notify_event),
			     GTK_OBJECT(global.hrule) );
   
   gtk_table_attach( GTK_TABLE(table), global.hrule, 1, 2, 0, 1,
		    GTK_EXPAND|GTK_SHRINK|GTK_FILL, GTK_FILL, 0, 0 );
   
   /* The vertical ruler goes on the left. As the mouse moves across
    *     *      * the drawing area, a motion_notify_event is passed to the
    *     *      * appropriate event handler for the ruler. */
   global.vrule = gtk_vruler_new();
   gtk_ruler_set_metric( GTK_RULER(global.vrule), GTK_PIXELS );
   gtk_ruler_set_range( GTK_RULER(global.vrule), 100,-100,0,100);
   gtk_signal_connect_object( GTK_OBJECT(global.drawing_area),
			     "motion_notify_event",
			     (GtkSignalFunc)EVENT_METHOD(global.vrule,
							 motion_notify_event),
			     GTK_OBJECT(global.vrule) );
   gtk_table_attach( GTK_TABLE(table), global.vrule, 0, 1, 1, 2,
		    GTK_FILL, GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0 );
   
   /* Now show */
   gtk_widget_show( global.hrule );
   gtk_widget_show( global.vrule );
   gtk_widget_show( table );
   
   /* Create the tooltips */
   
   tooltips = gtk_tooltips_new ();
   
   /* .. And the buttons */
   hbox = gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX (vbox),hbox,FALSE,FALSE,0);
   gtk_widget_show(hbox);
   
   button_quit = gtk_button_new_with_label (_("Quit"));
   gtk_box_pack_start (GTK_BOX (hbox), button_quit, FALSE, FALSE, 0);
   
   gtk_signal_connect_object (GTK_OBJECT (button_quit), "clicked",
			      GTK_SIGNAL_FUNC (gtk_widget_destroy),
			      GTK_OBJECT (window));
   gtk_tooltips_set_tip (tooltips, button_quit, 
			 _("Do you want exiting this application?"), NULL);
   gtk_widget_show (button_quit);
   
   button_start_stop = gtk_button_new();
   gtk_box_pack_start (GTK_BOX (hbox), button_start_stop, FALSE, FALSE, 0);
   
   button_ss_label= gtk_label_new(_("Start"));
   gtk_container_add (GTK_CONTAINER(button_start_stop),button_ss_label);
   gtk_widget_show(button_ss_label);
   
   gtk_signal_connect_object (GTK_OBJECT (button_start_stop), 
			      "clicked",
			      GTK_SIGNAL_FUNC (start_stop_callback),
			      (gpointer)button_ss_label);
   gtk_tooltips_set_tip (tooltips, button_start_stop,
			 _("Start and stop the moving draw"),
			 NULL);
   gtk_widget_show (button_start_stop);
   
   global.button_options = gtk_button_new_with_label(_("Options"));
   gtk_box_pack_start(GTK_BOX(hbox),global.button_options,FALSE,FALSE,0);
   gtk_tooltips_set_tip (tooltips, global.button_options,
			 _("Configuring the program options"), NULL);
   gtk_widget_show(global.button_options);
   
   gtk_signal_connect_object(GTK_OBJECT(global.button_options),
			     "clicked",
			     GTK_SIGNAL_FUNC(options_callback),
			     NULL);
   button_about = gtk_button_new_with_label(_("About gyapp..."));
   gtk_box_pack_start(GTK_BOX(hbox),button_about,FALSE,FALSE,0);
   gtk_tooltips_set_tip (tooltips, button_about,
			 _("Information about the author and copying license"), NULL);
   gtk_widget_show(button_about);
   
   gtk_signal_connect_object(GTK_OBJECT(button_about),
			     "clicked",
			     GTK_SIGNAL_FUNC(about_callback),
			     NULL);
   gtk_widget_show (window);
   
   
   gtk_main ();

   return 0;
}
