#ifndef _GYAPP_H_
# define _GYAPP_H_

# include <gtk/gtk.h>
# include "../config.h"
# include "analiza3d.h"

# define MAX_LEN 100
# define COMBO_ITEMS 6

# define EVENT_METHOD(i, x) GTK_WIDGET_CLASS(GTK_OBJECT(i)->klass)->x

# ifndef HAVE_120_GTK
#  define gtk_label_set_text gtk_label_set
#  define gtk_toggle_button_set_active gtk_toggle_button_set_state
# endif

struct GLOBAL
{
   float t;
   GdkPixmap * pixmap;
   GtkWidget * drawing_area;
   GtkWidget * button_options;
   GtkWidget * hrule;
   GtkWidget * vrule; 
   gint width;
   gint height;
   gint function_type;
   gchar function1[MAX_LEN];
   gchar function2[MAX_LEN];
   gint miliseconds; 
   gint radius;
   gchar draw_rules;  /* To drawing rules */
   gchar draw_trace;  /* Don't erase the previous draw */
   gint xmax;         /* Parameters to control the 3D drawing */
   gint ymax;
   gint xmin;
   gint ymin;
   gint grid;
};

enum FUNCTIONS
{
   PARAMETRIC_1D,
   PARAMETRIC_2D,
   NORMAL,
   PARAMETRIC_POLAR,
   POLAR,
   SURFACE
};

struct OPTIONS
{
   GtkWidget * combo; 
   GtkWidget * spin[3];
   GtkWidget * spin3D[5];
   GtkWidget * entry[2];
   GtkWidget * label[2];
   GtkWidget * check_rules;
   GtkWidget * check_trace;
   GtkWidget * button3D;
   GtkTooltips * tooltips;
};

void options_close_callback(GtkWidget * widget,gpointer data);
void ok_callback (GtkWidget * widget, gpointer data);
void options_callback(gpointer data,GtkWidget * widget);
void combo_callback (GtkWidget * widget, gpointer data);
GtkWidget * options3D(struct OPTIONS *);
GtkWidget * options_general(struct OPTIONS *);
gint draw_function (gpointer data);
void about_callback(GtkWidget * widget, gpointer data);
void licencia_callback(GtkWidget * widget, gpointer data);
gboolean conffile(gchar flag);
void message_box(const gchar *,const gchar *);
void start_stop_callback(gpointer data,GtkWidget * widget);

#endif
