#include "gyapp.h"

extern struct GLOBAL global;

#define NUMX (global.xmax-global.xmin)
#define NUMY (global.ymax-global.ymin)
#define NUMI (NUMX/global.grid)
#define NUMJ (NUMY/global.grid)

gint draw_3D_surface(GtkWidget * widget)
{
   
   int x,y,i,j;
   float z;
   GdkPoint * points, *draw_points;
   
   draw_points = (GdkPoint *) g_malloc(sizeof(GdkPoint)*NUMI*NUMJ);
   /* First it computes points */
   for (x=global.xmin,i=0;i<NUMI;x+=global.grid,i++)
     {
	for (y=global.ymin,j=0;j<NUMJ;y+=global.grid,j++)
	  {
	     z=analiza3d(global.function1,x,y,global.t);
	     (draw_points+i*NUMJ+j)->x = (int)(global.width/2 
					       - 1/M_SQRT2*x+y);
	     (draw_points+i*NUMJ+j)->y = (int)(global.height/2
					       + 1/M_SQRT2*x-z);
	  }
     }
   global.t++;
   points = (GdkPoint *)g_malloc(sizeof(GdkPoint)*NUMJ);
   for (i=0;i<NUMI;i++)
     {
	for (j=0;j<NUMJ;j++)
	  {
	     points[j].x=(draw_points+i*NUMJ+j)->x;
	     points[j].y=(draw_points+i*NUMJ+j)->y;
	  } 
	gdk_draw_lines(global.pixmap,
		       widget->style->black_gc,
		       points,
		       NUMJ);
     }
   g_free(points);
   
   points = (GdkPoint *)g_malloc(sizeof(GdkPoint)*NUMI);
   for (j=0;j<NUMJ;j++)
     {
	
	for (i=0;i<NUMI;i++)
	  {
	     points[i].x=(draw_points+i*NUMJ+j)->x;
	     points[i].y=(draw_points+i*NUMJ+j)->y;
	  }
	
	gdk_draw_lines(global.pixmap,
		       widget->style->black_gc,
		       points,
		       NUMI);
     }
   g_free(points);
   g_free(draw_points);
   return 0;
}

/* Draw a function on the screen */
gint draw_function (gpointer data)
/* Need a x and a y to update */
{
   int x,y,i;
   float rho,theta;
   GtkWidget * widget;
   GdkRectangle update_rect;
   GdkPoint * points;
   GdkEvent event;
   
   widget=(GtkWidget *)data;
   
   /* The region I'll modify */
   update_rect.x = 0;
   update_rect.y = 0;
   update_rect.width = global.width;
   update_rect.height = global.height;
   
   if (!global.draw_trace)
     {
	/* Delete the old plot */
	gdk_draw_rectangle (global.pixmap,
			    widget->style->white_gc,
			    TRUE,
			    0, 0,
			    global.width,
			    global.height);
     }
   
   switch (global.function_type)
     {
     case PARAMETRIC_1D:
        /* Need x=f(t) */
	
        gdk_draw_arc(global.pixmap,
                     widget->style->black_gc,
                     TRUE,
                     global.width/2-global.radius,
                     global.height/2-global.radius-(int)analiza3d(global.function1,
                                               0,0,(int)global.t++),
                     global.radius*2,global.radius*2,
                     0,360*64); /* Los grados hay que darlos multiplicados
				 * por 64 */
        break;
     case PARAMETRIC_2D:
        x= global.width/2+(int)analiza3d(global.function1,0,0,(int)global.t);
        y= global.height/2-(int)analiza3d(global.function2,0,0,(int)global.t++);
	
        gdk_draw_arc(global.pixmap,
                     widget->style->black_gc,
                     TRUE,x-global.radius,y-global.radius,
                     global.radius*2,global.radius*2,
                     0,360*64);
	
        /* Draw the "rules" */
        if (global.draw_rules)
	  {
	     event.type = GDK_MOTION_NOTIFY;
	     event.motion.is_hint = FALSE;
	     event.motion.x=x;event.motion.y=y;
	     gtk_widget_event(global.hrule,&event);
	     gtk_widget_event(global.vrule,&event);
	  }
	
        /* Need x=f(t), y=f(t) */
        break;
     case NORMAL:
        /* Need y=f(x,t) */
        points = (GdkPoint *) g_malloc(sizeof(GdkPoint)*global.width);
        for (x=-global.width/2, i=0;i<global.width;x++,i++)
	  {
	     points[i].x = global.width/2+x;
	     points[i].y = global.height/2
		 - (int)analiza3d(global.function1,x,0,(int)global.t);
	  }
	global.t++;
        gdk_draw_lines(global.pixmap,
                       widget->style->black_gc,
                       points,
                       global.width);
        g_free(points);
        break;
     case PARAMETRIC_POLAR:
        /* Need rho=rho(t)
	    theta=theta(t) */
        rho=analiza3d(global.function1,0,0,(int)global.t);
        theta=analiza3d(global.function2,0,0,(int)global.t++);
        x=(int)(global.width/2+rho*cos(theta));
        y=(int)(global.height/2-rho*sin(theta));
	
        gdk_draw_arc(global.pixmap,
                     widget->style->black_gc,
                     TRUE,x-global.radius,y-global.radius,
                     global.radius*2,global.radius*2,
                     0,360*64);
	
        if(global.draw_rules)
	  {
	     /* Draw the "rules" */
	     event.type = GDK_MOTION_NOTIFY;
	     event.motion.is_hint = FALSE;
	     event.motion.x=x;event.motion.y=y;
	     gtk_widget_event(global.hrule,&event);
	     gtk_widget_event(global.vrule,&event);
	  }
	break;
     case POLAR:
        /* Need rho=rho(theta,t) */
        points = (GdkPoint *) g_malloc(sizeof(GdkPoint)*360);
        for (i=0;i<360;i++)
	  {
	     theta=2*M_PI*i/360;
	     rho = analiza3d(global.function1,theta,0,(int)global.t);
	     points[i].x = (int)(global.width/2+rho*cos(theta));
	     points[i].y = (int)(global.height/2-rho*sin(theta));
	  }
	global.t++;
        gdk_draw_lines(global.pixmap,
                       widget->style->black_gc,
                       points,
                       360);
	g_free(points);
	break;
     case SURFACE:
	draw_3D_surface(widget);
	break;
	
     default:
	g_error(_("A non existing option has been reached\n") );
	break;
     }
   
   gtk_widget_draw (widget, &update_rect);
   
   return TRUE;
}
