#include "gyapp.h"

extern struct GLOBAL global;

gboolean conffile(gchar flag)
/* Flag TRUE -> Write configuration */
/* Flag FALSE -> Read configuration if exist */
{
   static char *p=NULL;
   static char config_file_name[255];
   FILE *file;
   
   if (!p)
     {
	p=getenv("HOME");
	sprintf(config_file_name,"%s/.%s",p,PACKAGE);
     }
   
   if (flag)
     {
	file = fopen(config_file_name,"w");
	if (file == NULL)
	  {
	     g_warning(_("Can't open %s\n"),config_file_name);
	     return TRUE;
	  }
	if ( fwrite(&global, sizeof(struct GLOBAL),1,file) != 1)
	  {
	     g_warning(_("Writing error\n"));
	  }
	fclose(file);
     }
   else
     {
	/* Default settings */
        strcpy(global.function1,"50*cos(t/5)");
	strcpy(global.function2,"50*sin(t/5)");
	global.function_type=PARAMETRIC_2D;
	global.radius=4;
	global.miliseconds=500;
	global.draw_rules=TRUE;
	global.draw_trace=FALSE;
	global.xmax=global.ymax=100;
	global.xmin=global.ymin=-100;
	global.grid=10;
                                   
	file = fopen(config_file_name,"r");
	if (file == NULL)
	  {  
	     g_warning(_("Can't open %s\n"),config_file_name);
	     printf(_("This is a normal message if it's the first time you run %s\n"),
			PACKAGE);
	     return TRUE;
	  }
	if ( fread(&global, sizeof(struct GLOBAL),1,file) != 1)
	  {  
	     g_warning(_("Reading error\n"));
	  }
	global.pixmap=NULL;
	
	fclose(file);
     }
   return FALSE;
}
