/******************************************************************** 
 * Analiza.h 						    *
 * Fichero de cabecera para el Analizador recursivo descendente     *
 *                                                                  *
 * Su politica de distribucion es GNU                               *
 * AUTOR: Ignacio Martin Bragado				    *
 * Las mejoras o sugerencias sobre este programa seran estupenda-   *
 *   mente recibidas. Puedes realizarlas en la direccion del autor  *
 *   ignacio.martin@tel.uva.es				    *
 ********************************************************************/
/******************************************************************

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    For further information read the file COPYING
********************************************************************/

#ifndef _ANALIZADOR3D_H_
#define _ANALIZADOR3D_H_

#ifdef __MSDOS__
#	define VERSION_ANALIZADOR "2.1.0 DOS"
#else
#	define VERSION_ANALIZADOR "2.1.0 Linux"
#endif

#define DELIMITADOR	1
#define VARIABLE	2
#define NUMERO		3
#define FUNCION		4
#define NUM_FUNC	13	/* Numero de funciones que admite */
#define VARIABLES_MAXIMAS 500	/* Numero maximo de variables */

# include <libintl.h>
#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define _(String) gettext (String)
#define N_(String) (String)

// Definiciones de portabilidad
//Para las ALPHA
#ifndef EDOM
#	define EDOM 1
#	define ERANGE 2
#endif

struct VARIABLES
{	char nombre[40];
	long double valor;
};

long double analiza3d(char *, long double, long double, long double);
void asigna(long double *resultado);
void relacion(long double *resultado);
void suma(long double *);
void multiplica(long double *);
void fn(long double *);
void eleva(long double *);
void signos(long double *);
void parentesis(long double *);
void primitiva(long double *);
long double funciones (char *, long double);
void devuelve(void);
long double busca_var(char *);
void serror(int);
void obt_operador(void);
int esblanco(char);
int esdelim(char c);
int esta_en(char,char *);
int es_funcion(char *);
void func_err(void);
void guarda_variable(char *,long double);
void libera_variables(void);
int comandos(char *);

/* Texto de ayuda */
#define AYUDA         "ayuda [comando]      Ofrece informacion sobre 'comando'\n\
Valores para comando: var libre borra adios\n"
#define AYUDA_VAR     "var              Muestra todas las variables actuales\n"
#define AYUDA_BORRA   "borra variable   Elimina 'variable' de la memoria de variables\n"
#define AYUDA_LIBRE   "libre            Muestra el espacio libre para asignacion de variables\n"
#define AYUDA_ADIOS	 "adios            Manda una seal de salida al programa\n"

#endif
