/******************************************************************** 
 * analiza.cc                                                       *
 * Analizador recursivo descendente                                 *
 * Esta rutina se trata de un analizador recursivo descendente de   *
 * numeros reales. Aunque es utilizado por el programa schro.cpp    *
 * con el cual se suministra, incluye una pequena funcion main para *
 * poder ejecutar solo el analizador                                *
 * Su politica de distribucion es GNU                               *
 * AUTOR: Ignacio Martin Bragado                                    *
 * Las mejoras o sugerencias sobre este programa seran estupenda-   *
 *   mente recibidas. Puedes realizarlas en la direccion del autor  *
 *   ignacio.martin@tel.uva.es                                      *
 ********************************************************************/
/******************************************************************

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    For further information read the file COpYING
********************************************************************/

#include "gyapp.h"

extern int errno;
extern gboolean print_error;

char *prog,operador[80],tipo_tok, *inicial, ultima_variable[40];
int _error_analizador;

struct VARIABLES *vars[VARIABLES_MAXIMAS];

long double 
analiza3d(char *expresion, long double x, long double y, long double t)
{
   long double resultado;
   _error_analizador=-1;
   
   prog=inicial=expresion;	/* Asigno puntero a la cadena que me dan */
   guarda_variable("x",(long double) x); /* Asigno valor a analizar */
   guarda_variable("y",(long double) y); /* Asigno valor a analizar */
   guarda_variable("t",(long double) t); /* Asigno valor a analizar */

   guarda_variable("pi",M_PI);
   guarda_variable("e",M_E);
   
   if (comandos(expresion))
     {	if (_error_analizador==-1)
	   _error_analizador=13;
	return 0;
     }
   
   obt_operador();
   
   if(!*operador)
     {	serror(2);
	return(0);
     }
   relacion(&resultado);
   if(tipo_tok)
       serror(0);
   return(resultado);
}

/*	Relacion */
/* Se encarga de los operadores < y > */
void relacion(long double *resultado)
{
	register char opcion;
	long double res_parcial;

	suma(resultado);
	while( (opcion =(char) *operador) == '<' || opcion == '>' )
	{	obt_operador();
		suma(&res_parcial);
		if (opcion == '<') *resultado = (*resultado < res_parcial)? 1:0;
		if (opcion == '>') *resultado = (*resultado > res_parcial)? 1:0;
	}
}


/*	Suma */
/* Se encarga de sumar y restar */
void suma(long double *resultado)
{
	register char opcion;
	long double res_parcial;

	multiplica(resultado);
	while( (opcion =(char) *operador) == '+' || opcion == '-' )
	{	obt_operador();
		multiplica(&res_parcial);
		*resultado = (opcion == '+')? *resultado+res_parcial:*resultado-res_parcial;
	}
}
/* Multiplica */
/* Se encarga de multiplicar, dividir y hallar restos */
void multiplica (long double *resultado)
{
	register char opcion;
	long double res_parcial;

	fn(resultado);
	while ( (opcion=*operador) == '*' || opcion == '/' || opcion == '%')
	{	obt_operador();
		fn(&res_parcial);
		switch(opcion)
		{	case '*':
				*resultado*=res_parcial;
				break;
			case '/':
				if (res_parcial)
					*resultado/=res_parcial;
				else
					serror(3);
				break;
			case '%':
				if(res_parcial)
					*resultado=(int) *resultado % (int)res_parcial;
				else
					serror(3);
				break;
		}
	}
}

void fn(long double *resultado)
{
	char opcion[255];

	if (tipo_tok== FUNCION)
	{	strcpy(opcion,operador);
		obt_operador();
		eleva(resultado);
		errno=0;	/*Elimino errores anteriores*/
		*resultado=funciones(opcion,*resultado);
		if (errno)
			func_err();
	}
	else eleva(resultado);
}

void eleva(long double *resultado)
{
	long double res_parcial;

	signos(resultado);
	while ( *operador == '^')
	{	obt_operador();
		signos(&res_parcial);
		*resultado=pow(*resultado,res_parcial);
	}
}

void signos(long double *resultado)
{
	register char opcion=0;

	if ( (tipo_tok == DELIMITADOR) && (*operador=='+' || *operador=='-') )
	{	opcion=*operador;
		obt_operador();
	}
	asigna(resultado);
	if (opcion=='-') *resultado= -(*resultado);
}


void asigna(long double *resultado)
{
	char nombre_var[40];

	parentesis(resultado);

	if (*operador == '=')
	{	strcpy(nombre_var,ultima_variable);
		obt_operador();
		relacion(resultado);
		guarda_variable(nombre_var,*resultado);
	}

}


void parentesis(long double *resultado)
{
	if ( (*operador== '(') && (tipo_tok == DELIMITADOR) )
	{	obt_operador();
		relacion(resultado);
		if(*operador != ')')
			serror(1);
		obt_operador();
	}
	else
		primitiva(resultado);
}
void primitiva(long double *resultado)
{
	switch(tipo_tok)
	{	case VARIABLE:
			strcpy(ultima_variable,operador);
			*resultado=busca_var(operador);
			obt_operador();
			break;
		case NUMERO:
			*resultado=atof(operador);
			obt_operador();
			break;
		case FUNCION:
			fn(resultado);
			break;
		default:
			serror(0);
	}
}
long double funciones (char *func,long double numero)
{
	if (!strcasecmp(func,"SIN"))
		return (sin(numero));
	if (!strcasecmp(func,"COS"))
		return (cos(numero));
	if (!strcasecmp(func,"TAN"))
		return (tan(numero));
	if (!strcasecmp(func,"SINH"))
		return (sinh(numero));
	if (!strcasecmp(func,"COSH"))
		return (cosh(numero));
	if (!strcasecmp(func,"TANH"))
		return (tanh(numero));
	if (!strcasecmp(func,"ASIN"))
		return (asin(numero));
	if (!strcasecmp(func,"ACOS"))
		return (acos(numero));
	if (!strcasecmp(func,"ATAN"))
		return (atan(numero));
	if (!strcasecmp(func,"ABS"))
		return (fabs(numero));
	if (!strcasecmp(func,"LN"))
		return (log(numero));
	if (!strcasecmp(func,"LOG"))
		return (log10(numero));
	if (!strcasecmp(func,"SQRT"))
		return (sqrt(numero));
	return(0);
}

void devuelve(void)
{
	char *t;

	t=operador;
	for(;*t;t++)
		prog--;
}

void serror(int error)
{
   char temp[255];
   static char *e[]=
     {	N_("Incorrect syntax"),
	N_(") expected"),
	N_("No expresion"),
	N_("Division by zero"),
	N_("Incorrect argument"),
	N_("Functions cannot operate in a singularity"),
	N_("Return value too big"),
	N_("Return value too small"),
	N_("No significative result"),
	N_("Incorrect variable name, or variable name not yet asign"),
	N_("Invalid operation for non integer values"),
	N_("Variables memory is full"),
	N_("Memory full"),
	N_("Command done")
     };
   static int m[]=
     {	0,0,0,0,0,0,0,0,0,1,0,0,0,1 };
   static char *mensaje[2]=
     {	N_("Error"),
	N_("Warning")
     };
   _error_analizador=error;
   if (print_error)
     { 
	gchar error_label[80], error_text[255];
	
	strcpy (temp, inicial);
	temp[prog-inicial] = 0;
	sprintf(error_label,_("%s: %s"),_(mensaje[m[error]]),_(e[error]));
	
	sprintf(error_text,"%s: %s\n%s%s\n%s%s",
		_(mensaje[m[error]]),_(e[error]),
		temp,_(" <-??"),temp,prog);
	message_box(error_label,error_text);
	
     }
   
}

void obt_operador(void)
{
	register char *temp;

	tipo_tok=0;
	temp=operador;

	while(esblanco(*prog)) ++prog;
	if(esta_en(*prog,"+-*/%^=()<>"))
	{	tipo_tok=DELIMITADOR;
		*temp++=*prog++;
	}
	else if(isalpha(*prog))
	{	while(!esdelim(*prog)) *temp++=*prog++;
		tipo_tok=VARIABLE;
	}
	else if (esta_en(*prog,"01234567890."))
	{	char banderin=0;
		while (1)
		{	switch(*prog)
			{
				case 'e':	//Para permitir cosas como 2e-30
				case 'E':
					if (banderin)		//Dos e es un error sintactico
						serror(0);
					if (*(prog+1) == '-')
						*temp++=*prog++;
					*temp++=*prog++;
					banderin=1;
				break;
				default:	
					if(esdelim(*prog))
					{	tipo_tok=NUMERO;
						*temp=0;
						return;
					}
					*temp++=*prog++;
				break;
			}
		}
	}

	*temp=0;
	if (tipo_tok== VARIABLE)
		if ( es_funcion(operador) )
			tipo_tok=FUNCION;
}

int esblanco(char c)
{
	if (c==' ' || c==9) return 1;
	return 0;
}
int esdelim(char c)
{
	if (esta_en(c," +-/*%^=()<>") || c==9 || c=='\r' || c==0)
		return 1;
	return 0;
}
int esta_en(char ch,char *s)
{
	while(*s)
		if (*s++==ch)
			return 1;
	return 0;
}
int es_funcion(char *cadena)
{
	register int cont;
	static char *funciones[NUM_FUNC]=	/* Funciones que tiene */
	{	"SIN","COS","TAN",
		"SINH","COSH","TANH",
		"ASIN","ACOS","ATAN",
		"ABS","LN","LOG",
		"SQRT"
	};

	for (cont=0;cont<NUM_FUNC;cont++)
		if (!strcasecmp(cadena,funciones[cont]))
			return(1);
	return(0);
}

void func_err(void)
{
	switch(errno)
	{	case EDOM:	/* Fuera de dominio */
			serror(4);
			break;
		case ERANGE:	/* Singularidad */
			serror(5);
			break;
	}
}

void guarda_variable(char *se_llama, long double vale)
{
   int i;
   
   if(!isalpha(*se_llama))	//Comprueba que este bien.
     {  
	serror(1);
	return;
     }
   
   for (i=0;i<VARIABLES_MAXIMAS;i++)
     {	
	if(vars[i])          //Si existe el valor
	  {	
	     if (!strcasecmp(vars[i]->nombre,se_llama)) //Si es igual el nombre
	       {
		  vars[i]->valor = vale;				//Asigna y se sale
		  return;
	       }
	  }
     }
   //Si llega aqui es que es una variable nueva!
   
   for (i=0;i<VARIABLES_MAXIMAS;i++)	
     {	
	if (!vars[i])			//Busco una libre
	    break;
     }
	
   if (i == VARIABLES_MAXIMAS)
     {	
	serror(11);	// Informa y se va
	return;
     }
   vars[i] = (struct VARIABLES *) g_malloc (sizeof(struct VARIABLES));
   if (!vars[i])
     {	
	serror(12);
	return;
     }
   strcpy(vars[i]->nombre, se_llama);	// Copio nombre
   vars[i]->valor = vale;					// y pongo que vale.
}

long double busca_var(char *s)
{
   int i;
   
   if(!isalpha(*s))
     {  
	serror(1);
	return(0);
     }
   for (i=0;i<VARIABLES_MAXIMAS;i++)
     {	
	if(vars[i])				//Si existe el valor
	  {	
	     if (!strcasecmp(vars[i]->nombre,s))	//Si es igual el nombre
		 return vars[i]->valor;
	  }
     }
   serror(9);
   return 0;
}

void libera_variables(void)
{
	int i;

   for (i=0;i<VARIABLES_MAXIMAS;i++)
	{
	   if(vars[i])				//Si existe el valor
	     {	
		g_free(vars[i]);	//Lo libera
		vars[i]=NULL;
	     }
	}
}

int comandos(char *texto)
{
   int i,cuantas=0;
   char cadena[500];
   char *p;
   
   strcpy(cadena,texto);
   p= strtok(cadena," ");	//Obtengo token 1.
   if(!p)
     {	
	serror(2);
	return 1;
     }	
   if (!strcasecmp(p,"adios") || !strcasecmp(p,"quit") )
	{
	   _error_analizador = -2;
	   return 1;
	}
   if (!strcasecmp(p,"var"))
     {
	for (i=0;i<VARIABLES_MAXIMAS;i++)
	  {	
	     if(vars[i])
		 printf("%s\t",vars[i]->nombre);	
	  }
	printf("\n");
	return 1;
     }
   if (!strcasecmp(p,"libre"))
     {
	for (i=0;i<VARIABLES_MAXIMAS;i++)
	  {
	     if(vars[i])
		 cuantas++;
	  }
	printf("Total: %u\tUsadas: %u\tLibres: %u\n",VARIABLES_MAXIMAS,cuantas,VARIABLES_MAXIMAS-cuantas);
	return 1;
     }
   if (!strcasecmp(p,"borra"))
     {	//Busco el segundo argumento
	p=strtok(NULL," ");
	if (!p)		//Si no hay segundo argumento
	    serror(4);
	else
	  {
	     for (i=0;i<VARIABLES_MAXIMAS;i++)
	       {
		  if(vars[i])
		      if(!strcasecmp(p,vars[i]->nombre))
		    {
		       g_free(vars[i]);
		       vars[i]=NULL;
		       break;
		    }
	       }
	     if (i==VARIABLES_MAXIMAS)
		 serror(9);
	  }
	return 1;
     }
   if (!strcasecmp(p,"?") || !strcasecmp(p,"ayuda"))
     {	
	p=strtok(NULL," ");
	if (!p)
	    printf(AYUDA);
	else
	  {
	     if (!strcasecmp(p,"var"))
		 printf(AYUDA_VAR);
	     else if (!strcasecmp(p,"libre"))
		 printf(AYUDA_LIBRE);
	     else if (!strcasecmp(p,"borra"))
		 printf(AYUDA_BORRA);
	     else if (!strcasecmp(p,"adios"))
		 printf(AYUDA_ADIOS);
	     else
		 serror(4);
	  }
	return 1;
     }
   return 0;	
}	
