import java.applet.Applet;
import java.awt.*;
import java.io.StreamTokenizer;
import java.io.InputStream;
import java.io.IOException;
import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Vector;
import java.util.StringTokenizer;
import Parser;
import PositionLayout;


public class Search extends Applet {
   private   PS_Interface GUI;
   public   Button       starts, stops, gotod, clears;
   public   Vector       results;
   procSearch s;

// -----------------------------------------------------------------------------------------
// The files which will be searched, if the concerned chapter is activated are defined here
// -----------------------------------------------------------------------------------------
   public String[] DEF_overviewFiles={ 
   "contactF.html",
   "overviewF_contactOpen.html",
   "search.html",
   "indexF.html",
   "introF.html",
   "using_helpF.html"
   }; // these files are searched in addition to the files below, when the Option "All Help Files" is activated.
   
   public String[] DEF_genInfoFiles={ 
   "general_infoF.html", 
   "introF.html", 
   "general_info/concepts.html",
   "general_info/license.html",
   "general_info/platform.html"
   }; // files searched, when the General Information option is activated
   
   public String[] DEF_userIntFiles={ 
   "user_interfaceF.html", 
   "keyboardF.html", 
   "user_interface/abstraction_menu.html", 
   "user_interface/find_window.html", 
   "user_interface/navigation_menu.html", 
   "user_interface/base_window.html", 
   "user_interface/generalSettings.html", 
   "user_interface/navigator_window.html", 
   "user_interface/daVinci_info_window.html", 
   "user_interface/graph_info_window.html",
   "user_interface/options_menu.html", 
   "user_interface/edit_menu.html", 
   "user_interface/help_menu.html", 
   "user_interface/pop_up.html", 
   "user_interface/file_menu.html", 
   "user_interface/layout_menu.html", 
   "user_interface/print_file_browser.html", 
   "user_interface/file_selector_connect.html", 
   "user_interface/layoutAlgo_window.html",
   "user_interface/print_window.html", 
   "user_interface/file_selector_open.html", 
   "user_interface/layoutDimensions_window.html", 
   "user_interface/scale_window.html", 
   "user_interface/file_selector_save.html", 
   "user_interface/mouse.html", 
   "user_interface/view_menu.html" 
   }; // files searched, when the User Interface option is activated
   
 
 
   public String[] DEF_tutorialFiles={ 
   "tutorialF.html", 
   "tutorial/beforeBegin.html", 
   "tutorial/files.html", 
   "tutorial/graphedit.html", 
   "tutorial/interactions.html", 
   "tutorial/layout.html", 
   "tutorial/multi.html" 
   }; // files searched, when the Tutorial option is activated
   
   public String[] DEF_questAnswFiles={ 
      "q_aF.html", 
    }; // files searched, when the Question and Answers option is activated 
   
   public String[] DEF_newFeatFiles={ 
   "new_featuresF.html", 
   }; // files searched, when the New Features option is activated
   
   public String[] DEF_referenceFiles={ 
   "referenceF.html",
   "reference/grapheditor.html",
   "reference/postscript.html",
   "reference/bibliography.html",
   "reference/options.html",
   "reference/tools.html",
   "reference/api/api.html",
   "reference/api/api_graph_cmd",
   "reference/api/api_graph_cmd.html",
   "reference/api/api_special_cmd.html",
   "reference/api/api_all_answ.html",
   "reference/api/api_menu_cmd.html",
   "reference/api/api_syntax.html",
   "reference/api/progguide.html",
   "reference/api/api_answ.html",
   "reference/api/api_multi_cmd.html",
   "reference/api/api_tcl_cmd.html",
   "reference/api/starter.html",
   "reference/api/api_app_menu_cmd.html",
   "reference/api/api_param.html",
   "reference/api/api_window_cmd.html",
   "reference/api/termrep.html",
   "reference/api/api_cmd.html",
   "reference/api/api_set_cmd.html",
   "reference/api/connect.html",
   "reference/api/transition.html" 
   }; // files searched, when the Reference Files option is activated
// --------------------------
// End of File Definition
// --------------------------




   public void init() {
      Panel p = new Panel();
      Panel local = new Panel();
      GUI = new PS_Interface();
      results=new Vector();

      local.setLayout(new GridLayout(4, 1, 80, 10));  //layout manger for panel
      starts = new Button("Start Search"); local.add(starts);   
      stops = new Button("Stop Search"); local.add(stops);
      clears = new Button("Clear Keyword"); local.add(clears);
      gotod = new Button("Go to"); local.add(gotod);

      gotod.disable(); GUI.results.disable(); stops.disable();
      p.add(GUI);      
      p.add(local); 
      add(p);
      GUI.statusOut("Search Engine initialized.");
   }
 
   public boolean action(Event evt, Object arg) {      
      if (evt.target==starts) {
        stops.enable();
        starts.disable(); clears.disable(); gotod.disable(); GUI.results.disable();
        GUI.chapter.disable(); GUI.inputKey.disable(); clears.disable();
        GUI.statusOut("Search started.");
        GUI.repaint();
        for(int i=1;i<=GUI.results.countItems();i++) GUI.results.clear();         
        s=new procSearch(this,GUI,results);
        s.start(); 
      } else if ("Go to".equals(arg) || evt.target==GUI.results) {
         URL url = (URL)results.elementAt(GUI.results.getSelectedIndex());
         if (GUI.same.getState()==true) getAppletContext().showDocument( url ,"_self");
         else getAppletContext().showDocument( url ,"_blank");
      } else if (evt.target==stops) s.abort();
      else if ("End Search".equals(arg)) {
         starts.enable(); clears.enable(); stops.disable();
         GUI.chapter.enable(); GUI.inputKey.enable(); clears.enable();
         GUI.statusOut("End of Search.");
         repaint();
      } else if ("Abort Search".equals(arg)) {
         starts.enable(); clears.enable(); stops.disable();
         GUI.chapter.enable(); GUI.inputKey.enable(); clears.enable();
         GUI.statusOut("Search aborted.");
         repaint();
      }	else if ("Clear Keyword".equals(arg)) {
	 GUI.inputKey.setText("");
	 repaint();
      } else {
        GUI.statusOut("");
      }
      return true;
   }
   
   public static void main(String args[]) {
        Frame f = new Frame("daVinci Searcher");
	Search  searcher = new Search();
        searcher.init();
        f.add("Left", searcher);
        f.resize(380, 280);
        f.show();
   }
} 


class procSearch extends Thread {                 
   private Vector       results;
   private Search       parent;
   public boolean       stop;
   public URL           url;
   private PS_Interface GUI;

   public procSearch(Search oParent, PS_Interface oGUI, Vector oResults) {
     parent=oParent;
     GUI=oGUI;

     results=oResults;
     results.removeAllElements();
     GUI.results.clear();
     stop=false;
   }

   public void run() {
     if(GUI.chapter.getSelectedItem()==GUI.DEF_All) {
       searchFiles(parent.DEF_overviewFiles);     
       if (!stop) searchFiles(parent.DEF_genInfoFiles);
       if (!stop) searchFiles(parent.DEF_userIntFiles);
       if (!stop) searchFiles(parent.DEF_tutorialFiles);
       if (!stop) searchFiles(parent.DEF_questAnswFiles);
       if (!stop) searchFiles(parent.DEF_newFeatFiles);
       if (!stop) searchFiles(parent.DEF_referenceFiles);
     }
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_GenInfo) searchFiles(parent.DEF_genInfoFiles);
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_UserInt) searchFiles(parent.DEF_userIntFiles);
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_Tut) searchFiles(parent.DEF_tutorialFiles);
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_QA) searchFiles(parent.DEF_questAnswFiles);
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_New) searchFiles(parent.DEF_newFeatFiles);
     else if(GUI.chapter.getSelectedItem()==GUI.DEF_Ref) searchFiles(parent.DEF_referenceFiles);
     if (stop) parent.postEvent(new Event(this, Event.ACTION_EVENT,"Abort Search"));
     else parent.postEvent(new Event(this, Event.ACTION_EVENT,"End Search"));
   }

   public void abort() {   
     stop=true;
   }

   public void start() {
     stop=false;
     super.start();
     Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
   }


   public void searchFiles(String files[]) {
     InputStream is;
     
     for(int i=0; i<files.length && !stop; i++) {
       try {
         url=new URL(parent.getDocumentBase(),files[i]);
         String key_s = GUI.inputKey.getText().toUpperCase();
         try {
           is = url.openStream();
           htmlParser parser= new htmlParser(is,GUI,this,parent);
           parser.score(key_s);
           if (is != null)
  	   is.close();
         } catch(Exception e) {}
       } catch (MalformedURLException e) {
         GUI.statusOut("Could not open URL, sorry.");
       }
       int startIndex=files[i].lastIndexOf('/');
       if (startIndex==-1) GUI.statusOut(files[i]);
       else GUI.statusOut(new String(files[i].substring(startIndex+1,files[i].length())));
     }
   }
}


class htmlParser extends Document {
   private PS_Interface GUI;
   private procSearch psParent;
   private Search sParent;

   htmlParser(InputStream is,PS_Interface oGUI, procSearch opsParent, Search osParent) {
      GUI=oGUI;
      psParent=opsParent;
      sParent=osParent;
      new Parser(is, this);
   }

   public void score(String keyword) {
      int nkwords;
      String word;

      String source = new String(text,0).toUpperCase();
      int count=0;
      int i;
      i=source.indexOf(keyword);
      if(i!=-1) count++;
      while (i!=-1 && !psParent.stop){ 
        i = source.indexOf(keyword, i+1);
        if(i!=-1) count++;     
      }
      if (count>0 && !psParent.stop) {
         GUI.results.addItem(this.getTitle()+" ("+count+")");
         sParent.results.addElement(psParent.url);
         sParent.gotod.enable(); GUI.results.enable();
         GUI.repaint();    
      }
   }   
}


class PS_Interface extends Panel {
   public Choice       chapter;
   public searchList   results;
   public TextField    inputKey;    
   public Checkbox     same;
   public Label        statusLine;

   public static String DEF_All     = "All Help Files";
   public static String DEF_GenInfo = "General Information";   
   public static String DEF_UserInt = "User Interface"; 
   public static String DEF_Tut     = "Tutorial";
   public static String DEF_QA      = "Questions and Answers";
   public static String DEF_New     = "New Features of daVinci V2.0";
   public static String DEF_Ref     = "Reference";
   
   public PS_Interface() {   
      setLayout(new PositionLayout());
          
      chapter = new Choice();
      
      chapter.addItem(DEF_All); chapter.addItem(DEF_GenInfo);
      chapter.addItem(DEF_UserInt); chapter.addItem(DEF_QA);
      chapter.addItem(DEF_Tut); chapter.addItem(DEF_New); 
      chapter.addItem(DEF_Ref);            
 
      inputKey=new TextField("",24);

      add("1 0",new Label("Search in Chapter:"));   
      add("135 0",chapter);
      add("1 35",new Label("Search for Keyword:"));
      add("135 35",inputKey);

      add("1 70",new Label("Go to Page in:"));
      CheckboxGroup winMode = new CheckboxGroup();  
      add("100 70",new Checkbox("New Window", winMode, true));
      same=new Checkbox("Same Window", winMode, false);
      add("220 70",same);

      results = new searchList(6, false);
      add("1 100",results);
      
      statusLine = new Label("",Label.LEFT);
      add("1 240",statusLine);
   }  
   
   public void statusOut(String status) {
     statusLine.setText(status);
     repaint();
   }

}


class searchList extends java.awt.List {
   static private int WIDTH = 360;
   public searchList(int a, boolean b) { super(a, b); }
   
   public Dimension preferredSize(int rows) {
      return new Dimension(WIDTH,super.preferredSize(rows).height);
   }
}
