// The number system.
#ifndef VECTORS_H
#define VECTORS_H
#include <math.h>
typedef double real;
struct vector {
  real x[3]; /* x[0] is x, x[1] is y, x[2] is z */
  vector () {}
  vector (real x_, real y_, real z_)
  {
    x[0] = x_;
    x[1] = y_;
    x[2] = z_;
  }
  vector operator+(vector b)
  {
    return vector (x[0] + b.x[0], x[1] + b.x[1], x[2] + b.x[2]);
  }
  vector operator-(vector b)
  {
    return vector (x[0] - b.x[0], x[1] - b.x[1], x[2] - b.x[2]);
  }
  vector operator*(real b)
  {
    return vector (x[0]*b, x[1]*b, x[2]*b);
  }
  vector operator*=(real b)
  {
    x[0]*=b;
    x[1]*=b;
    x[2]*=b;
    return *this;
  }
  vector operator+=(vector b)
  {
    x[0]+=b.x[0];
    x[1]+=b.x[1];
    x[2]+=b.x[2];
    return *this;
  }
  vector operator-=(vector b)
  {
    x[0]-=b.x[0];
    x[1]-=b.x[1];
    x[2]-=b.x[2];
    return *this;
  }
  #if 0
  vector operator*(vector &b) // cross product
  {
    return vector (
      x[1]*b.x[2] - x[2]*b.x[1],
      x[2]*b.x[0] - x[0]*b.x[2],
      x[0]*b.x[1] - x[1]*b.x[0]
    );
  }
  #endif
};
inline double dot(vector a, vector b)
{
  return a.x[0]*b.x[0] + a.x[1]*b.x[1] + a.x[2]*b.x[2];
}
inline double norm (vector a)
{
  return sqrt (a.x[0]*a.x[0] + a.x[1]*a.x[1] + a.x[2]*a.x[2]);
}
inline vector normalize (vector a)
{
  real l;
  
  l = norm (a);
  return vector (a.x[0] / l, a.x[1] / l, a.x[2] / l);
}
inline vector operator-(vector a)
{
  return vector (-a.x[0], -a.x[1], -a.x[2]);
}
inline vector operator*(real x, const vector &a)
{
  return vector (x*a.x[0],x*a.x[1],x*a.x[2]);
}
inline vector operator*(const vector &a, const vector &b) // cross product
{
  return vector (
    a.x[1]*b.x[2] - a.x[2]*b.x[1],
    a.x[2]*b.x[0] - a.x[0]*b.x[2],
    a.x[0]*b.x[1] - a.x[1]*b.x[0]
  );
}

inline vector Burnstein (real t, vector *p, int degree)
{ // Evaluate a Burnstein polinomial with coefficients p[0..degree] at t
  // 0 <= t <= 1. Note that p is an array with degree+1 entries.
  if (t == 0) return p[0];
  
  real mul = pow (t, degree), c = (1-t)/t;
  vector result = mul * p[0];
  for (int i = 1; i <= degree; i++) {
    mul *= c * (degree - i + 1) / (double) i;
    result += mul * p[i];
  }
  return result;
}

typedef struct {
  vector a, b; // The box is defined by any two opposite points
  int Contains (vector v)
  {
    int i;
    for (i=0;i<3;i++) {
      if (a.x[i] <= b.x[i]) {
        if (v.x[i] < a.x[i] || b.x[i] < v.x[i]) return 0;
      }
      else {
        if (v.x[i] < b.x[i] || a.x[i] < v.x[i]) return 0;
      }
    }
    return 1;
  }
} cube;

#ifdef GL_H
  inline void gl (vector a)
  {
    glVertex3dv (a.x);
  }
#endif
#endif /* NUMBERS_H */
