#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
extern "C" {
  #include "mathlib.h"
}

#define N 1024
double price[N];

GC gc;
Display *dis;
Window win;

static void TekenBeeld(Widget w, XEvent *ev, String *params,Cardinal *num)
{
  int x,y,oldY;
  short wid,h;
  XtVaGetValues (w, XtNwidth, &wid, XtNheight, &h, NULL);
  oldY=h-int(price[0]*h/2);
  for (x=1;x<wid;x++) {
    double p=x*N/(double)wid;
    y=h-int(
      ((price[1+(int)p]-price[(int)p])*(p-floor(p)) + price[(int)p])*h/2
    );
    XDrawLine(dis,win,gc,x-1,oldY,x,y);
    oldY=y;
  }
}

void main(int argc, char *argv[])
{
  int i;
  static String trans="<Expose>: TekenBeeld()\n";
  static XtActionsRec actions[]={
    {"TekenBeeld"       ,TekenBeeld},
  };
  Widget top,box,beeld;
  XtAppContext ac;
    
    
  srand (time (NULL));
  double logPrice=0;
  for (i = 0; i < N; i++) {
    price[i]=exp(logPrice);
    logPrice+=InverseNormal(rand()/(RAND_MAX+1.0))*log(1.30)/sqrt(N) +
      log(1.15)/(double)N;
  }
  top = XtVaAppInitialize(&ac, "graph", NULL, 0, &argc, argv, NULL, NULL);
  XtAppAddActions (ac, actions, XtNumber(actions));
  box=XtVaCreateManagedWidget ("box",boxWidgetClass,top,NULL);
  beeld=XtVaCreateManagedWidget("diagram", simpleWidgetClass,
    box,
    XtNtranslations, XtParseTranslationTable (trans),
    XtNwidth, 640,
    XtNheight, 480,
    NULL);
                            
  XtRealizeWidget(top);
  dis = XtDisplay(beeld);
  win = XtWindow(beeld);
  gc=XCreateGC(dis,win,0,NULL);

  XtAppMainLoop (ac);                                    
}

