#include <stdio.h>

#include "mathlib.h"

double TestRandom (unsigned *occur, int n)
{
  unsigned total = 0, i;
  double chi, expected;
  
  for (i=0;i<n;i++) total+=occur[i];
  
  expected=total/(double)n;
  if (expected < 5) *(char*)NULL=0; /* Can currently handle this well. */
  for (i=0;i<n;i++) chi+=(occur[i]-expected)*(occur[i]-expected);

  printf ("%d %lf\n",total,chi);
  return CumulativeChiSquare (chi/expected, n - 1);
}

#include <string.h>
#define PROB 0.001

int main(void)
{
  unsigned cnt[256], chainCnt[256];
  unsigned ch, last = 0;
  double p;

  memset (cnt, 0, sizeof (cnt));
  memset (chainCnt, 0, sizeof (chainCnt));

  while ((ch=getchar ()) != EOF) {
    cnt[ch]++;
    chainCnt[ch^last]++;
    last = ch;
  }
  p = TestRandom (cnt, 255);
  printf("%lf\n",p);
  if (p < PROB || /* If the input is too well distributed or */
  p > 1 - PROB) { /* too skew */
    fprintf (stderr, "Alphabet not used randomly\n");
    return 1;
  }
  p = TestRandom (chainCnt, 255);
  printf("%lf\n",p);
  if (p < PROB || p > 1 - PROB) {
    fprintf (stderr, "Consecutive characters are dependant\n");
    return 2;
  }
  printf ("random\n");
  return 0;
}

