// Nic Roets (9512391) Finansie"le Ingenieurswese WTW722 October 1998
// Here is a C++ program that calculates the value of the American call on
// a stock with a continues dividend yield. Output is at the end.
#include <math.h>
#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <time.h>
#include <assert.h>
#include "mathlib.h"

double N (double x)
{
  //cout <<"N("<<x<<")\n";
  if (x < 0) return 1-N(-x);
  double k=1/(1+0.2316419*x);
  return 1-exp(-x*x/2)/sqrt(2*M_PI)*(0.319381530*k-0.356563782*k*k+
  1.781477937*k*k*k-1.821255978*k*k*k*k+1.330274429*k*k*k*k*k);

  int i;
  double y = fabs(x), z = -0.5*y*y, r = 0;
  if (y < 4.2) {
    for (i = 80 /*80*/; i >= 0; i--) {
      r *= z / (i+1);
      r += 1.0 / (2*i+1);
    }
    r *= y / sqrt (2 * M_PI);
  }
  else r=0.5 - exp(-y*y/2)/sqrt(2*M_PI) / y*(1-0.865172/y/y);
  if (x < 0) return 0.5 - r;
  return 0.5 + r;
}

double EuropeanCall(double spot, double strike, double T, double r, double q,
  double sigma)
{
  double b = r - q;
  double d1 = (log(spot/strike)+(b+sigma*sigma/2)*T) / sigma / sqrt(T);
  double d2 = d1 - sigma*sqrt(T);
  return spot*exp(-q*T)*N(d1) - strike*exp(-r*T)*N(d2);
}

double BWAmericanCall(double spot,double strike,double T,double r,double q,
  double sigma)
{
  double b=r-q;
  double Nminus1=2*b/sigma/sigma-1;
  double M=2*r/sigma/sigma;
  double K=1-exp(-r*T);
  double q2=(-Nminus1 + sqrt(Nminus1*Nminus1+4*M/K)) / 2;

  double SSL=0, SSR=1e+10, SS, d1SS; // S*(links), S*(regs), S*, d1(S*)
  while (SSL+1e-10 < SSR) {
    SS=(SSL+SSR)/2;
    d1SS=(log(SS/strike)+(b+sigma/sigma/2)*T) / sigma / sqrt(T);
    if(SS-strike <
    EuropeanCall(SS,strike,T,r,q,sigma)+(1-exp((b-r)*T)*N(d1SS))*SS/q2) {
      SSL=SS;
    }
    else SSR=SS;
  }
  //double SSi=strike/(1-1/q2),h2=-(b*T+2*sigma*sqrt(T))*(strike/(SSi-strike));
  //cout << SS<<" "<< strike+(SSi-strike)*(1-exp(h2))<<endl;
  if (spot >= SS) return spot-strike;
  return EuropeanCall(spot,strike,T,r,q,sigma)+
    (SS/q2)*(1-exp((b-r)*T)*N(d1SS))*pow(spot/SS,q2);
}

void main (int argc, char *argv[])
{
  //struct tm start={0,0,0,13,5-1,98,0,0,0};
  //struct tm stop ={0,0,0,17,9-1,98,0,0,0};
  //double T = (mktime(&stop) - mktime(&start))/3600.0/24.0/365.0; // 127 dae
  //double spot = 6903, sigma = 0.28, strike = 7000, r = 0.00, q=0;
  double T=0.1315, spot=223, sigma=0.2653, strike=250,r=0.2019, q=0.033;
  //double T=3,r=0.08,q=0.12,sigma=0.2, spot=120,strike=100;

  //double T=0.25,r=0.08,q=0.12,sigma=0.2, spot=110,strike=100;
  // This american call should cost 10.31 with Quadratic Approx.
  
  for (int i=0;i<10;i++) printf("%d %le %lf\n",i,N(1-i),1/N(-i));

  cout<<"European Call : "<<EuropeanCall(spot,strike,T,r,q,sigma)<<endl;
  cout<<"BW Amer Call  : "<<BWAmericanCall(spot,strike,T,r,q,sigma)<<endl;
  enum { call, put } cp = call;
  enum { american, european } ae = american;
  
  int n = argc > 1 ? atoi(argv[1]) : 100, i, j;
  double pTerug, eenMinPTerug, earlyEx, currentSpot, value[n + 1];
  double u = exp (sigma * sqrt (T / n)), dSquared=1/u/u;
  double p = (exp ((r-q) * T / n) - 1 / u) / (u - 1 / u);
  pTerug = p*exp(-r*T/n);
  eenMinPTerug=(1-p)*exp(-r*T/n);
  cout << setprecision (10);// << p << " " << u<<" " << endl <<endl;
  // Now get values for T
  for (j = 0; j <= n; j++) {
    double temp = spot * pow (u, n - 2*j) - strike;
    value[j] = cp == put ? -temp : temp;
    if (value[j] < 0) value[j] = 0;
  }
  for (i = n - 1; i >= 0; i--) {
    //for (j = 0; j <= i+1; j++) cout << value[j] << (j==i+1 ? "\n" : " ");
  // Now get values for T*i/n
    currentSpot=spot*pow(u,i);
    for (j = 0; j <= i; j++) {
      value[j] = pTerug * value[j] + eenMinPTerug * value[j+1];
      if (ae == american) {
        earlyEx = currentSpot - strike;
        currentSpot *= dSquared;
        if (cp == put) earlyEx = -earlyEx;
        if (value[j] < earlyEx) value[j] = earlyEx;
      }
    }
    value[i+1] = 0;
  }
  cout <<n<<" time steps with binomial method. The option is worth "<<
  value[0] << "\n";

  double deltas=10, deltat=T/n;
  int ns=int(strike*2/deltas);
  double f[ns], f2[ns];
  for (i=0;i<ns;i++) f[i]=i*deltas > strike ? i*deltas-strike : 0;
  for (i=0;i<n;i++) {
    f2[0]=0;
    for (j=1;j<ns-1;j++) {
      #if 0
      double as=(-(r-q)*j*deltas/2+sigma*sigma*j*j*deltat/2)/(1+r*deltat);
      double bs=(1-sigma*sigma*j*j*deltat)/(1+r*deltat);
      double cs=((r-q)*j*deltat/2+sigma*sigma*deltat/2)/(1+r*deltat);
      f2[j]=as*f[j+1]+bs*f[j]+cs*f[j-1];

      #else
      double temp = f[j]/deltat+ (r-q)*(j*deltas)*(f[j+1]-f[j-1])/(2*deltas)+
      sigma*(j*deltas)*sigma*(j*deltas)/2*(f[j+1]-2*f[j]+f[j-1])/
      (2*deltas*deltas);

      f2[j]=temp/(r+1/deltat);

      assert(fabs (
      -f2[j]*r+(f[j]-f2[j])/deltat+
      (r-q)*(deltas*j)*(f[j+1]-f[j-1])/(2*deltas)+
      sigma*sigma*(deltas*j)*(deltas*j)/2*(f[j+1]-2*f[j]-f[j-1])/
        (2*deltas*deltas)
      ) < 1e-10);
      #endif
    }
    f2[ns-1]=(ns-1)*deltas - strike;
    memcpy(f,f2,sizeof(f));
  }
  for (i=int(spot/deltas);i<int(spot/deltas)+2;i++) {
    cout<<"For a strike of "<<i*deltas<<" its value is "<<f[i]<<"\n";
  }
}

// European Call : 2.01936
// BAW Amer Call : 2.01936
//     12 time steps. The option is worth 1.857943194
//  10000 time steps. The option is worth 2.019388078
//  50000 time steps. The option is worth 2.019344189
// 100000 time steps. The option is worth 2.019350358
//
// Observe that the 13 time step binomial tree approximation gave 2.04466,
// which is an indication that an uneven number of time steps leads to an
// overvaluation, while an even number of time steps leads to an
// undervaluation.
// The 10000 time step approximation took 25 seconds on a Pentium 120

