#ifndef MATRIKS_H
#define MATRIKS_H
#include <iostream.h>
#include <iomanip.h>
#include <assert.h>
#include "gauselim.h"

inline double Kwadreer (double x) { return x * x; }

// 'n vektor en 'n matriks word op die selfde manier gestoor.
// Die enigeste verskille is vermenigvuldiging, en indeksering. Mens sou
// graag net een tipe wou gehad het, maar myMatriks[a][b] moet 'n getal wees.
// DAAR WORD ALTYD AANVAAR (SONDER OM TE TOETS) DAT DIE RELEVANTE DIMENSIES
// OOREENSTEM.
struct vektor {
  int totaal, *verwysings;
  int m; // 'n m x (totaal/m) matriks
  double *x;
  // Om tyd en geheue te spaar, word daar nie 'n kopie van die data gemaak
  // as 'n een matriks aan 'n ander gelyk gestel word nie. Ons allokeer
  // eerder ekstra geheue waarin daar getel word hoeveel verwysings daar
  // na die spesifieke geheue posisie is, en as al die verwysings verdwyn,
  // deallokeer ons die geheue, soos Smalltalk. Wat eintlik nou kort is
  // kode wat die data dupliseer as dit veander word soos fork() op Linux.
  vektor (int _totaal)
  {
    totaal = _totaal;
    x = new double[totaal];
    //cout << "n\n";
    m = _totaal;
    verwysings = new int;
    *verwysings = 1;
  }
  vektor (int _totaal, double *_x)
  {
    totaal = _totaal;
    x = _x;
    m = totaal;
    verwysings = NULL;
  }
  vektor (vektor &a)
  {
    totaal = a.totaal;
    x = a.x;
    m = a.m;
    verwysings = a.verwysings;
    if (verwysings) verwysings[0]++;
  }
  vektor ()
  {
    verwysings = NULL;
    totaal = 0;
  }
  ~vektor ()
  {
    if (verwysings && --verwysings[0] == 0) {
      delete x;
      delete verwysings;
      //cout << "d\n";
    }
  }
  vektor operator=(vektor b)
  {
    //cout << "a\n";
    if (verwysings && --verwysings[0] == 0) {
      delete x;
      delete verwysings;
      //cout << "d\n";
    }
    totaal = b.totaal;
    m = b.m;
    #if 0
      x = new double[totaal];
      memcpy (x, b.x, sizeof (x[0])*totaal);
      verwysings = new int;
      *verwysings = 1;
    #else
      x = b.x;
      verwysings = b.verwysings;
      if (verwysings) verwysings[0]++;
    #endif
    return *this;
  }
  vektor operator+(vektor b)
  {
    vektor antw (totaal);
    double *ax=x,*bx=b.x,*cx=antw.x;
    antw.m = m;
    for (int i=totaal;i>0;i--) *cx++ = *ax++ + *bx++;
    return antw;
  }
  vektor operator-(vektor b)
  {
    vektor antw (totaal);
    double *ax=x,*bx=b.x,*cx=antw.x;
    antw.m = m;
    for (int i=totaal;i>0;i--) *cx++ = *ax++ - *bx++;
    return antw;
  }
  double& operator[](int i)
  {
    return x[i];
  }
};
inline vektor operator*(double a, vektor b)
{
  vektor antw (b.totaal);
  double *bx = b.x, *cx = antw.x;
  antw.m = b.m;
  for (int i=b.totaal;i>0;i--) *cx++ = a * *bx++;
  return antw;
}

inline vektor NulVektor (int n)
{
  vektor antw (n);
  double *ptr = antw.x;
  for (int i=0;i<n;i++) *ptr++ = 0;
  return antw;
}

struct matriks:vektor {
  // The numbering is 0 1 2 for a 3x3 matrix.
  //                  3 4 5
  //                  6 7 8
  matriks (int _m, int _n) : vektor (_n * _m)
  {
    m = _m;
  }
  matriks (int _m, int _n, double *x) : vektor (_n * _m, x)
  {
    m = _m;
  }
  matriks (matriks &a) : vektor(a) // Shallow copy
  {
  }
  matriks () : vektor ()
  {
  }
  vektor operator[](int i)
  {
    return vektor (totaal/m, x + i*(totaal/m));
  }
  matriks operator+(matriks b)
  {
    return *(matriks*)& ((vektor&) *this + (vektor &)b);
  }
  matriks operator-(matriks b)
  {
    return *(matriks*)& ((vektor&) *this - (vektor &)b);
  }
  vektor operator*(vektor b)
  {
    vektor antw (m);
    double r,*aptr=x,*bptr;
    for (int i=0;i<m;i++) {
      r=0;
      bptr=b.x;
      for (int j=0;j<b.totaal;j++) r+=*bptr++ * *aptr++;
      antw.x[i] = r;
    }
    return antw;
  }
  matriks operator*(matriks b)
  {
    int breedte = b.totaal / b.m;
    matriks antw (m, breedte);
    for (int i=0;i<m;i++) { // Vir elke ry van antw
      for (int k = 0; k < breedte; k++) { // Vir elke kolom
        double r = 0, *aptr = x + i * totaal / m, *bptr = b.x + k;
        for (int j=0;j<totaal;j+=m) {
          r+=*bptr * *aptr++;
          bptr += breedte;
        }
        antw.x[i * breedte + k] = r;
      }
    }
    return antw;
  }
};
inline matriks Transponeer (matriks a)
{
  int n=a.totaal/a.m;
  matriks antw (n,a.m);
  double *ptr=antw.x;
  for (int i=0;i<n;i++) {
    for (int j=0;j<a.m;j++) {
      *ptr++ = a[j][i];
    }
  }
  return antw;
}
inline vektor operator/(vektor b, matriks a)
{ // a.totaal=a.m*a.m en b.totaal=a.m
  vektor antw (a.m);
  double *temp=new double[a.m*(a.m+1)];
  for (int i=0;i<a.m;i++) {
    memcpy (temp+i*(a.m+1),a.x+i*a.m,sizeof(a.x[0])*a.m);
    temp[i*(a.m+1)+a.m]=b.x[i];
  }
  int success = GaussEliminate (temp, antw.x, a.m, 1);
  assert (success);
  delete temp;
  return antw;
}
inline matriks operator/(matriks b, matriks a)
{
  int breedte = b.totaal / b.m;
  matriks antw (a.m, breedte);
  double *temp = new double[a.m*(a.m+breedte)];
  for (int i=0;i<a.m;i++) {
    memcpy (temp+i*(a.m+breedte),a.x+i*a.m,sizeof(a.x[0])*a.m);
    memcpy (temp+i*(a.m+breedte)+a.m,b.x+i*breedte, sizeof (a.x[0])*breedte);
  }
  int success = GaussEliminate (temp, antw.x, a.m, breedte);
  assert (success);
  delete temp;
  return antw;
}
inline matriks operator*(double a, matriks b)
{
  return *(matriks*)& (a * (vektor)b);
}
inline ostream& operator<<(ostream& str, vektor a)
{
  str << "[";
  for (int i=0;i<a.totaal;i++) str << ' ' << a.x[i];
  str << " ]";
  return str;
}
inline ostream& operator<<(ostream& str, matriks a)
{
  for (int i=0;i<a.m;i++) str << a[i] << '\n';
  return str;
}
inline matriks Identiteit (int m)
{
  matriks antw (m, m);
  int i;
  for (i=0;i<antw.totaal;i++) antw.x[i]=0;
  for (i=0;i<antw.totaal;i+=m+1) antw.x[i]=1;
  return antw;
}
inline matriks NulMatriks (int m, int n)
{
  matriks antw (m, n);
  double *ptr = antw.x;
  for (int i=0;i<antw.totaal;i++) *ptr++ = 0;
  return antw;
}
inline matriks YlMatriks (int m, int n)
{
  return NulMatriks (m, n);
}

#endif

