#ifndef MATRIKS_H
#define MATRIKS_H
#include <iostream.h>
#include <iomanip.h>
#include <assert.h>
#include "gauselim.h"

inline double Kwadreer (double x) { return x * x; }

struct simbool {
  char *naam;
  double waarde;
};
double Eval (const char *uitd, simbool *lys, int lysLengte);
double EvalXY (const char *uitd, double x, double y); // Sets up "x" and "y"

// 'n vektor en 'n matriks word op die selfde manier gestoor.
// Die enigeste verskille is vermenigvuldiging, en indeksering. Mens sou
// graag net een tipe wou gehad het, maar myMatriks[a][b] moet 'n getal wees.
// DAAR WORD ALTYD AANVAAR (SONDER OM TE TOETS) DAT DIE RELEVANTE DIMENSIES
// OOREENSTEM.

// ALLE INDEKSE TEL VAN 0 AF, NETSOOS DIE RES VAN C/C++

typedef struct nieNulInskrywing *nieNulLys;
struct nieNulInskrywing { // Stoor soms net die nie-nul inskrywings.
  double x; // Die waarde.
  int kol; // Die kolom met die inskrywing
  nieNulLys volg; // Geskakelde lys.
}; // Die feit dat hierdie struktuur 16 grepe lank is behoort ook te help

void SoekKol (int kol, nieNulLys &itr);

struct vektor {
  int totaal;
  nieNulInskrywing *nn;
  // Vir 'n gewone matriks is nn NULL, en x word gebruik. Anders wys nn
  // na 'n skikking van m nieNulInskrywings. Elkeen van hierdie inskywings
  // se x en kol velde is ondefinieerd, maar volg wys na die lys van
  // inskrywings van die betrokke ry.
  double *x;
  int m, *verwysings; // 'n m x (totaal/m) matriks
  // verwysings tel hoeveel matrikse daar is wat dieselfde data (nn of x)
  // gebruik.
  // Om tyd en geheue te spaar, word daar nie 'n kopie van die data gemaak
  // as een matriks aan 'n ander gelyk gestel word nie. Ons allokeer
  // eerder ekstra geheue waarin daar getel word hoeveel verwysings daar
  // na die spesifieke geheue posisie is, en as al die verwysings verdwyn,
  // deallokeer ons die geheue, soos Smalltalk. Wat eintlik nou kort is
  // kode wat die data dupliseer as dit verander word soos fork() op Linux.
  vektor (int _totaal)
  {
    totaal = _totaal;
    nn = NULL;
    x = new double[totaal];
    //cout << "n\n";
    m = _totaal;
    verwysings = new int;
    *verwysings = 1;
  }
  vektor (int _totaal, double *_x)
  {
    totaal = _totaal;
    nn = NULL;
    x = _x;
    m = totaal;
    verwysings = NULL;
  }
  vektor (int _totaal, nieNulLys _nn)
  {
    totaal = _totaal;
    nn = _nn;
    x = NULL;
    m = totaal;
    verwysings = NULL;
  }
  vektor (vektor &a)
  {
    totaal = a.totaal;
    nn = a.nn;
    x = a.x;
    m = a.m;
    verwysings = a.verwysings;
    if (verwysings) verwysings[0]++;
  }
  vektor ()
  {
    verwysings = NULL;
    totaal = 0;
  }
  void Vernietig ();
  ~vektor ()
  {
    Vernietig();
  }
  vektor operator=(vektor b)
  {
    //cout << "a\n";
    Vernietig ();
    totaal = b.totaal;
    nn = b.nn;
    x = b.x;
    m = b.m;
    verwysings = b.verwysings;
    if (verwysings) verwysings[0]++;
    return *this;
  }
  vektor operator+(vektor b)
  {
    assert (nn==NULL&&b.nn==NULL); // Nog nie geimplementeer nie.
    vektor antw (totaal);
    double *ax=x,*bx=b.x,*cx=antw.x;
    antw.m = m;
    for (int i=totaal;i>0;i--) *cx++ = *ax++ + *bx++;
    return antw;
  }
  vektor operator-(vektor b)
  {
    assert (nn==NULL&&b.nn==NULL); // Nog nie geimplementeer nie.
    vektor antw (totaal);
    double *ax=x,*bx=b.x,*cx=antw.x;
    antw.m = m;
    for (int i=totaal;i>0;i--) *cx++ = *ax++ - *bx++;
    return antw;
  }
  double& operator[](int i)
  {
    if (nn==NULL) return x[i];
    nieNulLys ry = nn;
    SoekKol (i, ry);
    return ry->x;
  }
};
inline vektor operator*(double a, vektor b)
{
  assert (b.nn==NULL); // Nog nie geimplementeer nie.
  vektor antw (b.totaal);
  double *bx = b.x, *cx = antw.x;
  antw.m = b.m;
  for (int i=b.totaal;i>0;i--) *cx++ = a * *bx++;
  return antw;
}

inline vektor NulVektor (int n)
{
  vektor antw (n);
  double *ptr = antw.x;
  for (int i=0;i<n;i++) *ptr++ = 0;
  return antw;
}

struct matriks:vektor {
  // Die nommering is 0 1 2 vir 'n 3x3 matriks.
  //                  3 4 5
  //                  6 7 8
  matriks (int _m, int _n) : vektor (_n * _m)
  {
    m = _m;
  }
  matriks (int _m, int _n, double *x) : vektor (_n * _m, x)
  {
    m = _m;
  }
  matriks (matriks &a) : vektor(a) // Shallow copy
  {
  }
  matriks () : vektor ()
  {
  }
  vektor operator[](int i)
  {
    if (!nn) return vektor (totaal/m, x + i*(totaal/m));
    else return vektor (totaal/m, nn + i);
  }
  matriks operator+(matriks b)
  {
    return *(matriks*)& ((vektor&) *this + (vektor &)b);
  }
  matriks operator-(matriks b)
  {
    return *(matriks*)& ((vektor&) *this - (vektor &)b);
  }
  matriks operator*(matriks b);
};
inline vektor operator*(matriks a, vektor b)
{
  return *(vektor*)& a.operator*(*(matriks*)&b);
}
inline matriks Transponeer (matriks a)
{
  assert(a.nn==NULL); // Nog nie geimplementeer nie.
  int n=a.totaal/a.m;
  matriks antw (n,a.m);
  double *ptr=antw.x;
  for (int i=0;i<n;i++) {
    for (int j=0;j<a.m;j++) {
      *ptr++ = a[j][i];
    }
  }
  return antw;
}
ostream& operator<<(ostream& str, vektor a);
matriks operator/(matriks b, matriks a);
inline vektor operator/(vektor b, matriks a)
{ // a.totaal=a.m*a.m en b.totaal=a.m
  return *(vektor*)& (*(matriks*)&b / a);
}
inline matriks operator*(double a, matriks b)
{
  return *(matriks*)& (a * (vektor)b);
}
inline ostream& operator<<(ostream& str, matriks a)
{
  for (int i=0;i<a.m;i++) str << a[i] << '\n';
  return str;
}
matriks Identiteit (int m);
matriks NulMatriks (int m, int n);
matriks YlMatriks (int m, int n);

#endif

