#ifndef MATHLIB_H
#define MATHLIB_H

/*----------------------[ Probability / Stats ]--------------------------*/
double LogNfactorial (double n);

double CumulativeBinomial (int n, int x, double pi);
/* If n independent experiments are done in which each experiment has */
/* probability pi to be successfull, this function returns the probability */
/* of having x or less successes. */

double NormalDensity (double x);
/* mu=0, sigma=1 */
double CumulativeNormalDistribution (double x);
/* Approximates the integral of -infty to x of NormalDensity */
double InverseNormal (double p);
/* InverseNormal (CumulativeNormalDistribution (x)) == x */

double ChiSquareDensity (double x, int freedom);
double CumulativeChiSquare (double x, int freedom);
/* Integral of 0 to x of ChiSquareDensity. Accuracy : 0.001=0.1% */
double InverseChiSquare (double p, int freedom);
/* InverseChiSquare(CumulativeChiSquare(x,f),f) == x. */
/* Less acurate if freedom is uneven */

double TDensity (double x, int freedom);
/* !!! freedom%2==1 !!! */
double CumulativeTDistribution (double x, int freedom);
/* Integral of -infty to x of TDensity. Accuracy : 0.001=0.1% */
double InverseTDistribution (double p, int freedom);
/* InverseCumulativeT (CumulativeT (x, v), v) == x. Less acurate if */
/* freedom is even */

/*-----------------------------[ Regression ]----------------------------*/
/* The assumption for linear regression is that for all x, y has */
/* a n(alpha + beta x, sigma^2) distribution, where alpha, beta and sigma */
/* are unknown. */
typedef struct {
  double sumx, sumy, sumxx, sumxy, sumyy;
  int n;
} regressor;
#define ClearRegressor(x) memset (x, 0, sizeof (regressor))

void AddToRegressor (regressor *c, double x, double y);

double RegressorB (regressor *c);
/* slope of best fit. */
double RegressorA (regressor *c);
/* y-intersect of best fit. */

double RegressorY (regressor *c, double x);
/* Returns the expected value of y */

double RegressorSyz2 (regressor *c); /* s_{y.x}^2 */
double RegressorD0 (regressor *c, double x);

double RegressorP (regressor *c, double x, double deltay);
/* Returns the probability that if you where to take a sample at x, */
/* that sample will be less than deltay+RegressorY(c, x) */

double RegressorYEstimate (regressor *c, double x, double p);
/* RegressorYEstimate (c, x, RegressorP (c, x, deltay)) == deltay i.e. */
/* P(-infy < y < RegressorY + RegressorYEstimate) = p */
/* P(RegressorY-RegressorYEstimate < y < RegressorY + RegressorYEstimate) */
/*   = 2p-1 */

/*-----------------------[ Linear Systems ]------------------------------*/
int  GaussEliminate (double *matrix, double *result, int n, int a);
/* the matrix consists of n arrays each containing n+a doubles. This */
/* function then tries to find x in the equation Ax = b, where A is the */
/* first n entries of the n arrays, b is the last a entries of the n */
/* arrays. If the function returns non-zero, x will be stored in result */
/* as n rows (with a entries each) */
/* matrix will be undefined. If the function returns non-zero, then no */
/* such x exsists, i.e. det(A)=0 etc. */

#endif

