#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>
#include "eElement.h"
#include "grafika.h"

#define LIN_OPERATORS 1

struct opdragte {
  double m;
  int bron, bestemming;
};

opdragte *FaktoriseerYlMatriks (matriks a)
{
  opdragte *o=NULL;
  int maksO=0, nO=0, i, j;
  nieNulInskrywing ry[a.m]; // Die "volg" veld wys na die ry.
    
  for (i=0;i<a.m;i++) { // Maak 'n kopie om mee te werk.
    ry[i].volg = NULL;
    ry[i].kol = -1;
    nieNulLys nuut = &ry[i], oud = a.nn[i].volg;
    while (oud) {
      SoekKol (oud->kol, nuut);
      nuut->x = oud->x;
      oud = oud->volg;
    }
  }
  double spil;
  nieNulLys itr, itr2, volgende;
  int spilKolomme[a.m], pry[a.m]; // Ons gaan die rye permuteer.
  for (i=0;i<a.m;i++) pry[i]=i;
  for (i=0;i<a.m;i++) {
    int kortste = a.m + 1, kortsteRy, tel, spilKol;
    for (j=i;j<a.m;j++) {
      tel = 0;
      itr = ry[j].volg;
      while (itr && tel < kortste) {
        tel++;
        itr = itr->volg;
      }
      if (tel < kortste) {
        kortsteRy = j;
        kortste = tel;
      }
    } // Soek kortste ry
    tel = pry[kortsteRy]; // Ruil rye om
    pry[kortsteRy] = pry[i];
    pry[i] = tel;
     
    itr = ry[kortsteRy].volg;
    ry[kortsteRy].volg = ry[i].volg;
    ry[i].volg = itr;
      
    spil = 0;
    for (itr=ry[i].volg;itr;itr=itr->volg) {
      if (fabs (itr->x) > fabs (spil)) {
        spil = itr->x;
        spilKol = itr->kol;
      }
    }
    spilKolomme[i] = spilKol; // Maak terug substitusie makliker
    assert (fabs (spil) > 1e-10); // Nie-inverteerbaar <=> det=0
    // Nou gaan ons kolom spilKol elimineer m.b.v. veelvoude van ry[i]
    for (j=i+1;j<a.m;j++) {
      itr2=&ry[j];
      for (volgende=itr2->volg;volgende && volgende->kol < spilKol;
      volgende=volgende->volg) { itr2=volgende;}
      if (volgende && volgende->kol==spilKol) {
      // As ry[j] se spilKol nie-nul is
        assert (itr2->volg == volgende);
        double M = volgende->x / spil;
        volgende = volgende->volg;
        delete itr2->volg; // Vernietig spilkol.
        itr2->volg = volgende;
          
        itr2 = &ry[j];
        for (itr=ry[i].volg;itr;itr=itr->volg) {
        // Vir elke nie-nul inskrywing in ry[i]
          if (itr->kol != spilKol) {
            SoekKol (itr->kol, itr2);
            itr2->x -= M * itr->x;
          }
        }
        if (nO >= maksO) {
          maksO+=a.m;
          o=(opdragte*)realloc(o,sizeof(*o)*maksO);
        }
        o[nO].m=M;
        o[nO].bron=pry[i];
        o[nO++].bestemming=pry[j];
      } // Vir elke ry wat 'n nie-nul inskrywing in spilKol het.
    }
  } // Elimineer elke kolom (waarskynlik kolom i)
  for (i=a.m-1;i>=0;i--) {
    assert(spilKolomme[i]==pry[i]); // Diagonaal dominant
    for (itr=ry[i].volg;itr;) {
      if (itr->kol == spilKolomme[i]) spil = itr->x;
      else {
        if (nO >= maksO) {
          maksO+=a.m;
          o=(opdragte*)realloc(o,sizeof(*o)*maksO);
        }
        o[nO].m=itr->x;
        o[nO].bron=itr->kol;
        o[nO++].bestemming=pry[i];
      }
      
      itr2=itr->volg;
      delete itr;
      itr=itr2;
    }
    if (nO >= maksO) {
      maksO+=a.m;
      o=(opdragte*)realloc(o,sizeof(*o)*maksO);
    }
    o[nO].m=1/spil;
    o[nO].bron=-1;
    o[nO++].bestemming=pry[i];
  } // Terug substitisie.
  if (nO >= maksO) {
    maksO+=a.m;
    o=(opdragte*)realloc(o,sizeof(*o)*maksO);
  }
  o[nO].bron=-1; // Merk die einde
  o[nO++].bestemming=-1;
  //cout << "Aantal ry berekings : "<<nO<<endl;
  return o;
}

double cKonstante=-0.0004;
verdeling2d v;
matriks L;
opdragte *mInverse;
vektor u, ou_u;
typedef double normaalTipe[3];
normaalTipe *normaal, *dhNormaal;
double *intens; // Lig intensiteit op elke node.
int teller=0;
time_t begin;
double bronX=2, bronY=0;
enum { platVlakke, gladdeVlakke } beligting = gladdeVlakke;
bools vries = vals;

void Knoppie(unsigned char k, int x, int y)
{
  if (k==0x1b) {
    cout << teller/(double)(time(NULL)-begin)<<" fps\n";
    exit(0);
  }
  else if (k==' ') {
  }
  else if (tolower(k)=='p') {
    vries = (bools)!vries;
  }
}

void Herstel (void)
{
  for (int i=0;i<v.nnodes;i++) {
    double d=sqrt(Kwadreer(v.node[i].x-bronX)+
      Kwadreer(v.node[i].y-bronY))/1.4;
    if (!v.node[i].nul && d<1) u[i] = ou_u[i] = 2*Kwadreer(1-d);
    else u[i]=ou_u[i]=0;
  }
}

void KryNormaal (int *dh, double *n)
{
  double b1=v.node[dh[1]].x - v.node[dh[0]].x;
  double b2=v.node[dh[1]].y - v.node[dh[0]].y;
  double b3=u.x[dh[1]] - u.x[dh[0]];
  double c1=v.node[dh[2]].x - v.node[dh[0]].x;
  double c2=v.node[dh[2]].y - v.node[dh[0]].y;
  double c3=u.x[dh[2]] - u.x[dh[0]];
  n[0]=b2*c3-b3*c2;
  n[1]=b3*c1-b1*c3;
  n[2]=b1*c2-b2*c1;
}

inline double KiesIntens (double *n)
{
  double c=0.7*Kwadreer(n[0]+n[2])/(2*(n[0]*n[0]+n[1]*n[1]+n[2]*n[2]));
  if (c<0) c=0;
  return c+0.3;
}

inline void glKleur (int dhnr, double i)
{
  glColor3d (i*v.dh[dhnr].kleur[0], i*v.dh[dhnr].kleur[1],
    i*v.dh[dhnr].kleur[2]);
}

void Wys (void)
{
  teller++;
  //glutKeyboardFunc (Knoppie);
  double oogVektor[3];
  
  double c=cos((240 - glMouseY)*(M_PI/180));
  oogVektor[2]=-oogAfstand*sin((240 - glMouseY)*(M_PI/180));
  oogVektor[0]=oogAfstand*c*sin((320 - glMouseX)*(M_PI/180));
  oogVektor[1]=oogAfstand*c*cos((320 - glMouseX)*(M_PI/180));      

  #if 1
  struct timezone tz;
  timeval now;
  static timeval ltime;
  gettimeofday(&now,&tz); // Limit frame rate to 25 fps
  int dif=40000-(now.tv_sec-ltime.tv_sec)*1000000-now.tv_usec+ltime.tv_usec;
  if (dif > 0 && dif <=40000) usleep(dif);
  ltime=now;

  #else // Keep eye fixed, stop after 300 frames for benchmarking
  if (teller > 300) Knoppie(0x1b,0,0);
  glPopMatrix();
  glPushMatrix();
  glRotatef(45,1,0,0);
  oogVektor[0]=0; oogVektor[1]=0; oogVektor[2]=-oogAfstand;
  #endif

  //glDisable(GL_LIGHTING);
  //glEnable (GL_NORMALIZE);
  glBegin (GL_TRIANGLES);
  //static GLfloat blou[4] = {0.2, 0.2, 1.0, 1.0};
  //glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, blou);
  //glMaterialfv(GL_FRONT, GL_SPECULAR, blou);
  for (int i=0;i<v.ndriehoeke;i++) KryNormaal(v.dh[i].i, dhNormaal[i]);
  if (beligting == gladdeVlakke) {
    for (int i=0;i<v.nnodes;i++) normaal[i][0]=normaal[i][1]=normaal[i][2]=0;
    for (int i=0;i<v.ndriehoeke;i++) {
    // OpenGL / Mesa gebruik normale op die materiaal vir beligting.
    // As ons die interpolant korrek wil inkleur, is die normaal konstant.
    // Hier kul ons bietjie die oog deur by elke punt 'n ander normaal te
    // gebruik. Die normaal by punt i word bereken as die gemiddeld van die
    // normale van elk van die aangrendende elemente.
      for (int j=0;j<3;j++) {
        normaal[v.dh[i].i[j]][0]+=dhNormaal[i][0];
        normaal[v.dh[i].i[j]][1]+=dhNormaal[i][1];
        normaal[v.dh[i].i[j]][2]+=dhNormaal[i][2];
      }
    }
  } // As gladde beligting gebruik word
  for (int i=0;i<v.nnodes;i++) intens[i] = KiesIntens (normaal[i]);
  for (int i=0;i<v.ndriehoeke;i++) {
    //if (beligting == platVlakke) glNormal3dv (KryNormaal (v.dh[i]));
    int bokant=dhNormaal[i][0]*(oogVektor[0]+3.5-v.node[v.dh[i].i[0]].x)+
               dhNormaal[i][1]*(oogVektor[1]+3.5-v.node[v.dh[i].i[0]].y)+
               dhNormaal[i][2]*(oogVektor[2]-u.x[v.dh[i].i[0]]) >= 0;
    if (!bokant) glKleur (i, 0.3);
    if (beligting==platVlakke && bokant) {
      glKleur (i, KiesIntens (dhNormaal[i]));
    }
    for (int j=0;j<3;j++) {
      int node=v.dh[i].i[j];
      if (beligting == gladdeVlakke&&bokant) glKleur (i, intens[node]);
      glVertex3d (v.node[node].x-3.5, v.node[node].y-3.5, u.x[node]);
    }
  }
  glEnd();
}

void Volgende (void)
{
  #ifndef LIN_OPERATORS
    vektor nuut = L*u - ou_u;
  #else
    vektor nuut = L*u; // L is v.K wat verklein is.
    opdragte *o; // Deel nou deur v.M
    for (o = mInverse;;o++) {
      if (o->bron>-1) nuut.x[o->bestemming] -= o->m * nuut.x[o->bron];
      else if(o->bestemming==-1) break;
      else nuut.x[o->bestemming] *= o->m;
    }
    for (int i=0;i<nuut.totaal;i++) {
      nuut.x[i]=2*u.x[i]-ou_u.x[i]+cKonstante*nuut.x[i];
    }
  #endif
  ou_u = u;
  u = nuut;
}

void HanteerMerkers (char *merk, double x, double y, verdeling2d &v)
{
  if (merk[0] != '#') {
    fprintf (stderr, "Warning : Unknown marker in fig file: %s\n", merk);
  }
  else if (merk[1] == 'G') { bronX = x; bronY = y; }
}

int main (int argc, char *argv[])
{
  bools rant=vals;
  int i, f=100;
  for (i=1;i<argc;i++) {
    if (strncmp(argv[i],"-r",2)==0) rant=waar;
    if (strncmp(argv[i],"-p",2)==0) beligting=platVlakke;
    if (strncmp(argv[i],"-c=",3)==0) cKonstante=-atof(argv[i]+3);
    if (strncmp(argv[i],"-f=",3)==0) f=atoi(argv[i]+3);
    if (strncmp(argv[i],"-h",2)==0) argc=1;
  }
  if (argc <= 1 || argv[1][0]=='-') {
    cerr<<"Usage : "<<argv[0]<<" [ myRegion.fig ] [-r[and]]"
    " [-p[lat]] [-f=NNN] [-c=0.00xx] [-h[elp]] [-geometry WxH]\n"
    "        [-offscreen X,Y,F] [-crop]\n"
    "There should be some nice regions in /usr/lib/glpossion\n"
    "See /usr/doc/glpoisson-1.00/glpoisson.tex for the keys\n"
    "Default values : c="<<cKonstante<<" f="<<f<<"\n";
    return 2;
  }
  LeesFig (argv[1], v, rant, HanteerMerkers);
  // As ons met die leer werk.

  v = Verfyning (v, f);
  dhNormaal = new normaalTipe[v.ndriehoeke];
  normaal = new normaalTipe[v.nnodes];
  intens = new double[v.nnodes];
  EindigeElementPoisson (v);
  MaakInverteerbaar (v.M, v);
  #ifdef LIN_OPERATORS
    L=YlMatriks(v.nnodes,v.nnodes);
    for (i=0;i<v.nnodes;i++) {
      if (!v.node[i].nul) {
        for (nieNulLys l=v.K.nn[i].volg;l;l=l->volg) {
          if (!v.node[l->kol].nul) {
            L[i][l->kol] = l->x;
          }
        }
      }
    }
    mInverse = FaktoriseerYlMatriks (v.M);
  #else
    L = cKonstante*(v.K/v.M) + 2*Identiteit(v.nnodes);
  #endif
  
  u = vektor (v.nnodes);
  ou_u = vektor (v.nnodes);
  begin = time(NULL);
  DoenGrafika (&argc, argv, Wys, Herstel, Volgende, GL_FALSE);
}

