#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <g++/stl_algobase.h>
#include "eElement.h"

#ifdef __linux__
#include "grafika.h"
#include "vectors.h"
bools wysVerdeling=vals;
void EkstraKnoppie (unsigned char k)
{
  if (k=='w') wysVerdeling=(bools)!wysVerdeling;
}
vector *driehoek; // Point 1, point 2, point 3, normal
int npunte;
double minx, miny, minz, maxx, maxy, maxz;
void Wys (void)
{
  GrafikaKeyboardFunc (EkstraKnoppie);
  //glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glEnable(GL_LIGHTING);
  glBegin (GL_TRIANGLES);
  static GLfloat blou[4] = {0.2, 0.2, 1.0, 1.0};
  glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, blou);
  for (int i=0;i<npunte;i+=4) {
    glNormal3dv (driehoek[i+3].x);
    for (int j=0;j<3;j++) gl (driehoek[i+j]);
  }
  glEnd ();
  glFinish();
  if (wysVerdeling) {
    //static GLfloat geel[4] = {1.0, 1.0, 0.2, 1.0};
    //glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, geel);
    glDisable(GL_LIGHTING);
    glColor3d (1.0, 1.0, 0.2);
    glBegin (GL_LINES);
    for (int i=0;i<npunte;i+=4) {
      for (int j=0;j<3;j++) {
        glVertex3d (driehoek[i+j].x[0],driehoek[i+j].x[1],
          (-minz-maxz-0.02)/2);
        glVertex3d (driehoek[i+(j+1)%3].x[0],driehoek[i+(j+1)%3].x[1],
          (-minz-maxz-0.02)/2);
      }
    }
    glEnd ();
    #if 1 // Bypass bug in Mesa driver for 3dfx
    glEnable (GL_LIGHTING);
    glColor3d(0,1,0);
    glBegin(GL_TRIANGLES);
    glVertex3d(0,0,0);
    glVertex3d(0,0,0.01);
    glVertex3d(0,0.01,0);
    glEnd();
    #endif
  }
  glFinish();
}
#endif

char *eksakteOplossing=NULL;
void HanteerMerker(char *merk,double /*x*/,double /*y*/, verdeling2d &v)
{
  if ((strncmp(merk,"Exact",5)==0||strncmp(merk,"Eksak",5)==0)&&
  strchr(merk,'=')!=0) eksakteOplossing=strdup(strchr(merk,'=')+1);
}

void main (int argc, char *argv[])
{
  if (argc <= 1 || argv[1][0]=='-') {
    printf("Usage : %s myFigFile.fig [-f=N] [-r[d]]\n\n"
    "N is the amount of extra nodes to add.\n"
    "-r is a special option to test the finite element method\n"
    "During the display you can press w to show the elements and ESC to"
    " quit\n\nThere should be some nice fig files in /usr/lib/glpossion\n",
    argv[0]);

    exit(2);
  }

  double a = 3, b = 2, dx = a / 3, dy = b / 2;
  int verfyn=100, nx, ny;
  bools reghoekig=vals, driehoekElemente=vals;
  for (int i=2;i<argc;i++) {
    if (strncmp(argv[i],"-r",2)==0) {
      reghoekig = waar;
      driehoekElemente = (bools)(argv[i][2]=='d');
    }
    if (strncmp(argv[i],"-f=",3)==0) verfyn=atoi(argv[i]+3);
  }
  char *krag = argv[1][0]=='1' ? "1" : "-2*x(x-3)-2*y(y-2)";
  node2dTipe nodeLys[]={
  {   dx,   dy, waar }, // In C/C++ word daar altyd van 0 af genommer :-(
  { 2*dx,   dy, waar }, // Hierdie spesifiseer die nodes vir ...
  {   dx,    0, waar },
  { 2*dx,    0, waar }, //              FIGUUR 3
  {   dx, 2*dy, waar },
  { 2*dx, 2*dy, waar },
  {    0,    0, waar }, // 6 (was 7).
  {    0,   dy, waar },
  {    0, 2*dy, waar },
  { 3*dx,    0, waar },
  { 3*dx,   dy, waar },
  { 3*dx, 2*dy, waar },
  };
  element2d dhLys[]={
  {  2,  0,  6, -1,0, krag, 0,0,0 }, // Lokale punt 1, lokale p 2, lokale p 3
  {  3,  1,  2, -1,0, krag, 0,0,0 }, // As punt 1,2,3 van elke driehoek in 'n
  {  9, 10,  3, -1,0, krag, 0,0,0 }, // antikloksgewyse rigting voorkom, is
  {  7,  6,  0, -1,0, krag, 0,0,0 }, // die beligting makliker.
  {  0,  2,  1, -1,0, krag, 0,0,0 },
  {  1,  3, 10, -1,0, krag, 0,0,0 },
  {  0,  4,  7, -1,0, krag, 0,0,0 },
  {  1,  5,  0, -1,0, krag, 0,0,0 },
  { 10, 11,  1, -1,0, krag, 0,0,0 },
  {  8,  7,  4, -1,0, krag, 0,0,0 },
  {  4,  0,  5, -1,0, krag, 0,0,0 },
  {  5,  1, 11, -1,0, krag, 0,0,0 }
  };
  rand2d rLys[]={
  { 0,0,0,b, b*b, 0,1, "0" }, // x=0
  { a,0,0,b, b*b, 0,1, "0" }, // x=a
  { 0,0,a,0, a*a, 0,1, "0" }, // y=0
  { 0,b,a,0, a*a, 0,1, "0" }  // y=b
  };

  verdeling2d v = { sizeof(nodeLys)/sizeof(nodeLys[0]),
    sizeof(dhLys)/sizeof(dhLys[0]), argv[1][0]=='1' ? 2 : 4,
    nodeLys, dhLys, rLys, matriks(), matriks(), vektor()
  };

  if (strcmp(argv[1],"1")==0||strcmp(argv[1],"2")==0) {
    if(argv[1][0]=='1') eksakteOplossing="x*1.5-x^2/2";
    if(argv[1][0]=='2') eksakteOplossing="x(x-3)*y(y-2)";
  }
  else LeesFig (argv[1], v, vals, HanteerMerker);

  if (reghoekig) {
    cout << "Aantal elemente langs x-as : ";
    cin >> nx;
    cout << "Aantal elemente langs y-as : ";
    cin >> ny;
    dx=a/nx;
    dy=b/ny;
    v.nnodes = (nx+1)*(ny+1);
    v.node = new node2dTipe[v.nnodes];
    node2dTipe *nptr=v.node;
    for (int i=0;i<=nx;i++) {
      for (int j=0;j<=ny;j++) {
        nptr->x = dx*i;
        nptr->y = dy*j;
        nptr++;
      }
    }
    v.ndriehoeke=0; // EEPoisson doen net die gedwonge randvoorwaardes vir -r
    if (driehoekElemente) { // As -rd
      element2d ouElement=v.dh[0];
      v.dh=(element2d *)malloc(nx*ny*2*sizeof(v.dh[0]));
      for (int i=0;i<nx;i++) {
        for (int j=0;j<ny;j++,v.ndriehoeke+=2) { // vir element 2*(i*ny+j)
          //memcpy(v.dh+v.ndriehoeke,&ouElement,sizeof(v.dh[v.ndriehoeke]));
          v.dh[v.ndriehoeke]= ouElement;
          v.dh[v.ndriehoeke].i[0]=i*(ny+1)+j;
          v.dh[v.ndriehoeke].i[1]=(i+1)*(ny+1)+j;
          v.dh[v.ndriehoeke].i[2]=i*(ny+1)+(j+1);

          v.dh[v.ndriehoeke+1]=v.dh[v.ndriehoeke];
          v.dh[v.ndriehoeke+1].i[0]=i*(ny+1)+(j+1);
          v.dh[v.ndriehoeke+1].i[2]=(i+1)*(ny+1)+(j+1);
        }
      }
    }
  }
  else { // Driehoekige elemente
    v = Verfyning (v, verfyn);
  }

  EindigeElementPoisson (v);

  if (reghoekig && !driehoekElemente) {
    double d=2*(dy/dx+dx/dy)/6, s1=(-2*dy/dx+dx/dy)/6, s2=(dy/dx-2*dx/dy)/6;
    double mFaktor=dx*dy/36;
    for(int i=0;i<nx;i++) { // Die elemente is so reelmatig dat hulle nie
      for (int j=0;j<ny;j++) { // gestoor hoef te word nie.
        // Vir elke element.
        for (int k=0;k<2;k++) {
          for (int l=0;l<2;l++) {
            int nod=(i+k)*(ny+1)+(j+l);
            if (!v.node[nod].nul) {
              v.M[nod][nod] += 4*mFaktor;
              v.M[nod][(i+(1-k))*(ny+1)+(j+l)] += 2*mFaktor;
              v.M[nod][(i+k)*(ny+1)+(j+(1-l))] += 2*mFaktor;
              v.M[nod][(i+(1-k))*(ny+1)+(j+(1-l))] += mFaktor;

              v.K[nod][nod] += d;
              v.K[nod][(i+(1-k))*(ny+1)+(j+l)] += s1;
              v.K[nod][(i+k)*(ny+1)+(j+(1-l))] += s2;
              v.K[nod][(i+(1-k))*(ny+1)+(j+(1-l))] += s1+s2;
            } // As die punt nie op 'n gedwonge rand is nie.
            // Nie-0 natuurlike randvoorwaardes word nie hier ondersteun nie
          } // Vir elke hoekpunt van die element.
        }
      } // Vir elke element
    }
    if (v.rand[3].gradKoef!=0) { // Probleem 3.6.4. Eintlik 'n hack
      for (int i=0;i<nx;i++) { // Vir elke stukkie van rand[3].
        int nod=i*(ny+1)+ny, nod1=nod+(ny+1);
        double a = EvalXY (v.rand[3].waarde,v.node[nod].x,v.node[nod].y);
        double b = EvalXY (v.rand[3].waarde,v.node[nod1].x,v.node[nod1].y);
        double l = dx, beta=-1/v.rand[3].gradKoef,bKoef=v.rand[3].uKoef*beta;
        if (!v.node[nod].nul) {
          v.F[nod] -= beta*(2*a+b)*l/6;
          v.K[nod][nod1] -= l/6*bKoef;
          v.K[nod][nod] -= l/3*bKoef;
        }
        if (!v.node[nod1].nul) {
          v.F[nod1] -= beta*(a + 2*b)*l/6;
          v.K[nod1][nod1] -= l/3*bKoef;
          v.K[nod1][nod] -= l/6*bKoef;
        }
      }
    }

    vektor f(v.nnodes);
    for (int i=0;i<v.nnodes;i++) {
      f[i] = EvalXY (v.dh[0].krag, v.node[i].x, v.node[i].y);
    }

    v.F = v.F + v.M*f;
  } // As die elemente reghoekig is.

  //cout << "\nF="<<v.F<<"\nK = \n" << v.K<< "M = \n" << v.M;
  vektor u = v.F / v.K;
  if (eksakteOplossing) {
    cout << setprecision(3) << "Benaderd : "<<u<< "\nEksak    :  ";
    double somKwadraat = 0;
    for (int i=0;i<v.nnodes;i++) {
      double r = EvalXY (eksakteOplossing, v.node[i].x, v.node[i].y);
      cout << " " << r;
      somKwadraat += Kwadreer (r - u[i]);
    }
    cout << "\n\nStandard deviation : "<<sqrt(somKwadraat/v.nnodes)<<"\n\n";
  }
  #ifdef __linux__
  driehoek = new vector[v.ndriehoeke*4];
  minx=v.node[0].x; miny=v.node[0].y; minz=u[0];
  maxx=minx; maxy=miny; maxz=minz;
  for (int i=1;i<v.nnodes;i++) {
    minx=min(minx,v.node[i].x);
    miny=min(miny,v.node[i].y);
    minz=min(minz,u[i]);
    maxx=max(maxx,v.node[i].x);
    maxy=max(maxy,v.node[i].y);
    maxz=max(maxz,u[i]);
  }
  vector c((minx+maxx)/2, (miny+maxy)/2, (minz+maxz)/2);
  for (npunte=0;npunte<v.ndriehoeke*4;npunte+=4) {
    for (int j=0;j<3;j++) {
      driehoek[npunte+j] = vector (v.node[v.dh[npunte/4].i[j]].x,
        v.node[v.dh[npunte/4].i[j]].y, u[v.dh[npunte/4].i[j]]) - c;
    }
    driehoek[npunte+3] = normalize (
      (driehoek[npunte+0]-driehoek[npunte+2])*
      (driehoek[npunte+1]-driehoek[npunte+2]));
  }
  DoenGrafika (&argc, argv, Wys);
  #endif
}

