#include <math.h> /* fabs */
#include <stdio.h>
#include <stdlib.h>

#include "gauselim.h"

int  GaussEliminate (double *mat, double *result, int n, int a)
{
#ifdef __BORLANDC__
  double best, tmp, **nrow, *ptr;
  int i, j, k, m = n + a, p, p2, *ncol;
  nrow = malloc (n * sizeof (*nrow));
  ncol = malloc (m * sizeof (*ncol));
#else
  double best, tmp, *nrow[n], *ptr;
  int i, j, k, m = n + a, p, p2, ncol[m];
#endif

  for (i = 0; i < n; i++) nrow[i] = mat + i * m;
  for (i = 0; i < m; i++) ncol[i] = i;
  for (i = 0; i < n; i++) {
    best = 0;
    for (j = i; j < n; j++) {
      for (k = i; k < n; k++) {
        tmp = fabs (nrow[j][ncol[k]]);
        if (tmp > best) {
          best = tmp;
          p = j;
          p2 = k;
        }
      }
    }
    if (best <= 1e-10) return 0;
    /*printf ("%le\n",best);*/
    ptr = nrow[i]; /* Virtual swap of rows */
    nrow[i] = nrow[p];
    nrow[p] = ptr;
    
    k = ncol[i]; /* Virtual swap of columns */
    ncol[i] = ncol[p2];
    ncol[p2] = k;
    
    for (j = i + 1; j < n; j++) {
      tmp = nrow[j][ncol[i]] / nrow[i][ncol[i]];
      if (tmp != 0) { /* Verdubbel die spoed in sommige gevalle */
        for (k = i + 1; k < m; k++) {
          nrow[j][ncol[k]] -= tmp * nrow[i][ncol[k]];
        }
      }
    }
    /*for (j=0;j<n;j++) {
      for (k=0;k<m;k++) printf ("%lf ",mat[j*m+k]);
      printf("\n");
    }
    printf ("\n"); */
  }
  for (i = n - 1; i >= 0; i--) {
    for (j = n; j < m; j++) {
      for (k = n - 1; k > i; k--) {
        nrow[i][j] -= nrow[i][ncol[k]] * nrow[k][j];
      } /* ncol is the identity function for j >=n */
      nrow[i][j] /= nrow[i][ncol[i]];
    }
  }
  for (j = 0; j < n; j++) {
    ptr = result + ncol[j]*a;
    for (i = n; i < m; i++) {
      *ptr++ = nrow[j][i];
    }
  }
  return 1;
}

