#include <math.h>
#include <ctype.h>
#include <stdlib.h>
#include "matriks.h"
#include "eElement.h"

int AantalTerme (int akkuraat, double l)
{
  double maksimumFout = M_PI * M_PI / 8; // zeta funksie
  double verlangdeFout = pow (10, -akkuraat) * M_PI * M_PI / 960 / l / l;
  int maksK;
  for (maksK=1;maksimumFout > verlangdeFout; maksK++) {
    maksimumFout -= 1.0 / (2*maksK-1) / (2*maksK-1);
  }
  return maksK;
}

void main (void)
{
  bools vb2; // Doen voorbeeld 2
  int akkuraat = 2; // Bepaal hoeveel terme van die reeks gebruik word.
  int elemente = 32, tydstappe = 320;
  double t = 1, l = 1, c = 2;
  int maksK = AantalTerme (akkuraat, l), i;
  char lyn[80];

  do {
    cout << setprecision (3) << "\n\n\n\n1. Bereken oplossing van vraag 1\n"
    "2. Bereken oplossing van vraag 2\n"
    "a. Akkuraatheid ("<<akkuraat<<" desimale)\n"
    "c. c = "<<c<<"\n"
    "e. Aantal elemente ("<<elemente<<")\n"
    "l. Lengte van staaf ("<<l<<")\n"
    "n. Aantal terme waarmee eksakte oplossing benader word("<<maksK<<")\n"
    "s. Tyd Stappe ("<<tydstappe<<")\n"
    "t. Tyd ("<<t<<")\n"
    "x. Stop\n"
    "\n"
    "Tik die letter van die opsie, (gevolg deur sy nuwe waarde,\n"
    "indien van toepassing). Huidige waardes word in hakkies aangedui\n\n";
    cin.getline (lyn, sizeof (lyn));
    switch (tolower (lyn[0])) {
    case 'a':
      akkuraat = atoi (lyn + 1);
      maksK = AantalTerme (akkuraat, l);
      break;
    case 'c':c = atof (lyn + 1);         break;
    case 'e':elemente = atoi (lyn + 1);  break;
    case 'l':l = atof (lyn + 1);         break;
    case 'n':maksK = atoi (lyn + 1);     break;
    case 's':tydstappe = atoi (lyn + 1); break;
    case 't':t = atof (lyn + 1);         break;
    case '1':
    case '2':
      vb2 = bools (lyn[0] == '2');
  
      vektor u (elemente + 1); // Kry beta as 'n vektor.
      for (i=0;i<=elemente;i++) {
        double x = l / elemente * i;
        if (vb2) u[i] = 10;
        else u[i] = x <= 0.25 ? 40*x : x <= 0.5 ? 20-40*x : 0;
      }
    
      if (t > 0) { // Voorkom 1/0
        matriks halfcK = c / 2 * EindigeElementK1D (l,elemente, 0,waar,vb2);
        matriks MopDeltat = tydstappe / t * EindigeElementM1D (l, elemente,
          waar, vb2);
        matriks L = (MopDeltat - halfcK) / (MopDeltat + halfcK);
        for (i = 0; i < tydstappe; i++) u = L * u;
        // Wat van "squaring and halfing" om hierdie lus vinniger te maak ?
      }
      cout << setprecision (akkuraat) << setiosflags (ios::fixed);
      cout << u << endl;
  
      double somKwadrate = 0;
      for (i=0;i<=elemente;i++) {
        double x = l / elemente * i, temp = 0;
        for (int k = 1; k <= maksK; k++) {
          if (vb2) {
            double omega = k * M_PI / l;
            if (k % 2 == 1) {
              temp += 40 / k / M_PI *
                exp (-c * omega * omega *t) * sin (omega * x);
            }
          }
          else {
            double omega = (2*k-1) * M_PI / 2 / l, omega2 = omega * omega;
            temp += (2 * sin (omega / 4) - sin (omega / 2)) * 80 / omega2
              * exp (-c * omega2 * t) * sin (omega * x);
          }
        }
        cout << temp << " ";
        somKwadrate += (temp - u[i]) * (temp - u[i]);
      }
      cout << endl << "Standaard afwyking : ";
      cout << setprecision (10) << sqrt (somKwadrate/(elemente-1)) << endl;
      cout << "Tik ENTER om voort te gaan";
      cin.get();
      break;
    } // Kies opsie
  } while (tolower (lyn[0]) != 'x');
  
  #if 0 // Hoofstuk 8 tabel 1
  int i, n = 3;
  double l = 1.5, c = 2, deltax = l / n, deltat = 0.05, x;
  matriks Dinv = Identiteit (n + 1);
  Dinv[n][n] = 2;
  //matriks K = EindigeElementK1D (l, n, 0, waar, vals);
  matriks L = Identiteit (n + 1) - c * deltat / deltax *
    Dinv * EindigeElementK1D (l, n, 0, waar, vals);
  vektor u (n + 1);
  for (i = 0, x = 0; i <= n; i++, x += deltax) {
    u[i] = 10 * sin (M_PI * x / 3);
    cout << 10 * exp (-2*M_PI*M_PI/9*0.1) * sin (M_PI * x / 3) << " ";
  }
  cout << "\n" << L * (L * u) << "\n";
  #endif
  
  #if 0 // Hoofstuk 8 p 8
  cout << setprecision(2) << setiosflags(ios::fixed);
  int elemente = 3;
  double c = 2, l = 1.5;
  for (int tydstappe = 2; tydstappe <= 4; tydstappe += 2) {
    vektor u (elemente + 1);
    for (int i = 0; i <= elemente; i++) {
      double x = l / elemente * i;
      u[i] = 10 * sin (M_PI * x / 3) + 10 * sin (5 * M_PI * x / 3);
    }
    
    matriks halfcK = c / 2 * EindigeElementK1D (l, elemente, 0, waar, vals);
    matriks MopDeltat = tydstappe / 0.2 * EindigeElementM1D (l, elemente,
      waar, vals);
    matriks L = (MopDeltat - halfcK) / (MopDeltat + halfcK);
    for (int i = 0; i < tydstappe; i++) u = L * u;
    cout << tydstappe << " tydstappe : " << u << "\n";
  }
  #endif
}

