#include <stdio.h>
#include <string.h>
#include <math.h>
#include "gauselim.h"
#include "mathlib.h"

#define n 5

double f[n+1], F[n+1], M[n+1][n+1], K[n+1][n+1], u[n+1], q, l, h;

void show(double m[n+1][n+1])
{
  int i,j;
  for (i=0;i<n+1;i++) {
    for (j=0;j<n+1;j++) {
      printf ("%8.3lf", m[i][j]);
    }
    printf ("\n");
  }
}

void mk(int left, int right)
{
  int i,j;
  double temp[(n+1)*(n+2)];
  
  h=l/n;
  for(i=0;i<n+1;i++) {
    for (j=0;j<n+1;j++) M[i][j]=K[i][j]=0;
    
    M[i][i]= i==0 || i==n ? h/3 : h*2.0/3;
    if (i>0) M[i][i-1]=h/6;
    if (i<n) M[i][i+1]=h/6;
    
    K[i][i]= i==0 || i==n ? 1/h+q*h/3 : 2/h+2*q*h/3;
    if (i>0) K[i][i-1]=-1/h+q*h/6;
    if (i<n) K[i][i+1]=-1/h+q*h/6;
  }
  if (!left)  K[0][1]=K[1][0]=0;
  if (!right) K[n][n-1]=K[n-1][n]=0;
  
  printf ("M=\n");
  show(M);
  printf ("K=\n");
  show(K);
  printf ("x        f        F\n");
  for (i=0;i<n+1;i++) {
    F[i]=0;
    if ((i!=0 || left) && (i!=n || right)) {
      for (j=0;j<n+1;j++) F[i]+=M[i][j]*f[j];
    }
    printf ("%8.3lf %8.3lf %8.3lf\n", i*l/n, f[i], F[i]);
  }
  for (i=0;i<n+1;i++) {
    memcpy(temp+i*(n+2),K[i], sizeof (K[i]));
    temp[i*(n+2)+n+1]=F[i];
  }
  GaussEliminate (temp, u, n+1, 1);
  printf ("u=\n");
  for (i=0;i<n+1;i++) printf ("%8.3lf", u[i]);
  printf ("\n");
}

void main (void)
{
  int i;
  double x;
  double A=(exp(-3)-1)/(exp(3)+exp(-3)), B=-A-1, A2=-5/(exp(2)+exp(-2));
  
  printf ("1.4.1 - Voorbeeld 1\n");
  l=3;
  q=1;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=1;
  mk(0,1);
  
  printf ("1.3.3 - Voorbeeld 2\n");
  l=3;
  q=1;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=x;
  mk(1,1);
  
  printf ("1.1.1\n");
  q=0;
  l=3;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=1;
  mk(0,1);
  
  printf ("1.1.2\n");
  q=0;
  l=3;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=2*x;
  mk(0,1);

  printf ("1.2.3\n");
  q=0;
  l=3;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=2*x;
  mk(0,1);

  printf ("1.4.3\n");
  q=1;
  l=3;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=1;
  mk(0,0);
  for (i=0,x=0;i<n+1;i++,x+=l/n) printf ("%8.3lf", A*exp(x)+B*exp(-x)+1);
  printf ("\n");

  printf ("1.4.4\n");
  q=4;
  l=1;
  for (i=0,x=0;i<n+1;i++,x+=l/n) f[i]=8*x*x*x;
  mk(1,0);
  for (i=0,x=0;i<n+1;i++,x+=l/n) printf ("%8.3lf",
    -0.6915*exp(2*x)+0.8085*exp(-2*x)+2*x*x*x+3*x);
  printf ("\n");
}

