#include <math.h>
#include "gauselim.h"

void CrankNicholson (int nx, int nt)
{
  double l=M_PI*2,c=-4;
  double u[nx],A[nx*(nx+1)],dx=l/(nx-1),dt=1.0/nt,t=0,m;
  int i,j,k;
  for (j=0;j<nx;j++) u[j]=sin(dx*j);
  for (i=0;i<nt;i++) {
    for (j=0;j<nx*(nx+1);j++) A[j]=0;
    A[0]=1;
    A[(nx-1)*(nx+1)+nx-1]=1;
    
    A[nx]=0;
    A[(nx-1)*(nx+1)+nx]=0;
    m=-c*dt/dx/dx/2.0;
    for (j=1;j<nx-1;j++) {
      A[j-1+j*(nx+1)]=-m;
      A[j+  j*(nx+1)]=1+2*m;
      A[j+1+j*(nx+1)]=-m;
      A[nx+ j*(nx+1)]=u[j]+m*(u[j-1]-2*u[j]+u[j+1]);
    }
    if (!GaussEliminate (A, u, nx, 1)) {
      printf("Error\n");
      return;
    }
    t+=dt;
  }
  m=0;
  for (j=0;j<nx;j++) {
    //printf("u(%lf,%lf)=%lf fout=%le\n",dx*j,t,u[j],
    m+=(exp(c*t)*sin(dx*j)-u[j])*(exp(c*t)*sin(dx*j)-u[j]);
  }
  printf("%lf %le\n",-c*dt/dx/dx/2.0, sqrt(m/(nx-1)));
}

void main(void)
{
  int nx,nt;
  
  printf ("Aantal x intervalle ?");
  scanf ("%d", &nx);
  printf ("Aantal iterasies ?");
  scanf ("%d", &nt);
  
  CrankNicholson(nx,nt);
}

