#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <g++/stl_algobase.h>
#include <limits.h>
#include <GL/osmesa.h>
#include "matriks.h"
#include "eElement.h"
#include "grafika.h"

int Breek(const char *formaat, ...)
{
  va_list lst;
  va_start (lst, formaat);
  vfprintf(stderr, formaat, lst);
  va_end (lst);
  exit(1);
}

void SoekKol (int kol, nieNulLys &itr)
{ // Gaan na 'n spesifieke kolom in die lys (ry), en skep hom as hy nul was.
// Itr moet aanvanklik na 'n posisie voor kol in die ry (lys) wys.
// Na die tyd wys itr na kol.
  while (itr->volg != NULL && itr->volg->kol <= kol) itr = itr->volg;
  if (itr->kol != kol) { // Nou is itr->kol < kol < itr->kol
    nieNulLys nuut = new nieNulInskrywing;
    nuut->x = 0;
    nuut->kol = kol;
    nuut->volg = itr->volg;
    itr->volg = nuut;
    itr = nuut;
  }
}

void vektor::Vernietig ()
{
  if (verwysings && --verwysings[0] == 0) {
    if (!nn) delete x;
    else {
      for (int i=0;i<m;i++) {
        nieNulLys itr = nn[i].volg;
        while (itr) {
          nieNulLys temp = itr->volg;
          delete itr;
          itr = temp;
        }
      }
      delete nn;
    }
    delete verwysings;
    //cout << "d\n";
  }
}

matriks matriks::operator*(matriks b)
{
  int breedte = b.totaal / b.m;
  matriks antw (m, breedte);
  for (int i=0;i<m;i++) { // Vir elke ry van antw
    for (int k = 0; k < breedte; k++) { // Vir elke kolom van antw
      double r = 0;
      if (!nn) {
        double *aptr = x + i * totaal / m, *bptr = b.x + k;
        for (int j=0;j<totaal;j+=m) { // Punt produk
          r+=*bptr * *aptr++;
          bptr += breedte;
        }
      }
      else {
        nieNulLys itr = nn[i].volg;
        while (itr) {
          r += itr->x * b.x[k + itr->kol*breedte];
          itr = itr->volg;
        }
      }
      antw.x[i * breedte + k] = r;
    } // Vir elke kolom
  } // Vir elke ry
  return antw;
}

matriks operator/(matriks b, matriks a)
{
  int breedte = b.totaal / b.m, i, j;
  matriks antw (a.m, breedte);
  if (!a.nn) {
    double *temp = new double[a.m*(a.m+breedte)];
    for (i=0;i<a.m;i++) {
      memcpy (temp+i*(a.m+breedte),a.x+i*a.m,sizeof(a.x[0])*a.m);
      memcpy (temp+i*(a.m+breedte)+a.m,b.x+i*breedte,
        sizeof (a.x[0])*breedte);
    }
    if (!GaussEliminate (temp, antw.x, a.m, breedte)) {
      Breek ("The linear system did not have exactly 1 solution\n");
    }
    delete temp;
  }
  else {
    //int opTeller=0;
    nieNulInskrywing ry[b.m]; // Die "volg" veld wys na die ry.
    
    for (i=0;i<b.m;i++) { // Maak 'n kopie om mee te werk.
      ry[i].volg = NULL;
      ry[i].kol = -1;
      nieNulLys nuut = &ry[i], oud = a.nn[i].volg;
      while (oud) {
        SoekKol (oud->kol, nuut);
        nuut->x = oud->x;
        oud = oud->volg;
      }
    }
    double x[b.totaal], spil;
    nieNulLys itr, itr2, volgende;
    if (!b.nn) memcpy (x, b.x, sizeof (x[0]) * b.totaal);
    else {
      for (i=0;i<b.m;i++) {
        itr=b.nn[i].volg;
        for (j=0;j<breedte;j++) {
          if (!itr || itr->kol > j) x[i*breedte+j]=0;
          else {
            x[i*breedte+j]=itr->x;
            itr=itr->volg;
          }
        } // Vir elke inskrywing in x
      }
    } // As b yl is
    int spilKolomme[a.m], pry[a.m]; // Ons gaan die rye permuteer.
    for (i=0;i<a.m;i++) pry[i]=i;
    for (i=0;i<a.m;i++) {
      int kortste = a.m + 1, kortsteRy, tel, spilKol;
      for (j=i;j<a.m;j++) {
        tel = 0;
        itr = ry[j].volg;
        while (itr && tel < kortste) {
          tel++;
          itr = itr->volg;
        }
        if (tel < kortste) {
          kortsteRy = j;
          kortste = tel;
        }
      } // Soek kortste ry
      tel = pry[kortsteRy]; // Ruil rye om
      pry[kortsteRy] = pry[i];
      pry[i] = tel;
      
      itr = ry[kortsteRy].volg;
      ry[kortsteRy].volg = ry[i].volg;
      ry[i].volg = itr;
      
      spil = 0;
      for (itr=ry[i].volg;itr;itr=itr->volg) {
        if (fabs (itr->x) > fabs (spil)) {
          spil = itr->x;
          spilKol = itr->kol;
        }
      }
      //cout << pry[i] << " "<<spilKol<<"\n";
      spilKolomme[i] = spilKol; // Maak terug substitusie makliker

      if (fabs (spil) <= 1e-10) {
        Breek ("The sparse linear system did not have exactly 1 solution\n");
      }
      // Nou gaan ons kolom spilKol elimineer m.b.v. veelvoude van ry[i]
      for (j=i+1;j<a.m;j++) {
        itr2=&ry[j];
        for (volgende=itr2->volg;volgende && volgende->kol < spilKol;
        volgende=volgende->volg) { itr2=volgende;}
        if (volgende && volgende->kol==spilKol) {
        // As ry[j] se spilKol nie-nul is
          assert (itr2->volg == volgende);
          double M = volgende->x / spil;
          volgende = volgende->volg;
          delete itr2->volg; // Vernietig spilkol.
          itr2->volg = volgende;
          //cout << spilKol - itr2->kol <<" "<<(volgende?volgende->kol-spilKol:1)<<"\n";
          
          itr2 = &ry[j];
          for (itr=ry[i].volg;itr;itr=itr->volg) {
          // Vir elke nie-nul inskrywing in ry[i]
            if (itr->kol != spilKol) {
              SoekKol (itr->kol, itr2);
              itr2->x -= M * itr->x;
            }
          }
          //opTeller++;
          double *ryi = x + pry[i]*breedte, *ryj = x + pry[j]*breedte;
          for (int k=0;k<breedte;k++) *ryj++ -= M * *ryi++;
        } // Vir elke ry wat 'n nie-nul inskrywing in spilKol het.
      }
    } // Elimineer elke kolom (waarskynlik kolom i)
    //for (i=0;i<2;i++) {
    //  cout <<vektor(2, ry+i)<<" "<<x[pry[i]]<<" ("<<spilKolomme[i]<<")\n";
    //}
    //cout <<"\n";
    for (i=0;i<antw.totaal;i++) antw.x[i]=0; // Begin met 0 antwoord
    for (i=a.m-1;i>=0;i--) {
      double *antwRy = antw.x + breedte*spilKolomme[i];
      double *wyser=antwRy, *wyser2=x+pry[i]*breedte;
      for (j=0;j<breedte;j++) *wyser++ = *wyser2++;
      for (itr=ry[i].volg;itr;) {
        if (itr->kol == spilKolomme[i]) spil = itr->x;
        else {
          wyser=antwRy;
          wyser2=antw.x + itr->kol*breedte;
          //opTeller++;
          for (j=0;j<breedte;j++) *wyser++ -= itr->x * *wyser2++;
        }
      
        itr2=itr->volg;
        delete itr;
        itr=itr2;
      }
      wyser=antwRy;
      //opTeller++;
      for (j=0;j<breedte;j++) *wyser++ /= spil;
    } // Terug substitisie.
    //cout << opTeller << " bewerkings vir 'n "<<a.m<<"vektor\n";
  } // As die matriks yl is.
  return antw;
}
ostream& operator<<(ostream& str, vektor a)
{
  str << "[";
  if (!a.nn) for (int i=0;i<a.totaal;i++) str << ' ' << a.x[i];
  else {
    nieNulLys itr = a.nn[0].volg;
    for (int i=0;i<a.totaal;i++) {
      if (itr && itr->kol <= i) {
        str << ' ' << itr->x;
        itr = itr->volg;
      }
      else str << ' ' << 0.0;
    }
  }
  str << " ]";
  return str;
}
matriks Identiteit (int m)
{
  matriks antw (m, m);
  int i;
  for (i=0;i<antw.totaal;i++) antw.x[i]=0;
  for (i=0;i<antw.totaal;i+=m+1) antw.x[i]=1;
  return antw;
}
matriks NulMatriks (int m, int n)
{
  matriks antw (m, n);
  double *ptr = antw.x;
  for (int i=0;i<antw.totaal;i++) *ptr++ = 0;
  return antw;
}
matriks YlMatriks (int m, int n)
{
  matriks antw;
  antw.totaal = m * n;
  antw.m = m;
  antw.nn = new nieNulInskrywing[m];
  for (int i=0;i<m;i++) {
    antw.nn[i].volg = NULL;
    antw.nn[i].kol = -1;
  }
  antw.verwysings = new int;
  antw.verwysings[0] = 1;
  return antw;
}

matriks EindigeElementK1D (double l, int n, double q,
  bools links0, bools regs0)
{
  matriks K = NulMatriks (n + 1, n + 1);
  double h = l / n;
  int i;
  for (i = 0; i <= n; i++) K[i][i] = 2/h + 2*q*h/3;
  K[0][0] /= 2;
  K[n][n] /= 2;
  for (i = 1; i <= n; i++) {
    if (!(i == 1 && links0) && !(i == n && regs0)) {
      K[i-1][i] = K[i][i-1] = -1/h + q*h/6;
    }
  }
  return K;
}

matriks EindigeElementM1D (double l, int n, bools links0, bools regs0)
{
  double h = l / n;
  matriks M = NulMatriks (n + 1, n + 1);
  int i;
  for (i = 0; i <= n; i++) M[i][i] = h * 2.0 / 3;
  M[0][0] /= 2;
  M[n][n] /= 2;
  for (i = 1; i <= n; i++) {
    if (!(i == 1 && links0) && !(i == n && regs0)) {
      M[i-1][i] = M[i][i-1] = h / 6;
    }
  }
  return M;
}

static bools LeOpRand(node2dTipe &n, rand2d &r)
{
  double t = ((n.x - r.x)*r.deltax + (n.y - r.y)*r.deltay) / r.normDelta;

  return bools (0<=t && t<=1 &&
    Kwadreer(n.x-r.x-r.deltax*t) + Kwadreer(n.y-r.y-r.deltay*t) < 1e-20);
}

void EindigeElementPoisson (verdeling2d &v)
{
  v.K = YlMatriks (v.nnodes, v.nnodes);
  v.M = YlMatriks (v.nnodes, v.nnodes);
  v.F = vektor (v.nnodes);

  int i, j, d;
  element2d *e;

  for (i=0;i<v.nnodes;i++) {
    v.F[i] = 0; // Begin "M" * f berekening
    v.node[i].nul = vals;
    for (j=0;j<v.nrande;j++) {
      if (v.rand[j].gradKoef==0 && LeOpRand(v.node[i], v.rand[j])) {
        v.node[i].nul = waar;
        v.F[i] = EvalXY (v.rand[j].waarde, v.node[i].x, v.node[i].y);
        v.K[i][i] = v.rand[j].uKoef; // uKoef*u[i] = rand[j].waarde
        break; // Net een rand werk op elke punt in.
      }
    }
  }

  for (d=0, e=v.dh;d < v.ndriehoeke; d++,e++) {
    // Ons skuif die asse stelsel sodat v.node[v.dh[d].i[2]] by (0,0) is.
    matriks A (2, 2);
    for (i = 0; i < 2; i++) {
      A[i][0] = v.node[e->i[i]].x - v.node[e->i[2]].x;
      A[i][1] = v.node[e->i[i]].y - v.node[e->i[2]].y;
    }

    double krag[3]; // f
    for (i=0;i<3;i++) {
      krag[i] = EvalXY (e->krag, v.node[ e->i[i] ].x, v.node[ e->i[i] ].y);
      // Regterkant
    }

    double opp = fabs (A[0][0] * A[1][1] - A[0][1] * A[1][0]) / 2;
    // if (opp == 0) wat dan ?
    static double konstant[] = {  1, 0,-1,
                                  0, 1,-1 };
    matriks B = matriks (2, 3, konstant) / A;
    for (i=0;i<3;i++) {
      for (j=0;j<3;j++) {
        if (v.node[ e->i[i] ].nul == vals) {
          double m = opp / ((i != j) ? 12 : 6);
          v.K[e->i[i]][e->i[j]] += e->uKoef * m -
            (B[0][i]*B[0][j] + B[1][i]*B[1][j]) * opp * e->laplaceKoef;
          v.M[ e->i[i] ][ e->i[j] ] += m;
          v.F[ e->i[i] ] += krag[j] * m; // Bereken beide M en F.
        }
      } // Vir elke moontlike kombinasie van i en j
    }
    int nextI=0;
    for (i=2;nextI<3;i=nextI,nextI++) { // Kyk of een van die
      for (j=0;j<v.nrande;j++) { // drie sye op 'n ongedwonge rand is.
        if (v.rand[j].gradKoef!=0 && LeOpRand(v.node[e->i[i]], v.rand[j]) &&
        LeOpRand(v.node[e->i[nextI]], v.rand[j])) {
          double a = EvalXY (v.rand[j].waarde,
            v.node[ e->i[i] ].x, v.node[ e->i[i] ].y);
          double b = EvalXY (v.rand[j].waarde,
            v.node[ e->i[nextI] ].x, v.node[ e->i[nextI] ].y);
          double l=sqrt(Kwadreer(v.node[e->i[i]].x - v.node[e->i[nextI]].x)+
            Kwadreer(v.node[e->i[i]].y - v.node[ e->i[nextI] ].y));
          double beta=e->laplaceKoef/v.rand[j].gradKoef;
          double bKoef=v.rand[j].uKoef*beta;
          if (!v.node[e->i[i]].nul) {
            v.F[ e->i[i] ] -= beta*(2*a+b)*l/6; // Hfstk 1 p 16
            v.K[ e->i[i] ][ e->i[nextI] ] -= l/6*bKoef;
            v.K[ e->i[i] ][ e->i[i] ] -= l/3*bKoef;
          }
          if (!v.node[e->i[nextI]].nul) {
            v.F[ e->i[nextI] ] -= beta*(a + 2*b)*l/6;
            v.K[ e->i[nextI] ][ e->i[nextI] ] -= l/3*bKoef;
            v.K[ e->i[nextI] ][ e->i[i] ] -= l/6*bKoef;
          }
        } // As die sy op die rand le^.
      } // Kyk na alle rande.
    }
  } // Vir elke driehoek.
}

void MaakInverteerbaar (matriks kOfM, verdeling2d &v)
{
  for (int i=0;i<v.nnodes;i++) {
    if (v.node[i].nul) kOfM[i][i] = 1;
  }
}

verdeling2d Verfyning (verdeling2d &v, int ekstraNodes)
{
  verdeling2d n;
  memcpy (&n, &v, sizeof (n));
  n.node = new node2dTipe[v.nnodes + ekstraNodes];
  memcpy (n.node, v.node, sizeof (v.node[0]) * v.nnodes);
  n.dh = new element2d[v.ndriehoeke + ekstraNodes*2];
  // Neem aan dat elke lyn hoogstens aan 2 driehoeke behoort
  memcpy (n.dh, v.dh, sizeof (v.dh[0]) * v.ndriehoeke);
  n.ndriehoeke = v.ndriehoeke;
  double langste2;
  for (n.nnodes = v.nnodes; n.nnodes < v.nnodes + ekstraNodes; n.nnodes++) {
    int lBegin, lEindig; // Kry langste lyn
    langste2 = 0;
    for (int i = 0; i < n.ndriehoeke; i++) {
      int *dh = n.dh[i].i;
      for (int j = 0; j < 2; j++) {
        for (int k = j + 1; k < 3; k++) {
          double lengte2 = Kwadreer (n.node[dh[j]].x - n.node[dh[k]].x) +
            Kwadreer (n.node[dh[j]].y - n.node[dh[k]].y);
          if (lengte2 >= langste2) {
            langste2 = lengte2;
            lBegin = dh[j];
            lEindig = dh[k];
          }
        }
      } // Vir elke sy van die driehoek
    } // Vir elke sy van elke driehoek.
    // if (langste2 == 0) wat dan ?
    n.node[n.nnodes].x = (n.node[lBegin].x + n.node[lEindig].x) / 2;
    n.node[n.nnodes].y = (n.node[lBegin].y + n.node[lEindig].y) / 2;
    // Die middelpunt moet nul geforseer word slegs as altwee die
    // eindpunt nul is.
    int ouAantalDriehoeke = n.ndriehoeke;
    for (int i = 0; i < ouAantalDriehoeke; i++) {
      int *dh = n.dh[i].i;
      for (int j = 0; j < 3; j++) {
        if (dh[j] == lBegin) {
          for (int k = 0; k < 3; k++) {
            if (dh[k] == lEindig) {
              memcpy (&n.dh[n.ndriehoeke], &n.dh[i],
                sizeof (n.dh[n.ndriehoeke])); // Kopieer i en krag
              dh[j] = n.nnodes;
              n.dh[n.ndriehoeke++].i[k] = n.nnodes;
            } // As hierdie driehoek lBegin--lEindig as 'n sy het.
          } // Vir elke sy
        }
      }
    } // Vir elke driehoek.
    //n.node[n.nnodes].nul = bools (n.ndriehoeke - ouAantalDriehoeke == 1 &&
    //  n.node[lBegin].nul && n.node[lEindig].nul);
    //if (n.node[lBegin].nul && n.node[lEindig].nul &&
    //n.ndriehoeke - ouAantalDriehoeke != 1)
    //  cout << "Fout!\n";
  }
  //cout << "#"<<langste2<<"#";
  return n;
}

static int KryKleurIdx(const char *str)
{
  int k;
  if (sscanf (str, "%d", &k) != 1) {
    fprintf (stderr, "Parse error in fig file.\n");
    return 0;
  }
  if (k >= MAKS_FIG_KLEURE) {
    fprintf (stderr, "Too many colors in the fig file.\n");
    return 0;
  }
  k++;
  return k<0 ? 0 : k;
}

void LeesFig (char *leerNaam, verdeling2d &v, bools nulOpRant,
  void (*hanteerMerker)(char *merk, double x, double y, verdeling2d &v))
// Kyk na file:/usr/X11R6/lib/X11/xfig/html/fig-format.html
{
  volatile double x, y; // volitile needed : Bug in g++ -O3 ?
  char line[160], *str;
  int kleur, tipe, n, i, j, a, b, c;
  float ph; // plekhouer (dummy)
  double palet[MAKS_FIG_KLEURE+1][3]={
    { 0.2,0.2,  1 }, // -1 Dis die default blouerige kleur, soos glpoisson
    { 0.5,0.5,0.5 }, //  0 GREY. Dis moeilik om met wit in xfig te werk.
    {   0,  0,  1 }, //  1
    {   0,  1,  0 }, //  2
    {   0,  1,  1 }, //  3
    {   1,  0,  0 }, //  4
    {   1,  0,  1 }, //  5
    {   1,  1,  0 }, //  6
    {   1,  1,  1 }, //  7
  };

  FILE *f = fopen (leerNaam, "r");
  if (f == NULL) {
    perror (leerNaam);
    exit(2);
  }
  
  v.node = new node2dTipe[200];
  v.dh = new element2d[200];
  v.rand = new rand2d[200];
  v.nnodes = 0;
  v.ndriehoeke = 0;
  v.nrande = 0;
  for (i=0;i<sizeof(v.effek)/sizeof(v.effek[0]);i++) {
    v.effek[i] = new char[160];
    strcpy (v.effek[i], "$-\\\\Delta u=0$");
  }

  while (fgets(line,sizeof(line),f)) {
    if (strncmp (line, "0 ", 2)==0) {
      kleur = KryKleurIdx (line+2);
      int hex;
      sscanf(strchr(line,'#')+1,"%x",&hex);
      palet[kleur][0]=((hex>>16)&0xFF)/255.0;
      palet[kleur][1]=((hex>> 8)&0xFF)/255.0;
      palet[kleur][2]=((hex    )&0xFF)/255.0;
    }
    if (strncmp (line,"2 3 ",4)==0 || strncmp(line,"2 1 ",4)==0) {
      sscanf(line, "%d %d %d %d %d %f %f %f %f %f %f %f %f %f %f %d",
        &ph,&tipe,&ph,&ph,&kleur,&ph,&ph,&ph,&ph,&ph,&ph,&ph,&ph,&ph,&ph,&n);
      kleur = KryKleurIdx (line+8);
      int kloksgewys;
      for (i=0;i<n;) {
        fgets (line, sizeof(line), f);
        for (str = strtok (line, " \t"); str; str = strtok (NULL," \t")) {
          x=atof (str)/1200; // Werk in duime. Long live the Queen
          y=atof (strtok(NULL, " \t"))/1200;
          if (tipe==3) {
            for (j=0;;j++) {
              if (j>=v.nnodes) {
                v.node[v.nnodes].x=x;
                v.node[v.nnodes++].y=y;
                break;
              }
              if (v.node[j].x == x && v.node[j].y == y) break;
            }
            if (i==0) a=j; // Breek poligoon op (waaiervormig).
            else if (i==n-1) {
              if (j!=a) cerr << "Error : One of the figures is open\n";
            }
            else {
              b=c; c=j;
              if (i > 1) { // 3de,4de,... punte dra elke 1 element by.
                v.dh[v.ndriehoeke].krag = v.effek[kleur];
                memcpy (v.dh[v.ndriehoeke].kleur, palet[kleur],
                  sizeof (v.dh[v.ndriehoeke].kleur));
                v.dh[v.ndriehoeke].i[0] = a;
                int kloksgewys2=(v.node[a].x-x)*(v.node[b].y-y) > //Gelykheid
                (v.node[b].x-x)*(v.node[a].y-y); // hier, lei tot probleme
                if (i==2) kloksgewys=kloksgewys2;
                else if (kloksgewys!=kloksgewys2) {
                  cerr << "Warning : Some polygon is not convex\n";
                }
                if (kloksgewys2) {
                  v.dh[v.ndriehoeke].i[1] = b;
                  v.dh[v.ndriehoeke++].i[2] = c;
                }
                else {
                  v.dh[v.ndriehoeke].i[1] = c;
                  v.dh[v.ndriehoeke++].i[2] = b;
                }
              }
            } // As ons 'n nuwe element moet byvoeg.
          }
          else { // As dit 'n oop poligoon is.
            if (i>0) {
              v.rand[v.nrande].deltax=x-v.rand[v.nrande].x;
              v.rand[v.nrande].deltay=y-v.rand[v.nrande].y;
              v.rand[v.nrande].normDelta=max(
                (Kwadreer(v.rand[v.nrande].deltax)+
                 Kwadreer(v.rand[v.nrande].deltay)), 1e-10);
              v.rand[v.nrande++].waarde=v.effek[kleur];
            }
            v.rand[v.nrande].x=x;
            v.rand[v.nrande].y=y;
          }
          i++;
        } // Vir elke punt.
      } // Vir elke lyntjie van elke poligoon.
    } // As dit 'n poligoon is.
    else if (strncmp(line,"4 0 ",4)==0) {
      kleur = KryKleurIdx (line+4);
      for (strtok(line," \t"),i=1;i<11;i++) strtok (NULL, " \t");
      x=atof(strtok(NULL, " \t"))/1200;
      y=atof(strtok(NULL, " \t"))/1200;
      str=strtok(NULL,"");
      *strstr(str,"\\001")='\0'; // Gooi die \001 weg.
      while (isspace(*str)) str++;
      if (str[0]=='$') strcpy (v.effek[kleur], str);
      else {
        if (hanteerMerker) (*hanteerMerker)(str,x,y,v);
      }
    } // As dit teks is.
  } // Gaan deur die leer.
  fclose (f);

  simbool s0[]={{"nabla u\\\\cdot n", 0 }, {"u", 0} };
  simbool sG[]={{"nabla u\\\\cdot n", 1 }, {"u", 0} };
  simbool sU[]={{"nabla u\\\\cdot n", 0 }, {"u", 1} };
  for (i=0;i<v.nrande;i++) {
    
    if (strchr(v.rand[i].waarde,'=')==NULL) {
      Breek ("Expected an equation : %s\n", v.rand[i].waarde);
    }
    if (Eval(v.rand[i].waarde, s0, sizeof(s0)/sizeof(s0[0])) != 0) {
      Breek ("Lefthand side can only contain u and grad u.n\n");
    }
    v.rand[i].gradKoef=Eval(v.rand[i].waarde,sG,sizeof(sG)/sizeof(sG[0]));
    v.rand[i].uKoef=Eval(v.rand[i].waarde,sU,sizeof(sU)/sizeof(sU[0]));
    v.rand[i].waarde=strchr(v.rand[i].waarde,'=')+1; // Kry regterkant
  }

  simbool e0[]={{"Delta u", 0 }, {"u", 0} };
  simbool eG[]={{"Delta u", 1 }, {"u", 0} };
  simbool eU[]={{"Delta u", 0 }, {"u", 1} };
  for (i=0;i<v.ndriehoeke;i++) {
    if (strchr(v.dh[i].krag,'=') == NULL) {
      Breek ("Expected an equation : %s\n", v.dh[i].krag);
    }
    if (Eval(v.dh[i].krag, e0, sizeof(e0)/sizeof(e0[0])) != 0) {
      Breek ("Lefthand side can only contain u and Delta u\n");
    }
    v.dh[i].laplaceKoef=Eval(v.dh[i].krag,eG,sizeof(eG)/sizeof(eG[0]));
    v.dh[i].uKoef=Eval(v.dh[i].krag,eU,sizeof(eU)/sizeof(eU[0]));
    v.dh[i].krag=strchr(v.dh[i].krag,'=')+1; // Kry regterkant
  }
}

double Eval(const char *uitd,simbool *lys,int lysLengte) //expr,list,listLen
{ // An infix parser. The code is just over 100 lines, so read throu it a
  // few times before making any changes.
  double x=0;
  bools soekWaarde=waar; // lookingForValue=true
  struct opTipe { // operatorType
    char *operat; // Points to pieces of uitd
    int prioriteit, uner; // precendence, unary
  } *op;
  static opTipe opTabel[]={ // operatorTable
    { "(",         1, 1 },
    { "{",         1, 1 },
    { ")",         2, 0 }, // Biner maak dinge makliker
    { "}",         2, 0 },
    { "=",         2, 0 }, // '=' is handeled like '\0' (end of line).
    { "over",      5, 0 }, // Prioriteite soos TeX
    { "+",        10, 0 },
    { "-",        10, 0 }, // Une^re - word apart hanteer.
#define MPRIO 30
    { "*",     MPRIO, 0 },
    { "/",     MPRIO, 0 },
    { "^",       200, 0 }, // Prioriteite soos TeX
    { "sqrt",    200, 1 }, // Prioriteite soos TeX
    { "cos",     200, 1 },
    { "sin",     200, 1 },
    { "tan",     200, 1 },
    { "arccos",  200, 1 },
    { "arcsin",  200, 1 },
    { "arctan",  200, 1 },
    { "cosh",    200, 1 },
    { "sinh",    200, 1 },
    { "tanh",    200, 1 },
    { "log",     200, 1 },
    { "ln",      200, 1 },
    { "exp",     200, 1 },
  };
  struct {
    double x;
    const char *operat; // Wys na plekke in die string
    int prioriteit; // precedence
  } stapelSkikking[10], *stapel=stapelSkikking;

  stapel->prioriteit=0;
  while (1) { // Stop as ons die '\0' of '=' operator kry.
    if (soekWaarde) {
      if (isdigit(*uitd) && sscanf (uitd, "%lf", &x)==1) {
        soekWaarde = vals;
        while (isdigit (*uitd) || *uitd=='.') uitd++;
      }
      else {
        for (int i=0;i<lysLengte;i++) {
          if (strncmp (uitd, lys[i].naam, strlen (lys[i].naam))==0) {
            x=lys[i].waarde;
            soekWaarde=vals;
            uitd += strlen (lys[i].naam);
            break;
          }
        } // Vir elke moontlike veranderlike
      } // As dit nie 'n konstante is nie
    }  // As ons 'n waarde soek.
    // Hanteer 'n operator. As soekWaarde==waar, is dit une^r.
    op=opTabel; // Wit karakters is net so lank soos '('
    if (!isspace (*uitd) && *uitd!='\\' && *uitd!='$') {
    // Quitely igore backslashes and dollar signs (violence and money ?)
      for (op=opTabel;strncmp (uitd, op->operat, strlen(op->operat)) != 0 &&
      (*uitd!='\0' || op->operat[0]!='=');) {
        if (++op - opTabel >= sizeof(opTabel)/sizeof(opTabel[0])) {
          cerr << "Cannot evaluate subexpression : "<< uitd << endl;
          return 0;
        }
      }
      //if (*uitd=='\0') cout <<"end"<<op->operat<<" "<<op->uner<<endl;
      int binPrior = op->uner ||(soekWaarde && *uitd != '-') ? INT_MAX :
        op->prioriteit;
      if (op->uner && !soekWaarde) binPrior = MPRIO;
      while (stapel->prioriteit >= binPrior) {
        if (*stapel->operat=='+') x=stapel->x + x;
        else if (*stapel->operat=='-') x=stapel->x - x;
        else if (*stapel->operat=='*') x=stapel->x*x;
        else if (*stapel->operat=='/') x=stapel->x/x;
        else if (strncmp(stapel->operat,"over",4)==0) x=stapel->x/x;
        else if (*stapel->operat=='^') x=pow(stapel->x,x);
        else if (strncmp(stapel->operat,"sqrt",4)==0) x=sqrt(x);
        else if (strncmp(stapel->operat,"cos",3)==0) x=cos(x);
        else if (strncmp(stapel->operat,"sin",3)==0) x=sin(x);
        else if (strncmp(stapel->operat,"tan",3)==0) x=tan(x);
        else if (strncmp(stapel->operat,"arccos",6)==0) x=acos(x);
        else if (strncmp(stapel->operat,"arcsin",6)==0) x=asin(x);
        else if (strncmp(stapel->operat,"arctan",6)==0) x=atan(x);
        else if (strncmp(stapel->operat,"cosh",4)==0) x=cosh(x);
        else if (strncmp(stapel->operat,"sinh",4)==0) x=sinh(x);
        else if (strncmp(stapel->operat,"tanh",4)==0) x=tanh(x);
        else if (strncmp(stapel->operat,"log",3)==0) x=log(x);
        else if (strncmp(stapel->operat,"ln",2)==0) x=log(x);
        else if (strncmp(stapel->operat,"exp",3)==0) x=exp(x);
        else cerr<<"Cannot evaluate subexpression : "<<stapel->operat<<endl;
        stapel--;
      }
      if (op->operat[0] == '=') return x;
      if (op->prioriteit==2) { // As dit '}' of ')' is
        assert(stapel->operat[0]=='('||stapel->operat[0]=='{');
        stapel--; // Gooi die '(' of '{' weg
      }
      else {
        if (op->uner && !soekWaarde) {
          stapel++; // Verander "2 cos 1" na "2 * cos 1"
          stapel->x=x;
          stapel->operat="*";
          stapel->prioriteit=MPRIO;
        }
        stapel++; //push
        stapel->x = soekWaarde ? 0 : x; // Une^re -
        stapel->operat = uitd;
        stapel->prioriteit = op->prioriteit;

        soekWaarde=waar;
      }
    }
    uitd += strlen(op->operat);
  }
}

double EvalXY (const char *uitd, double x, double y)
{
  static simbool s[]={{"x", 0}, {"y", 0 }};
  s[0].waarde=x;
  s[1].waarde=y;
  return Eval (uitd, s, sizeof (s)/sizeof(s[0]));
}

int glMouseX=320, glMouseY=240;
static int osFrame=-1, vries=GL_FALSE, frame=0;
static void (*wysFunksie)(void), (*volgende)(), (*herstel)();
static void (*knoppieFunk)(unsigned char k)=NULL;

static void Draai (int x, int y)
{
  glMouseX=x;
  glMouseY=y;
  glutPostRedisplay ();
}
static void Knoppie (unsigned char k, int x, int y)
{
  if (k == 0x1B) exit (0);
  else if (k == ' ') {
    if (herstel) (*herstel)();
    frame=0;
  }
  else if (tolower(k) == 'm') {
    printf ("-offscreen %d,%d,%d >x.ppm\n", glMouseX, glMouseY, frame);
  }
  else if (tolower(k) == 'p') vries=!vries;
  else if (knoppieFunk) (*knoppieFunk)(k);
  
  glutPostRedisplay();
}

static void Wys (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix ();
  glRotatef (240 - glMouseY - 90, 1, 0, 0);
  glRotatef (320 - glMouseX, 0, 0, 1);
  if (!vries && volgende) {
    (*volgende)();
    frame++;
  }
  (*wysFunksie)();
  glPopMatrix();
   
  if (osFrame < 0) glutSwapBuffers();
  if (!vries && volgende && osFrame < 0) glutPostRedisplay ();
}

void GrafikaKeyboardFunc(void (*keyFunc)(unsigned char k))
{
  knoppieFunk=keyFunc;  
}

void DoenGrafika (int *argc, char *argv[], void (*_wysFunksie)(),
  void (*_herstel)(), void (*_volgende)(), int beligting)
{
  int width=640, height=480, crop=0;
  GLubyte *osBuf;
  OSMesaContext ctx;
  
  for (int i=1;i<*argc;i++) {
    if (strcmp (argv[i], "-geometry") == 0 && ++i < *argc) {
      sscanf(argv[i], "%dx%d",&width,&height);
    }
    if (strcmp (argv[i], "-offscreen") == 0 && ++i < *argc) {
      sscanf(argv[i], "%d,%d,%d",&glMouseX,&glMouseY,&osFrame);
    }
    if (strcmp (argv[i], "-crop") == 0) crop=1;
  }

  wysFunksie = _wysFunksie;
  volgende = _volgende;
  herstel = _herstel;
  if (osFrame < 0) {
    glutInitWindowPosition (0, 0);
    glutInitWindowSize (width, height); // Override 300x300 default
    glutInit (argc, argv);
    glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
    glutCreateWindow (argv[0]);
           
    glutDisplayFunc (Wys);
    glutKeyboardFunc (Knoppie);
    glutPassiveMotionFunc (Draai);
  }
  else {
    ctx=OSMesaCreateContext (GL_RGBA, NULL);
    osBuf=malloc(width*height*4);
    OSMesaMakeCurrent (ctx, osBuf, GL_UNSIGNED_BYTE, width, height);
  }
  
  if (beligting) {
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    //GLfloat omgewingLig[] = { 0.4,0.4,0.4,1 };
    //glLightModelfv (GL_LIGHT_MODEL_AMBIENT, omgewingLig);
    glLightModeli (GL_LIGHT_MODEL_TWO_SIDE, 1);
    GLfloat ligPosisie[] = { 10, 10, 0, 0 };
    glLightfv (GL_LIGHT0, GL_POSITION, ligPosisie);
  }
      
  glEnable(GL_DEPTH_TEST);
  glCullFace (GL_BACK);
  if (osFrame >= 0 && crop) glClearColor (1,1,1,0);
  //glEnable (GL_CULL_FACE);
  
  //glViewport( 0, 0, 640, 480);
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glFrustum( -1.333, 1.333, 1.0, -1.0, 3.0, 30.0 );
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();
  glTranslatef (0, 0.0, oogAfstand);

  if (herstel) (*herstel)();
  if (osFrame < 0) glutMainLoop ();
  else {
    for (int i=0;i<osFrame;i++) (*volgende)();
    vries=GL_TRUE; // Frame 0 must show the initial state
    Wys();
    
    int x,y,minx=0,maxx=width,miny=0,maxy=height,flag;
    if (crop) {
      for(flag=1;flag && minx < width;minx++) {
        for(y=minx*4;y<height*width*4;y+=width*4) {
          if(osBuf[y]!=255 || osBuf[y+1]!=255 || osBuf[y+2]!=255) flag=0;
        }
      }
      minx--;
      for(flag=1;flag && maxx >= minx;maxx--) {
        for(y=maxx*4-4;y<height*width*4;y+=width*4) {
          if(osBuf[y]!=255 || osBuf[y+1]!=255 || osBuf[y+2]!=255) flag=0;
        }
      }
      maxx++;

      for(flag=1;flag && miny < height;miny++) {
        for (y=miny*width*4,x=0;x<width;x++,y+=4) {
          if(osBuf[y]!=255 || osBuf[y+1]!=255 || osBuf[y+2]!=255) flag=0;
        }
      }
      miny--;
      for(flag=1;flag && maxy >= miny;maxy--) {
        for (y=(maxy-1)*width*4,x=0;x<width;x++,y+=4) {
          if(osBuf[y]!=255 || osBuf[y+1]!=255 || osBuf[y+2]!=255) flag=0;
        }
      }
      maxy++;
    } // "-crop"
    
    printf("P6\n# raw ppm created by %s\n%d %d\n255\n",argv[0],
      maxx-minx, maxy-miny);
    for (int y=maxy-1;y>=miny;y--) {
      for (int x=minx;x<maxx;x++) {
        fwrite (osBuf+(y*width+x)*4, 3, 1, stdout);
      }
    }
    exit(0); // Let the kernel clean up the context and the buffer.
  }
}

