%{
/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-1997,1999,2000 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#include "globals.h"
#include "y.tab.h"
#include "symtab.h"
#include <math.h>

#undef input	/* disable lex input() */
#undef unput	/* disable lex unput() */

extern complex	xArg, yArg, gArg;
extern char	*formula;
extern int	yyPos;





/* ----------------------------------------------------------------------------
 * input - substitute for lex input()
 * ------------------------------------------------------------------------- */

char input(void)
{
	yyPos++;
	return(*formula++);
}





/* ----------------------------------------------------------------------------
 * unput - substitute for lex unput()
 * ------------------------------------------------------------------------- */

void unput(char c)
{
	yyPos--;
	*--formula = c;
}

%}

%%

exp		return EXP;
ln		return LN;
log		return LOG;
sqrt		return SQRT;
sin		return SIN;
cos		return COS;
tan		return TAN;
cot		return COT;
sinh		return SINH;
cosh		return COSH;
tanh		return TANH;
coth		return COTH;
arcsin		return ARCSIN;
arccos		return ARCCOS;
arctan		return ARCTAN;
arccot		return ARCCOT;
arsinh		return ARSINH;
arcosh		return ARCOSH;
artanh		return ARTANH;
arcoth		return ARCOTH;
erf		return ERF;
erfc		return ERFC;
fact		return FACT;
sgn		return SGN;
int		return INT;
frac		return FRAC;
round		return ROUND;
re!		return SRE;
RE!		return SRE;
im!		return SIM;
IM!		return SIM;
abs		return ABS;
phi		return PHI;
re		return RE;
im		return IM;

j(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))e {
		yylval.cval.re = 0;
		yylval.cval.im = atof(&yytext[1])*M_E;
		return NUMBER;
		}
j(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))pi {
		yylval.cval.re = 0;
		yylval.cval.im = atof(&yytext[1])*M_PI;
		return NUMBER;
		}
j(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))x {
		yylval.cval.re = -atof(&yytext[1])*xArg.im;
		yylval.cval.im = atof(&yytext[1])*xArg.re;
		return NUMBER;
		}
jx		{
		yylval.cval.re = -xArg.im;
		yylval.cval.im = xArg.re;
		return NUMBER;
		}
j(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))y {
		yylval.cval.re = -atof(&yytext[1])*yArg.im;
		yylval.cval.im = atof(&yytext[1])*yArg.re;
		return NUMBER;
		}
jy		{
		yylval.cval.re = -yArg.im;
		yylval.cval.im = yArg.re;
		return NUMBER;
		}
j(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?)) {
		yylval.cval.re = 0;
		yylval.cval.im = atof(&yytext[1]);
		return NUMBER;
		}
(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))e {
		yylval.cval.re = atof(yytext)*M_E;
		yylval.cval.im = 0;
		return NUMBER;
		}
(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))pi {
		yylval.cval.re = atof(yytext)*M_PI;
		yylval.cval.im = 0;
		return NUMBER;
		}
(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))x {
		yylval.cval.re = atof(yytext)*xArg.re;
		yylval.cval.im = atof(yytext)*xArg.im;
		return NUMBER;
		}
(([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?))y {
		yylval.cval.re = atof(yytext)*yArg.re;
		yylval.cval.im = atof(yytext)*yArg.im;
		return NUMBER;
		}
e		{
		yylval.cval.re = M_E;
		yylval.cval.im = 0;
		return NUMBER;
		}
j		{
		yylval.cval.re = 0;
		yylval.cval.im = 1;
		return NUMBER;
		}
pi		{
		yylval.cval.re = M_PI;
		yylval.cval.im = 0;
		return NUMBER;
		}
x		{
		yylval.cval.re = xArg.re;
		yylval.cval.im = xArg.im;
		return NUMBER;
		}
y		{
		yylval.cval.re = yArg.re;
		yylval.cval.im = yArg.im;
		return NUMBER;
		}
([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?) {
		yylval.cval.re = atof(yytext);
		yylval.cval.im = 0;
		return NUMBER;
		}
[A-Za-z][A-Za-z0-9]* {
		yylval.symp = lookSymtab(yytext);
		return NAME;
		}
[ \t]		;			/* ignore whitespace */
\n		return 0;		/* logical EOF */
.		return yytext[0];	/* any other character */
%%
