
# line 2 "parse.y"
/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-1997,1999,2000 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#include "globals.h"
#include "symtab.h"
#include "math.h"
#include <math.h>

extern void	printError(char *);
extern boolean	parseError;
extern complex	result;


# line 34 "parse.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
	complex		cval;
	struct symtab	*symp;
} YYSTYPE;
# define NAME 257
# define NUMBER 258
# define SRE 259
# define SIM 260
# define RE 261
# define IM 262
# define ABS 263
# define PHI 264
# define SGN 265
# define INT 266
# define FRAC 267
# define ROUND 268
# define EXP 269
# define LN 270
# define LOG 271
# define SQRT 272
# define SIN 273
# define COS 274
# define TAN 275
# define COT 276
# define SINH 277
# define COSH 278
# define TANH 279
# define COTH 280
# define ARCSIN 281
# define ARCCOS 282
# define ARCTAN 283
# define ARCCOT 284
# define ARSINH 285
# define ARCOSH 286
# define ARTANH 287
# define ARCOTH 288
# define ERF 289
# define ERFC 290
# define FACT 291
# define UMINUS 292

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 141 "parse.y"






/* ----------------------------------------------------------------------------
 * yyerror - print parsing error messages
 * ------------------------------------------------------------------------- */

void yyerror(char *message)
{
	parseError = TRUE;
	printError(message);
}





/* ----------------------------------------------------------------------------
 * lookSymtab - look up or add a symbol table entry
 * ------------------------------------------------------------------------- */

struct symtab *lookSymtab(char *s)
{
	char		*p;
	struct symtab	*sp;

	for (sp = symtab; sp < &symtab[NSYMS]; sp++) {

	    /* ---------------------------------- look up symbol table entry */
	
	    if (sp->name != NULL && strcmp(sp->name, s) == 0) {
	       return sp;
	    }

	    /* -------------------------------------- add symbol tabel entry */

	    if (sp->name == NULL) {
	       sp->name = strdup(s);
	       return sp;
	    }
	}

	yyerror("symbol overflow");
	return NULL;
}





/* ----------------------------------------------------------------------------
 * freeSymtab - free symbol table
 * ------------------------------------------------------------------------- */

void freeSymtab(int status)
{
	struct symtab	*sp;

	for (sp = symtab; sp < &symtab[NSYMS]; sp++) {
	    if (sp->name != NULL) {
	       free(sp->name);
	       sp->name = NULL;
	    }

	    sp->value.re = 0;
	    sp->value.im = 0;
	    sp->def = status;
	}
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 54
# define YYLAST 287
yytabelem yyact[]={

    42,   107,    42,    49,    88,    38,    48,    46,    51,    47,
     1,    50,    48,    46,     0,    47,     0,    50,    99,     3,
    45,     0,    45,     2,    48,    46,     0,    47,     0,    50,
     0,     0,     0,     0,     0,    42,    48,    46,    48,    47,
    38,    50,     0,    50,   105,     0,   102,    48,    46,     0,
    47,    43,    50,    43,     0,    45,     0,     0,    49,     0,
     0,    85,    87,     0,    49,     0,    89,    90,    91,    92,
    93,    94,    95,    96,    97,    98,    49,    48,    46,     0,
    47,     0,    50,    44,    37,    44,    43,   103,    49,   104,
    49,     0,     0,     0,   100,     0,     0,     0,     0,    49,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   101,     0,     0,     0,     0,     0,    44,    37,
     0,     0,     0,     0,     0,    39,     0,     0,     0,    49,
    52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
    62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
    72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
    82,    83,    84,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    86,    40,    31,
    32,    35,    36,    33,    34,    27,    28,    29,    30,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
    25,    26,    41,    40,    31,    32,    35,    36,    33,    34,
    27,    28,    29,    30,     4,     5,     6,     7,     8,     9,
    10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    21,    22,    23,    24,    25,    26 };
yytabelem yypact[]={

    -5,-10000000,    35,   -51,   -38,   -38,   -38,   -38,   -38,   -38,
   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,
   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -38,
   -38,   -38,   -38,   -38,   -38,   -38,   -38,   -40,   -40,-10000000,
-10000000,   -57,   -40,   -40,   -40,   -40,   -40,   -40,   -40,   -40,
   -40,    -5,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,   -30,-10000000,   -91,   -40,     5,
    -6,   -36,   -18,    -4,    -4,   -91,   -91,   -91,    35,-10000000,
-10000000,    35,-10000000,-10000000,-10000000,-10000000,  -256,   -57 };
yytabelem yypgo[]={

     0,    23,   125,    10,    18 };
yytabelem yyr1[]={

     0,     3,     3,     3,     3,     4,     4,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     2,     2,     2,     2 };
yytabelem yyr2[]={

     0,     0,     3,     3,     7,     6,     7,     7,     7,     7,
     7,     7,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     7,     5,     3,     3,     3,
     7,     7,     7,     7 };
yytabelem yychk[]={

-10000000,    -3,    -1,    -4,   269,   270,   271,   272,   273,   274,
   275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
   285,   286,   287,   288,   289,   290,   291,   265,   266,   267,
   268,   259,   260,   263,   264,   261,   262,   124,    45,    -2,
   258,   257,    40,    91,   123,    60,    43,    45,    42,    94,
    47,    59,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,
    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,
    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,
    -2,    -2,    -2,    -2,    -2,    -1,   257,    -1,    61,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -4,
   124,    -1,    41,    93,   125,    62,    59,   257 };
yytabelem yydef[]={

     1,    -2,     2,     3,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
    48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
    30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
    40,    41,    42,    43,    44,     0,    49,    46,     0,     0,
     0,     0,     0,     7,     8,     9,    10,    11,     4,     5,
    45,     6,    50,    51,    52,    53,     0,     0 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NAME",	257,
	"NUMBER",	258,
	"SRE",	259,
	"SIM",	260,
	"RE",	261,
	"IM",	262,
	"ABS",	263,
	"PHI",	264,
	"SGN",	265,
	"INT",	266,
	"FRAC",	267,
	"ROUND",	268,
	"EXP",	269,
	"LN",	270,
	"LOG",	271,
	"SQRT",	272,
	"SIN",	273,
	"COS",	274,
	"TAN",	275,
	"COT",	276,
	"SINH",	277,
	"COSH",	278,
	"TANH",	279,
	"COTH",	280,
	"ARCSIN",	281,
	"ARCCOS",	282,
	"ARCTAN",	283,
	"ARCCOT",	284,
	"ARSINH",	285,
	"ARCOSH",	286,
	"ARTANH",	287,
	"ARCOTH",	288,
	"ERF",	289,
	"ERFC",	290,
	"FACT",	291,
	"+",	43,
	"-",	45,
	"*",	42,
	"/",	47,
	";",	59,
	"UMINUS",	292,
	"^",	94,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"statement : /* empty */",
	"statement : expr",
	"statement : def",
	"statement : def ';' expr",
	"def : def ';' def",
	"def : NAME '=' expr",
	"expr : expr '+' expr",
	"expr : expr '-' expr",
	"expr : expr '*' expr",
	"expr : expr '^' expr",
	"expr : expr '/' expr",
	"expr : EXP brexpr",
	"expr : LN brexpr",
	"expr : LOG brexpr",
	"expr : SQRT brexpr",
	"expr : SIN brexpr",
	"expr : COS brexpr",
	"expr : TAN brexpr",
	"expr : COT brexpr",
	"expr : SINH brexpr",
	"expr : COSH brexpr",
	"expr : TANH brexpr",
	"expr : COTH brexpr",
	"expr : ARCSIN brexpr",
	"expr : ARCCOS brexpr",
	"expr : ARCTAN brexpr",
	"expr : ARCCOT brexpr",
	"expr : ARSINH brexpr",
	"expr : ARCOSH brexpr",
	"expr : ARTANH brexpr",
	"expr : ARCOTH brexpr",
	"expr : ERF brexpr",
	"expr : ERFC brexpr",
	"expr : FACT brexpr",
	"expr : SGN brexpr",
	"expr : INT brexpr",
	"expr : FRAC brexpr",
	"expr : ROUND brexpr",
	"expr : SRE brexpr",
	"expr : SIM brexpr",
	"expr : ABS brexpr",
	"expr : PHI brexpr",
	"expr : RE brexpr",
	"expr : IM brexpr",
	"expr : '|' expr '|'",
	"expr : '-' expr",
	"expr : brexpr",
	"expr : NUMBER",
	"expr : NAME",
	"brexpr : '(' expr ')'",
	"brexpr : '[' expr ']'",
	"brexpr : '{' expr '}'",
	"brexpr : '<' expr '>'",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 2:
# line 59 "parse.y"
{ result.re = yypvt[-0].cval.re;
					  result.im = yypvt[-0].cval.im; } break;
case 3:
# line 61 "parse.y"
{ } break;
case 4:
# line 62 "parse.y"
{ result.re = yypvt[-0].cval.re;
					  result.im = yypvt[-0].cval.im; } break;
case 6:
# line 67 "parse.y"
{ if (yypvt[-2].symp) {
					     yypvt[-2].symp->value.re = yypvt[-0].cval.re;
					     yypvt[-2].symp->value.im = yypvt[-0].cval.im;
					     yypvt[-2].symp->def = TRUE;
					  }
					} break;
case 7:
# line 75 "parse.y"
{ yyval.cval = cadd(yypvt[-2].cval,yypvt[-0].cval); } break;
case 8:
# line 76 "parse.y"
{ yyval.cval = csub(yypvt[-2].cval,yypvt[-0].cval); } break;
case 9:
# line 77 "parse.y"
{ yyval.cval = cmult(yypvt[-2].cval,yypvt[-0].cval); } break;
case 10:
# line 78 "parse.y"
{ yyval.cval = cpower(yypvt[-2].cval,yypvt[-0].cval); } break;
case 11:
# line 79 "parse.y"
{ yyval.cval = cdiv(yypvt[-2].cval,yypvt[-0].cval); } break;
case 12:
# line 80 "parse.y"
{ yyval.cval = cexp(yypvt[-0].cval); } break;
case 13:
# line 81 "parse.y"
{ yyval.cval = clog(yypvt[-0].cval); } break;
case 14:
# line 82 "parse.y"
{ yyval.cval = clog10(yypvt[-0].cval); } break;
case 15:
# line 83 "parse.y"
{ yyval.cval = csqrt(yypvt[-0].cval); } break;
case 16:
# line 84 "parse.y"
{ yyval.cval = csin(yypvt[-0].cval); } break;
case 17:
# line 85 "parse.y"
{ yyval.cval = ccos(yypvt[-0].cval); } break;
case 18:
# line 86 "parse.y"
{ yyval.cval = ctan(yypvt[-0].cval); } break;
case 19:
# line 87 "parse.y"
{ yyval.cval = ccot(yypvt[-0].cval); } break;
case 20:
# line 88 "parse.y"
{ yyval.cval = csinh(yypvt[-0].cval); } break;
case 21:
# line 89 "parse.y"
{ yyval.cval = ccosh(yypvt[-0].cval); } break;
case 22:
# line 90 "parse.y"
{ yyval.cval = ctanh(yypvt[-0].cval); } break;
case 23:
# line 91 "parse.y"
{ yyval.cval = ccoth(yypvt[-0].cval); } break;
case 24:
# line 92 "parse.y"
{ yyval.cval = carcsin(yypvt[-0].cval); } break;
case 25:
# line 93 "parse.y"
{ yyval.cval = carccos(yypvt[-0].cval); } break;
case 26:
# line 94 "parse.y"
{ yyval.cval = carctan(yypvt[-0].cval); } break;
case 27:
# line 95 "parse.y"
{ yyval.cval = carccot(yypvt[-0].cval); } break;
case 28:
# line 96 "parse.y"
{ yyval.cval = carsinh(yypvt[-0].cval); } break;
case 29:
# line 97 "parse.y"
{ yyval.cval = carcosh(yypvt[-0].cval); } break;
case 30:
# line 98 "parse.y"
{ yyval.cval = cartanh(yypvt[-0].cval); } break;
case 31:
# line 99 "parse.y"
{ yyval.cval = carcoth(yypvt[-0].cval); } break;
case 32:
# line 100 "parse.y"
{ yyval.cval = cerf(yypvt[-0].cval); } break;
case 33:
# line 101 "parse.y"
{ yyval.cval = cerfc(yypvt[-0].cval); } break;
case 34:
# line 102 "parse.y"
{ yyval.cval = cfact(yypvt[-0].cval); } break;
case 35:
# line 103 "parse.y"
{ yyval.cval = csgn(yypvt[-0].cval); } break;
case 36:
# line 104 "parse.y"
{ yyval.cval = cint(yypvt[-0].cval); } break;
case 37:
# line 105 "parse.y"
{ yyval.cval = cfrac(yypvt[-0].cval); } break;
case 38:
# line 106 "parse.y"
{ yyval.cval = cround(yypvt[-0].cval); } break;
case 39:
# line 107 "parse.y"
{ yyval.cval = sre(yypvt[-0].cval); } break;
case 40:
# line 108 "parse.y"
{ yyval.cval = sim(yypvt[-0].cval); } break;
case 41:
# line 109 "parse.y"
{ yyval.cval.re = cabs(yypvt[-0].cval);
					  yyval.cval.im = 0; } break;
case 42:
# line 111 "parse.y"
{ yyval.cval.re = cphi(yypvt[-0].cval);
					  yyval.cval.im = 0; } break;
case 43:
# line 113 "parse.y"
{ yyval.cval.re = yypvt[-0].cval.re;
					  yyval.cval.im = 0; } break;
case 44:
# line 115 "parse.y"
{ yyval.cval.re = yypvt[-0].cval.im;
					  yyval.cval.im = 0; } break;
case 45:
# line 117 "parse.y"
{ yyval.cval.re = cabs(yypvt[-1].cval);
					  yyval.cval.im = 0; } break;
case 46:
# line 119 "parse.y"
{ yyval.cval = cneg(yypvt[-0].cval); } break;
case 47:
# line 120 "parse.y"
{ yyval.cval = yypvt[-0].cval; } break;
case 48:
# line 121 "parse.y"
{ yyval.cval = yypvt[-0].cval; } break;
case 49:
# line 122 "parse.y"
{ if (yypvt[-0].symp) {
					     yyval.cval.re = yypvt[-0].symp->value.re;
					     yyval.cval.im = yypvt[-0].symp->value.im;
					     if (!yypvt[-0].symp->def)
					        yyerror("undefined symbol");
					  }
					} break;
case 50:
# line 131 "parse.y"
{ yyval.cval.re = yypvt[-1].cval.re;
					  yyval.cval.im = yypvt[-1].cval.im; } break;
case 51:
# line 133 "parse.y"
{ yyval.cval.re = yypvt[-1].cval.re;
					  yyval.cval.im = yypvt[-1].cval.im; } break;
case 52:
# line 135 "parse.y"
{ yyval.cval.re = yypvt[-1].cval.re;
					  yyval.cval.im = yypvt[-1].cval.im; } break;
case 53:
# line 137 "parse.y"
{ yyval.cval.re = yypvt[-1].cval.re;
					  yyval.cval.im = yypvt[-1].cval.im; } break;
# line	532 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

