/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-2000 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

#include <curses.h>





/* ----------------------------------------------------------------------------
 * curs_utils.h - editing header file
 * ------------------------------------------------------------------------- */

#ifndef KEYCODES
#define K_BSP	8		/* backspace                     */
#define K_HOME	8		/* backspace                     */
#define K_TAB	9		/* tabulator                     */
#define K_START	1		/* cursor right at the beginning */
#define K_END	5		/* cursor right at the end       */
#define K_CR	10		/* carriage return               */
#define K_SPC	32		/* space bar                     */
#define K_DEL	127		/* delete                        */
#define K_LEFT	12		/* cursor left                   */
#define K_RIGHT	18		/* cursor right                  */
#define K_UP	16		/* cursor up                     */
#define K_DOWN	14		/* cursor down                   */
#define K_UNDO	21		/* undo                          */
#define K_ESC	27		/* escape                        */
#define K_C_D	4		/* ctrl-d                        */
#define K_C_X	24		/* ctrl-x                        */
#define KEYCODES
#endif

#ifndef KEYC
extern short	GetKey();
#endif

extern void	initCurses();
extern void	fc_exit();
extern void	updateWinsize();
extern void	reportError(WINDOW *, char *, char *, int);
extern void	resizeNotice();
extern void	writeXY(short, short, char *, short);
extern void	edit(short, short, char *, char *,short *);
extern void	setupResourcePath(const char*, const char*, char*);
extern void	helpMenu(WINDOW *);
extern void	showTitle(char *, char *);
extern void	showCalculationNote(char *, char *, char *);
extern void	showViewerStatus(WINDOW *, int, int);
extern void	showDataset(int, char *, ...);
extern void	moreViewer(WINDOW **, line *, line **, line **, int, int *);
extern void	saveData(FILE *, char *, int, line *, char *);
extern void	saveDataset(WINDOW *, char *, int, ...);
