/*  **************************************************************************
 * 
 * --- File: gexpr.h
 * 
 * --- Purpose: header file for gexpr.
 * 
 * --- Copyright (C) Guido Gonzato, guido@ibogeo.df.unibo.it
 * 
 * --- Last updated: 31 May 2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */

#ifndef GEXPR_H
#define GEXPR_H

#include <setjmp.h>	/* for longjmp() */

/* a few constants */

#define PROGNAME		"gexpr"
#define VERSION			"2.0.2"
#define DATE			"31 May 2001"

#define MAX_TOKEN_LENGTH	80

/* the ubiquitous boolean type */

typedef enum { FALSE, TRUE } BOOL;

/* where the input comes from */

typedef enum { STDIN, ARGV_1 } WHERE;

/* these are the possible tokens that make up an expression */

typedef enum {
  T_NONE, T_ERROR, T_END, T_EOF, T_EOL, T_COMMA, T_DIGIT, T_IDENT,
  T_CONST, T_FUNCTION, T_COMMAND, T_MISC, T_OP_PLUS, T_OP_MINUS, 
  T_OP_MULT, T_OP_DIV, T_OPEN_PAR, T_CLOSED_PAR, 
  T_REL, T_EQ, T_LE, T_LT, T_GE, T_GT
} TOKEN_TYPE;

/* now let's define what a token is */

typedef struct {
  TOKEN_TYPE 	type; 				/* what's this token? */
  char		string[MAX_TOKEN_LENGTH];	/* token as string */
  double	value;				/* its value, if a number */
  short		args;				/* argument(s), if function */
} TOKEN;

/* these are all the available functions, except the static ones */

void	handle_command (const char *);		/* defined in commands.c*/
void	error (const char *, TOKEN_TYPE);	/* defined in errors.c	*/
void	flush_stdin (void);			/* ditto */
double	expression (void);			/* defined in eval.c	*/
void	output (double);		       	/* defined in output.c	*/
double  my_strtod (const char *, char **);	/* ditto */
TOKEN	read_token (void);			/* defined in read_token.c */
void	check_token (TOKEN_TYPE, TOKEN_TYPE);	/* ditto */	
double  function_value (short, double, double);	/* ditto */

/* "only" six global variables: first, where to jump in case of error */

extern jmp_buf jump; /* defined in gexpr.c */

/* second, whether a token has already been read. Some functions read 
 * tokens and stop when they find one they can't use. It would be nice to 
 * have something like ungetc() to send back the token we don't want. When 
 * a function reads a token it can't use, it sets token_read to
 * TRUE; upon the next call, read_token() will return the old token.
 */

extern BOOL token_read; /* defined in gexpr.c */

/* third, whether the program is over
 */

extern BOOL program_over; /* defined in gexpr.c */

/* fourth, where the input comes from: stdin or argv[1]
 */

extern WHERE input_source; /* defined in gexpr.c */

/* fifth, a pointer to the expression if it is a string
 */

extern char *expression_source; /* defined in gexpr.c */

/* sixth, the output base (2 to 16)
 */

extern int output_base; /* defined in output.c */

#endif

/* --- End of file gexpr.h --- */
