/* UDP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 */
/* Mods by PA0GRI */
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "udp.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: udpdump.c,v 1.11 2000/05/09 16:48:29 brian Exp $";
#endif

void rwho_dump (FILE *fp,struct mbuf **bpp);

/* Dump a UDP header */
void
udp_dump(fp,bpp,source,dest,check)
FILE *fp;
struct mbuf **bpp;
uint32 source,dest;
int check;		/* If 0, bypass checksum verify */
{
struct udp udp;
struct pseudo_header ph;
int16 csum;

	if (bpp == NULLBUFP || *bpp == NULLBUF)
		return;

#ifdef CTRACE
	if (use_ctrace)
		traceprintf (fp, Agreen);
#endif
	traceprintf (fp, "UDP:");

	/* Compute checksum */
	ph.source = source;
	ph.dest = dest;
	ph.protocol = UDP_PTCL;
	ph.length = len_p (*bpp);
	if ((csum = cksum (&ph, *bpp, ph.length)) == 0)
		check = 0;	/* No checksum error */

	(void) ntohudp (&udp, bpp);

	traceprintf (fp, " len %u", udp.length);
#ifdef CTRACE
	if (use_ctrace)
		traceprintf (fp, " %s%u%s->%s%u%s", Abold, udp.source, Aboldoff, Abold, udp.dest, Aboldoff);
	else
#endif
	traceprintf (fp, " %u->%u", udp.source, udp.dest);
	if (udp.length > UDPHDR)
		traceprintf (fp, " Data %u", udp.length - UDPHDR);
	if (udp.checksum == 0)
		check = 0;
	if (check)
		traceprintf (fp, " CHECKSUM ERROR (%u)", csum);

	traceprintf (fp, "\n");

	/*lint -e744 */
	switch (udp.dest)	{
#ifdef RIP
		case IPPORT_RIP:	rip_dump (fp, bpp);
					break;
#endif
		case IPPORT_RWHO:	rwho_dump (fp, bpp);
	}
}

