#ifndef	_TELNET_H
#define	_TELNET_H

#ifndef _SESSION_H
#include "session.h"
#endif

#define	LINESIZE	256	/* Length of local editing buffer */

/* Telnet command characters */
#define	IAC		255	/* Interpret as command */
#define	WILL		251
#define	WONT		252
#define	DO		253
#define	DONT		254
#define CLEARSCREEN     247
#define CLEARSPLIT      249
#define COMPRESSED      248
#define	SB		250
#define	SE		240

#define TN_LINEMODE 34

#define	TS_IS		0
#define	TS_SEND		1

/* Telnet options */
#define	TN_TRANSMIT_BINARY	0
#define	TN_ECHO			1
#define	TN_SUPPRESS_GA		3
#define	TN_STATUS		5
#define	TN_TIMING_MARK		6
#define	NOPTIONS		6

/* Telnet protocol control block */
struct telnet {
	char local[NOPTIONS+1];	/* Local option settings */
	char remote[NOPTIONS+1];	/* Remote option settings */
	struct session *session;	/* Pointer to session structure */
	char eolmode;		/* Control translation of enter key */
};
#define	NULLTN	(struct telnet *)0

/* In telnet.c: */
int tel_connect (struct session *sp,char *fsocket,int len);
void tnrecv (struct telnet *tn);

/* In ttylink.c: */
void ttylhandle (int s,void *unused,void *p);

#endif	/* _TELNET_H */

