#include "global.h"
#ifdef STATS_MSG
#include "stats.h"
#include "stats_m.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: stats_m.c,v 1.9 1997/07/31 00:44:20 root Exp $";
#endif

static struct msg_stats msgstats;


static const char msgdailyhdr[] = "%8.8s%-35.35sOUTGOING\n\n";
static const char msgweeklyhdr[] = "%12.12s%-40.40sOUTGOING\n\n";
static const char incomingstr[] = "INCOMING";
static const char messagesstr[] = "Messages";
static const char msgmonthlyhdr[] = "%12.12s%-42.42sOUTGOING\n\n";
static const char msgyearlyhdr[] = "%2.2s%-23.23sOUTGOING\n\n";


static struct cmds STATSmsgcmds[] = {
	{ "clear",	doSTATclear_msg,0,	0,	NULLCHAR },
	{ "daily",	STATdaily_msg,	0,	0,	NULLCHAR },
	{ "general",	STATgeneral_msg,0, 	0,	NULLCHAR },
	{ "monthly",	STATmonthly_msg,0, 	0,	NULLCHAR },
	{ "weekly",	STATweekly_msg,	0, 	0,	NULLCHAR },
	{ "yearly",	STATyearly_msg,	0, 	0,	NULLCHAR },
	{ NULLCHAR,	NULL,		0,	0,	NULLCHAR }
};



int
doSTATmessage(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(STATSmsgcmds,argc,argv,p);
}


int
doSTATclear_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	if(Curproc->input != Command->input)
		tputs (STAT_cannotclear);
	else	{
		memset (&msgstats, 0, sizeof (struct msg_stats));
		msgstats.days = 1;
		msgstats.start = time((time_t *)0);
		savestats_msg();
		log (-1, "Clearing message stats");
	}
	return 0;
}


int
STATgeneral_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
char buf1[26], buf2[26], buf3[36];
int temp, l;
int highest[2], second[2];

	tprintf ("\n%26.26s: %-26.26s%-24.24s\n", "MESSAGES", incomingstr, "OUTGOING");
	sprintf (buf1, "%ld", msgstats.messages[0]);
	sprintf (buf2, "%ld", msgstats.messages[1]);
	sprintf (buf3, "Messages since %6.6s", &(ctime(&msgstats.start))[4]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", buf3, buf1, buf2);
	sprintf (buf1, "%ld", msgstats.day[0]);
	sprintf (buf2, "%ld", msgstats.day[1]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", "Messages since midnight",
		buf1, buf2);
	sprintf (buf1, "%ld", msgstats.hour[0]);
	sprintf (buf2, "%ld", msgstats.hour[1]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", "Messages this hour",
		buf1, buf2);
	sprintf (buf1, "%d", (msgstats.days > 1) ? (int)((msgstats.messages[0] - msgstats.day[0] + (msgstats.days - 2)) / (msgstats.days - 1)) : (int)msgstats.messages[0]);
	sprintf (buf2, "%d", (msgstats.days > 1) ? (int)((msgstats.messages[1] - msgstats.day[1] + (msgstats.days - 2)) / (msgstats.days - 1)) : (int)msgstats.messages[1]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", "Average messages per day",
		buf1, buf2);
	highest[0] = highest[1] = -1;
	second[0] = second[1] = -1;
	for (temp = 0; temp < 24; temp++)
		for (l = 0; l < 2; l++)	{
			if (highest[l] == -1 || msgstats.hourly[temp][l] > msgstats.hourly[highest[l]][l])	{
				second[l] = highest[l];
				highest[l] = temp;
			} else if (second[l] == -1 || msgstats.hourly[temp][l] > msgstats.hourly[second[l]][l])
				second[l] = temp;
		}
	sprintf (buf1, "At %02d and %02d o'clock", highest[0], second[0]);
	sprintf (buf2, "At %02d and %02d o'clock", highest[1], second[1]);
	tprintf ("%26.26s: %-26.26s%-24.24s\n\n", "Rush hours", buf1, buf2);
	return 0;
}


int
STATdaily_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	tprintf (dailyhdr, messagesstr);
	tprintf (msgdailyhdr, STAT_emptystr,incomingstr);
	doGraph (24, msgstats.hourly);
	tputs (STAT_dailytrailer);
	return 0;
}


int
STATweekly_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	tprintf (weeklyhdr, messagesstr);
	tprintf (msgweeklyhdr, STAT_emptystr,incomingstr);
	doGraph (7, msgstats.daily);
	tputs (STAT_weeklytrailer);
	return 0;
}


int
STATmonthly_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	tprintf (monthlyhdr, messagesstr);
	tprintf (msgmonthlyhdr, STAT_emptystr,incomingstr);
	doGraph (31, msgstats.monthly);
	tputs (STAT_monthlytrailer);
	return 0;
}


int
STATyearly_msg(argc,argv,p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	tprintf (yearlyhdr, messagesstr);
	tprintf (msgyearlyhdr, STAT_emptystr,incomingstr);
	doGraph (12, msgstats.yearly);
	tputs (STAT_yearlytrailer);
	return 0;
}


void
STATS_addmsg (int which, int amount)
{
	if (which < 0 || which > 1)
		return;
	msgstats.messages[which] += amount;
	msgstats.hour[which] += amount;
	msgstats.day[which] += amount;
	msgstats.month[which] += amount;
}


void
updatestats_msg (void)
{
	/* nothing, at this time - addmsgstats() does all the work */
}


void
loadstats_msg(void)
{
FILE *fp;
char buffer[256];

	sprintf (buffer, "%s/message.dat", STATSDir);
	fp = fopen (buffer, "r");
	if (fp != NULLFILE)	{
		(void) fread (&msgstats, sizeof (struct msg_stats), 1, fp);
		(void) fclose (fp);
	}
}


void
savestats_msg(void)
{
FILE *fp;
char buffer[256];

	sprintf (buffer, "%s/message.dat", STATSDir);
	fp = fopen (buffer, "w");
	if (fp != NULLFILE)	{
		fwrite (&msgstats, sizeof (struct msg_stats), 1, fp);
		(void) fclose (fp);
	} else
		log (-1, "Can't open stats file '%s/message.dat'", STATSDir);
}


void
newhour_msg (int hour)
{
	msgstats.hourly[hour][0] = msgstats.hour[0];
	msgstats.hourly[hour][1] = msgstats.hour[1];
	msgstats.hour[0] = msgstats.hour[1] = 0;
}


void
newday_msg (int day)
{
	msgstats.daily[day][0] = msgstats.day[0];
	msgstats.daily[day][1] = msgstats.day[1];
}


void
endmonthclear_msg (int day, int month)
{
int k;
FILE *fp;

	/* clear out non-existent days of last month */
	for (k = day; k < 31; k++)
		msgstats.monthly[k][0] = msgstats.monthly[k][1] = 0L;
	msgstats.yearly[month][0] = msgstats.month[0];
	msgstats.yearly[month][1] = msgstats.month[1];
	fp = tmpfile();
	if (fp)	{
		fprintf (fp, "Monthly Message Stats for the month of %s: %s\n\n", Months[month], Hostname);
		fprintf (fp, "Incoming: %ld\nOutgoing: %ld\n", msgstats.month[0], msgstats.month[1]);
		rewind (fp);
		(void) rdaemon (fp, NULLCHAR, NULLCHAR, "sysop", "Monthly Message Stats", 'P', 0);
		(void) fclose (fp);
	}
	msgstats.month[0] = msgstats.month[1] = 0;
}


void
endday_msg (int day)
{
	msgstats.monthly[day][0] = msgstats.day[0];
	msgstats.monthly[day][1] = msgstats.day[1];
	msgstats.day[0] = msgstats.day[1] = 0;
	msgstats.days++;
}


void
eachcycle_msg (time_t now)
{
	msgstats.last = now;
}


void
init_msg (time_t now)
{
	msgstats.days = 1;
	msgstats.start = now;
}


#endif /* STATS_MSG */
