/* Help engine:
 *
 * Copyright 1993 Brian A. Lantz, KO4KS
 */
#include "global.h"
#include "cmdparse.h"
#include "help.h"
#include "files.h"
#include "socket.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: help.c,v 1.17 1997/08/19 01:19:22 root Exp $";
#endif

extern struct cmds Mbcmds[];
extern struct cmds Cmds[];

static int ours (const char *buf, const char *search);


static int
ours (buf, search)
const char *buf, *search;
{
char buf2[82], search2[82];

	if (strchr (buf, '*'))
		return ((search == NULLCHAR) ? 1 : 0);
	if (search == NULLCHAR)
		return 1;
	strncpy (buf2, buf, 82);
	strncpy (&search2[1], search, 81);
	search2[0] = ':';
	(void) strlwr (buf2);
	(void) strlwr (search2);
	return ((int)strstr (buf2, search2));
}


void
dohelper(title,cmdp,stopstr,filename,search)
const char *title, *stopstr, *search, *filename;
register struct cmds *cmdp;
{
int i;
char buf[82];
struct cmds *saved;
int width = 0, count;
FILE *fp;

	saved = cmdp;
	for ( ; cmdp && cmdp->name != NULL; cmdp++)
		width = ((int)strlen(cmdp->name) > width) ? (int) strlen(cmdp->name) : width;
	width += 1;
	count = (79 / width);
	cmdp = saved;
	if (title && (filename == NULLCHAR || search == NULLCHAR))
		tputs(title);
	if (filename == NULLCHAR)	{	/* '?' commands	*/
		tputs (" ");
		memset(buf,' ',sizeof(buf));
		buf[77] = '\n';
		buf[78] = '\0';
		for(i=0;cmdp->name != NULL;cmdp++,i = ((i+1) % count)){
			if (stopstr && !stricmp (cmdp->name, stopstr))
				break;
			strncpy(&buf[i * width],cmdp->name,strlen(cmdp->name));
			if(i == (count - 1)){
				tprintf("%s ", buf);
				memset(buf,' ',77);
			}
		}
		if(i != 0)
			tputs(buf);
		else
			tputc ('\b');
		return;
	}
	if ((fp = fopen (filename, READ_TEXT)) != NULLFILE)	{
		if ((search != NULLCHAR) && cmdp)
			tputs ("Usage:\n");
		count = 0;
		do	{
			if (fgets (buf, 80, fp))	{
				if (*buf == '#')
					continue;	/* skip comments	*/
				if (*buf != ':')	{
					if (count)	{
						count--;
/*						if (search != NULLCHAR)
							tputs ("  ");
						tputs (buf);		*/
						tprintf ("  %s", buf);
					}
				} else	{	/* start of field or continuation */
					count = (ours (buf, search)) ? 32000 : 0;
					if (search == NULLCHAR && count)
						count = 1;
					if (buf[1] == ':' && count == 1)
						count--;
				}
			}
		} while (!feof (fp));
		(void) fclose (fp);
	}
}

int
dohelp(argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	dohelper ("Main commands:\n", &Cmds[1], "a:", (argv[0][0] == '?' && argc == 1) ? NULLCHAR : CommandHelp, (argc == 2) ? argv[1] : NULLCHAR);
	return 0;
}


#if 0
int
syntax(cmd)
char *cmd;
{
	dohelper (NULLCHAR, &Cmds[1], "a:", CommandHelp, cmd);
	return 0;
}
#endif

int
dombxhelp(argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
char buf[255];

	sprintf (buf, "Mailbox Commands for %s at %s\n\n", Version, Hostname);
	dohelper (buf, &Mbcmds[1], "[", (argv[0][0] == '?' && argc == 1) ? NULLCHAR : PBBSHelp, (argc == 2) ? argv[1] : NULLCHAR);
	return 0;
}


#if 0
int
mbxsyntax(cmd)
char *cmd;
{
	dohelper (NULLCHAR, &Mbcmds[1], "[", PBBSHelp, cmd);
	return 0;
}
#endif


